/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.ep.service.infinispan;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.transaction.TransactionMode;
import org.overlord.rtgov.common.infinispan.InfinispanManager;
import org.overlord.rtgov.ep.service.CacheManager;

public class InfinispanCacheManager
extends CacheManager {
    private static final Logger LOG = Logger.getLogger(InfinispanCacheManager.class.getName());
    private String _container = null;
    private CacheContainer _cacheContainer = null;

    public void setContainer(String jndiName) {
        this._container = jndiName;
    }

    public String getContainer() {
        return this._container;
    }

    protected CacheContainer getCacheContainer() {
        if (this._cacheContainer == null) {
            this._cacheContainer = InfinispanManager.getCacheContainer((String)this._container);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Returning cache container [container=" + this._container + "] = " + this._cacheContainer);
        }
        return this._cacheContainer;
    }

    public <K, V> Map<K, V> getCache(String name) {
        CacheContainer container = this.getCacheContainer();
        if (container == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Requested cache '" + name + "', but no cache container (" + this._container + ")");
            }
            return null;
        }
        Cache ret = container.getCache(name);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Returning cache '" + name + "' = " + ret);
        }
        return ret;
    }

    public boolean lock(String cacheName, Object key) {
        CacheContainer container;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("About to lock: " + cacheName + " key=" + key);
        }
        if ((container = this.getCacheContainer()) != null) {
            Cache cache = container.getCache(cacheName);
            if (cache != null) {
                if (cache.getAdvancedCache().getCacheConfiguration().transaction().transactionMode() != TransactionMode.TRANSACTIONAL) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Not transactional, so returning true");
                    }
                    return true;
                }
                boolean ret = cache.getAdvancedCache().lock(new Object[]{key});
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Lock '" + cacheName + "' key '" + key + "' = " + ret);
                }
                return ret;
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Cannot lock cache '" + cacheName + "' key '" + key + "' as cache does not exist");
            }
        } else if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Cannot lock cache '" + cacheName + "' key '" + key + "' as no container");
        }
        return false;
    }
}

