/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.services;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.atom.Link;
import org.jboss.resteasy.plugins.providers.atom.Person;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.visitors.ArtifactToSummaryAtomEntryVisitor;
import org.overlord.sramp.repository.QueryManager;
import org.overlord.sramp.repository.QueryManagerFactory;
import org.overlord.sramp.repository.query.ArtifactSet;
import org.overlord.sramp.repository.query.SrampQuery;
import org.overlord.sramp.visitors.ArtifactVisitor;
import org.overlord.sramp.visitors.ArtifactVisitorHelper;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public abstract class AbstractFeedResource {
    protected AbstractFeedResource() {
    }

    protected Feed createArtifactFeed(String query, Integer page, Integer pageSize, String orderBy, Boolean ascending, Set<String> propNames) throws SrampAtomException {
        if (page == null) {
            page = 0;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        if (orderBy == null) {
            orderBy = "name";
        }
        if (ascending == null) {
            ascending = true;
        }
        ArtifactSet artifactSet = null;
        try {
            QueryManager queryManager = QueryManagerFactory.newInstance();
            SrampQuery srampQuery = queryManager.createQuery(query, orderBy, ascending.booleanValue());
            artifactSet = srampQuery.executeQuery();
            int startIdx = page * pageSize;
            int endIdx = startIdx + pageSize - 1;
            Feed feed = this.createFeed(artifactSet, startIdx, endIdx, propNames);
            this.addPaginationLinks(feed, artifactSet, query, page, pageSize, orderBy, ascending);
            Feed feed2 = feed;
            return feed2;
        }
        catch (Throwable e) {
            throw new SrampAtomException(e);
        }
        finally {
            if (artifactSet != null) {
                artifactSet.close();
            }
        }
    }

    private Feed createFeed(ArtifactSet artifactSet, int fromRow, int toRow, Set<String> propNames) throws Exception {
        Feed feed = new Feed();
        feed.setId(new URI(UUID.randomUUID().toString()));
        feed.setTitle("S-RAMP Feed");
        feed.setSubtitle("Ad Hoc query feed");
        feed.setUpdated(new Date());
        feed.getAuthors().add(new Person("anonymous"));
        Iterator iterator = artifactSet.iterator();
        for (int i = 0; i < fromRow && iterator.hasNext(); ++i) {
            iterator.next();
        }
        ArtifactToSummaryAtomEntryVisitor visitor = new ArtifactToSummaryAtomEntryVisitor(propNames);
        for (int i = fromRow; i <= toRow && iterator.hasNext(); ++i) {
            BaseArtifactType artifact = (BaseArtifactType)iterator.next();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
            Entry entry = visitor.getAtomEntry();
            feed.getEntries().add(entry);
            visitor.reset();
        }
        return feed;
    }

    private void addPaginationLinks(Feed feed, ArtifactSet artifactSet, String query, int page, int pageSize, String orderBy, boolean ascending) throws UnsupportedEncodingException {
        String endpoint = "http://localhost:8080/s-ramp-atom/s-ramp";
        String hrefPattern = "%1$s?query=%2$s&page=%3$s&pageSize=%4$s&orderBy=%5$s&ascending=%6$s";
        String encodedQuery = URLEncoder.encode(query, "UTF-8");
        String firstHref = String.format(hrefPattern, endpoint, encodedQuery, 0, String.valueOf(pageSize), String.valueOf(orderBy), String.valueOf(ascending));
        String prevHref = String.format(hrefPattern, endpoint, encodedQuery, page - 1, String.valueOf(pageSize), String.valueOf(orderBy), String.valueOf(ascending));
        String nextHref = String.format(hrefPattern, endpoint, encodedQuery, page + 1, String.valueOf(pageSize), String.valueOf(orderBy), String.valueOf(ascending));
        Link first = new Link("first", firstHref, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_FEED_TYPE);
        Link prev = new Link("prev", prevHref, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_FEED_TYPE);
        Link next = new Link("next", nextHref, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_FEED_TYPE);
        if (page > 0) {
            feed.getLinks().add(first);
            feed.getLinks().add(prev);
        }
        if (artifactSet.iterator().hasNext()) {
            feed.getLinks().add(next);
        }
    }
}

