/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.services;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.overlord.sramp.ArtifactType;
import org.overlord.sramp.ArtifactTypeEnum;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.mime.MimeTypes;
import org.overlord.sramp.atom.visitors.ArtifactContentTypeVisitor;
import org.overlord.sramp.atom.visitors.ArtifactToFullAtomEntryVisitor;
import org.overlord.sramp.repository.DerivedArtifactsFactory;
import org.overlord.sramp.repository.PersistenceFactory;
import org.overlord.sramp.repository.PersistenceManager;
import org.overlord.sramp.visitors.ArtifactVisitor;
import org.overlord.sramp.visitors.ArtifactVisitorHelper;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.DerivedArtifactType;

@Path(value="/s-ramp")
public class ArtifactResource {
    @POST
    @Path(value="{model}/{type}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@HeaderParam(value="Content-Type") String contentType, @HeaderParam(value="Slug") String fileName, @PathParam(value="model") String model, @PathParam(value="type") String type, InputStream content) throws SrampAtomException {
        InputStream is = content;
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type);
            if (artifactType.getArtifactType().isDerived()) {
                throw new Exception("Failed to create artifact because '" + artifactType.getArtifactType() + "' is a derived type.");
            }
            String mimeType = ArtifactResource.determineMimeType(contentType, fileName, artifactType);
            artifactType.setMimeType(mimeType);
            if (fileName == null) {
                fileName = artifactType.getArtifactType() == ArtifactTypeEnum.Document ? "newartifact.bin" : (artifactType.getArtifactType() == ArtifactTypeEnum.XmlDocument ? "newartifact.xml" : "newartifact." + artifactType.getArtifactType().getModel());
            }
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType artifact = persistenceManager.persistArtifact(fileName, artifactType, is);
            Collection dartifacts = DerivedArtifactsFactory.newInstance().createDerivedArtifacts(artifactType, artifact);
            for (DerivedArtifactType dartifact : dartifacts) {
                persistenceManager.persistDerivedArtifact(dartifact);
            }
            ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
            Entry entry = visitor.getAtomEntry();
            return entry;
        }
        catch (Exception e) {
            throw new SrampAtomException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private static String determineMimeType(String contentType, String fileName, ArtifactType artifactType) {
        if (artifactType.getArtifactType() == ArtifactTypeEnum.Document || artifactType.getArtifactType() == ArtifactTypeEnum.UserDefined) {
            String ct;
            if (contentType != null && contentType.trim().length() > 0) {
                return contentType;
            }
            if (fileName != null && (ct = MimeTypes.getContentType((String)fileName)) != null) {
                return ct;
            }
            return "application/octet-stream";
        }
        return "application/xml";
    }

    @PUT
    @Path(value="{model}/{type}/{uuid}")
    @Consumes(value={"application/atom+xml;type=entry"})
    public void updateMetaData(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid, Entry atomEntry) throws SrampAtomException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type);
            BaseArtifactType artifact = SrampAtomUtils.unwrapSrampArtifact((ArtifactType)artifactType, (Entry)atomEntry);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            persistenceManager.updateArtifact(artifact, artifactType);
        }
        catch (Throwable e) {
            throw new SrampAtomException(e);
        }
    }

    @PUT
    @Path(value="{model}/{type}/{uuid}/media")
    public void updateContent(@HeaderParam(value="Content-Type") String contentType, @HeaderParam(value="Slug") String fileName, @PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid, InputStream content) throws SrampAtomException {
        ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type);
        if (artifactType.getArtifactType().isDerived()) {
            throw new SrampAtomException("Failed to create artifact because '" + artifactType.getArtifactType() + "' is a derived type.");
        }
        String mimeType = ArtifactResource.determineMimeType(contentType, fileName, artifactType);
        artifactType.setMimeType(mimeType);
        InputStream is = content;
        try {
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            persistenceManager.updateArtifactContent(uuid, artifactType, is);
        }
        catch (Exception e) {
            throw new SrampAtomException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @GET
    @Path(value="{model}/{type}/{uuid}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry getMetaData(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws SrampAtomException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType artifact = persistenceManager.getArtifact(uuid, artifactType);
            if (artifact == null) {
                throw new Exception("Artifact not found.");
            }
            ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
            return visitor.getAtomEntry();
        }
        catch (Throwable e) {
            throw new SrampAtomException(e);
        }
    }

    @GET
    @Path(value="{model}/{type}/{uuid}/media")
    public Response getContent(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws SrampAtomException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType artifact = persistenceManager.getArtifact(uuid, artifactType);
            ArtifactContentTypeVisitor ctVizzy = new ArtifactContentTypeVisitor();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)ctVizzy, (BaseArtifactType)artifact);
            MediaType mediaType = ctVizzy.getContentType();
            artifactType.setMimeType(mediaType.toString());
            final InputStream artifactContent = persistenceManager.getArtifactContent(uuid, artifactType);
            StreamingOutput output = new StreamingOutput(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void write(OutputStream output) throws IOException, WebApplicationException {
                    try {
                        IOUtils.copy((InputStream)artifactContent, (OutputStream)output);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)artifactContent);
                    }
                }
            };
            return Response.ok((Object)output, (String)artifactType.getMimeType()).build();
        }
        catch (Throwable e) {
            throw new SrampAtomException(e);
        }
    }

    @DELETE
    @Path(value="{model}/{type}/{uuid}")
    public void delete(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws SrampAtomException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            persistenceManager.deleteArtifact(uuid, artifactType);
        }
        catch (Throwable e) {
            throw new SrampAtomException(e);
        }
    }
}

