/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.services;

import java.io.InputStream;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.annotations.providers.multipart.PartType;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.multipart.MultipartOutput;
import org.overlord.sramp.ArtifactType;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.atom.beans.HttpResponseBean;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.err.SrampAtomExceptionMapper;
import org.overlord.sramp.atom.visitors.ArtifactContentTypeVisitor;
import org.overlord.sramp.atom.visitors.ArtifactToFullAtomEntryVisitor;
import org.overlord.sramp.repository.DerivedArtifactsFactory;
import org.overlord.sramp.repository.PersistenceFactory;
import org.overlord.sramp.repository.PersistenceManager;
import org.overlord.sramp.visitors.ArtifactVisitor;
import org.overlord.sramp.visitors.ArtifactVisitorHelper;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.DerivedArtifactType;

@Path(value="/s-ramp")
public class BatchResource {
    @POST
    @Consumes(value={"application/zip"})
    @Produces(value={"multipart/mixed"})
    @PartType(value="message/http")
    public MultipartOutput zipPackage(@HeaderParam(value="Slug") String fileName, InputStream content) throws SrampAtomException {
        InputStream is = content;
        SrampArchive archive = null;
        try {
            archive = new SrampArchive(content);
            MultipartOutput output = new MultipartOutput();
            output.setBoundary("package");
            Collection entries = archive.getEntries();
            for (SrampArchiveEntry entry : entries) {
                BaseArtifactType metaData = entry.getMetaData();
                InputStream contentStream = archive.getInputStream(entry);
                this.processBatchEntry(output, entry.getPath(), metaData, contentStream);
            }
            MultipartOutput multipartOutput = output;
            return multipartOutput;
        }
        catch (Exception e) {
            throw new SrampAtomException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            if (archive != null) {
                SrampArchive.closeQuietly((SrampArchive)archive);
            }
        }
    }

    private void processBatchEntry(MultipartOutput output, String path, BaseArtifactType metaData, InputStream contentStream) {
        block6: {
            String contentId = String.format("<%1$s@package>", path);
            try {
                ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)metaData);
                if (artifactType.getArtifactType().isDerived()) {
                    throw new Exception("Failed to create artifact because '" + artifactType.getArtifactType() + "' is a derived type.");
                }
                ArtifactContentTypeVisitor ctVizzy = new ArtifactContentTypeVisitor();
                ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)ctVizzy, (BaseArtifactType)metaData);
                String mimeType = ctVizzy.getContentType().toString();
                artifactType.setMimeType(mimeType);
                if (metaData.getUuid() == null && contentStream != null) {
                    Entry atomEntry = this.processCreate(artifactType, metaData, contentStream);
                    this.addCreatedPart(output, contentId, atomEntry);
                    break block6;
                }
                if (metaData.getUuid() != null && contentStream != null) {
                    Entry atomEntry = this.processUpdateOrCreate(artifactType, metaData, contentStream);
                    this.addCreatedPart(output, contentId, atomEntry);
                    break block6;
                }
                if (metaData.getUuid() != null && contentStream == null) {
                    Entry atomEntry = this.processUpdate(artifactType, metaData);
                    this.addCreatedPart(output, contentId, atomEntry);
                    break block6;
                }
                throw new Exception("Unsupported path (TBD).");
            }
            catch (Exception e) {
                HttpResponseBean errorResponse = new HttpResponseBean(409, "Conflict");
                String stacktrace = SrampAtomExceptionMapper.getRootStackTrace((Throwable)e);
                errorResponse.setBody((Object)stacktrace, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_STACKTRACE_TYPE);
                output.addPart((Object)errorResponse, (javax.ws.rs.core.MediaType)MediaType.MESSAGE_HTTP_TYPE).getHeaders().putSingle((Object)"Content-ID", (Object)contentId);
            }
        }
    }

    private Entry processCreate(ArtifactType artifactType, BaseArtifactType metaData, InputStream contentStream) throws Exception {
        PersistenceManager persistenceManager = PersistenceFactory.newInstance();
        BaseArtifactType artifact = persistenceManager.persistArtifact(metaData.getName(), artifactType, contentStream);
        Collection dartifacts = DerivedArtifactsFactory.newInstance().createDerivedArtifacts(artifactType, artifact);
        for (DerivedArtifactType dartifact : dartifacts) {
            persistenceManager.persistDerivedArtifact(dartifact);
        }
        metaData.setUuid(artifact.getUuid());
        persistenceManager.updateArtifact(metaData, artifactType);
        artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
        ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor();
        ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
        Entry atomEntry = visitor.getAtomEntry();
        return atomEntry;
    }

    private Entry processUpdateOrCreate(ArtifactType artifactType, BaseArtifactType metaData, InputStream contentStream) throws Exception {
        PersistenceManager persistenceManager = PersistenceFactory.newInstance();
        BaseArtifactType artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
        if (artifact == null) {
            return this.processCreate(artifactType, metaData, contentStream);
        }
        persistenceManager.updateArtifact(metaData, artifactType);
        persistenceManager.updateArtifactContent(metaData.getUuid(), artifactType, contentStream);
        artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
        ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor();
        ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
        Entry atomEntry = visitor.getAtomEntry();
        return atomEntry;
    }

    private Entry processUpdate(ArtifactType artifactType, BaseArtifactType metaData) throws Exception {
        PersistenceManager persistenceManager = PersistenceFactory.newInstance();
        BaseArtifactType artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
        if (artifact == null) {
            throw new Exception("Could not update artifact with UUID: " + metaData.getUuid() + " (Not Found)");
        }
        persistenceManager.updateArtifact(metaData, artifactType);
        artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
        ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor();
        ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
        Entry atomEntry = visitor.getAtomEntry();
        return atomEntry;
    }

    private void addCreatedPart(MultipartOutput output, String contentId, Entry atomEntry) {
        HttpResponseBean createdResponse = new HttpResponseBean(201, "Created");
        createdResponse.setBody((Object)atomEntry, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_ENTRY_TYPE);
        output.addPart((Object)createdResponse, (javax.ws.rs.core.MediaType)MediaType.MESSAGE_HTTP_TYPE).getHeaders().putSingle((Object)"Content-ID", (Object)contentId);
    }
}

