/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.archive;

import java.io.File;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.s_ramp.xmlns._2010.s_ramp.Artifact;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public class SrampArchiveJaxbUtils {
    private static JAXBContext jaxbContext;

    private static JAXBContext getJaxbContext() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Entry.class, Artifact.class});
        }
        return jaxbContext;
    }

    public static BaseArtifactType readMetaData(File metaDataFile) throws JAXBException {
        try {
            Unmarshaller unmarshaller = SrampArchiveJaxbUtils.getJaxbContext().createUnmarshaller();
            Entry entry = (Entry)unmarshaller.unmarshal(metaDataFile);
            return SrampAtomUtils.unwrapSrampArtifact(entry);
        }
        catch (JAXBException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new JAXBException(t);
        }
    }

    public static void writeMetaData(File outputFile, BaseArtifactType artifact) throws JAXBException {
        SrampArchiveJaxbUtils.writeMetaData(outputFile, artifact, true);
    }

    public static void writeMetaData(File outputFile, BaseArtifactType artifact, boolean wrap) throws JAXBException {
        try {
            Marshaller marshaller = SrampArchiveJaxbUtils.getJaxbContext().createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            Entry atomEntry = SrampAtomUtils.wrapSrampArtifact(artifact);
            if (wrap) {
                marshaller.marshal((Object)atomEntry, outputFile);
            } else {
                marshaller.marshal(atomEntry.getAnyOtherJAXBObject(), outputFile);
            }
        }
        catch (JAXBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)e);
        }
    }

    public static void writeMetaData(OutputStream outputStream, BaseArtifactType artifact) throws JAXBException {
        try {
            Entry atomEntry = SrampAtomUtils.wrapSrampArtifact(artifact);
            Marshaller marshaller = SrampArchiveJaxbUtils.getJaxbContext().createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)atomEntry, outputStream);
        }
        catch (JAXBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)e);
        }
    }
}

