/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common;

import java.net.URL;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sramp {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static Configuration configuration = null;

    public Sramp() {
        if (configuration == null) {
            this.read();
        }
    }

    public synchronized void read() {
        try {
            CompositeConfiguration config = new CompositeConfiguration();
            config.addConfiguration((Configuration)new SystemConfiguration());
            String configFile = config.getString("sramp.config.file.name", "/sramp.properties");
            Long refreshDelay = config.getLong("sramp.config.file.refresh", 5000L);
            URL url = Sramp.class.getClassLoader().getResource(configFile);
            if (url == null) {
                this.log.warn("Cannot find " + configFile);
            } else {
                PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(url);
                FileChangedReloadingStrategy fileChangedReloadingStrategy = new FileChangedReloadingStrategy();
                fileChangedReloadingStrategy.setRefreshDelay(refreshDelay.longValue());
                propertiesConfiguration.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
                config.addConfiguration((Configuration)propertiesConfiguration);
            }
            configuration = config;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String getBaseUrl(String requestUrl) {
        String baseUrl = "http://localhost:8080/s-ramp-server";
        if (requestUrl != null) {
            int index = requestUrl.indexOf("/s-ramp/");
            if (index < 0) {
                index = requestUrl.indexOf("/s-ramp");
            }
            if (index > 0) {
                baseUrl = requestUrl.substring(0, index);
            }
        }
        return configuration.getString("sramp.config.baseurl", baseUrl);
    }
}

