/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.repository.jcr;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.overlord.sramp.visitors.HierarchicalArtifactVisitorAdapter;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public class UpdateJCRNodeFromArtifactVisitor
extends HierarchicalArtifactVisitorAdapter {
    private Node jcrNode;
    private Exception error;

    public UpdateJCRNodeFromArtifactVisitor(Node jcrNode) {
        this.jcrNode = jcrNode;
    }

    protected void visitBase(BaseArtifactType artifact) {
        try {
            this.updateArtifactMetaData(artifact);
            this.updateArtifactProperties(artifact);
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    private void updateArtifactMetaData(BaseArtifactType artifact) throws Exception {
        if (artifact.getName() != null) {
            this.jcrNode.setProperty("sramp:name", artifact.getName());
        }
        if (artifact.getDescription() != null) {
            this.jcrNode.setProperty("sramp:description", artifact.getDescription());
        }
        if (artifact.getVersion() != null) {
            this.jcrNode.setProperty("version", artifact.getVersion());
        }
    }

    private void updateArtifactProperties(BaseArtifactType artifact) throws Exception {
        Set<String> nodeProps;
        Map<String, String> artifactProps = UpdateJCRNodeFromArtifactVisitor.getArtifactProperties(artifact);
        Set<String> propsToRemove = nodeProps = UpdateJCRNodeFromArtifactVisitor.getNodePropertyNames(this.jcrNode);
        propsToRemove.removeAll(artifactProps.keySet());
        String srampPropsPrefix = "sramp-properties:";
        for (String string : propsToRemove) {
            String qname = srampPropsPrefix + string;
            this.jcrNode.setProperty(qname, (Value)null);
        }
        for (Map.Entry entry : artifactProps.entrySet()) {
            String name = (String)entry.getKey();
            String qname = srampPropsPrefix + name;
            String val = (String)entry.getValue();
            this.jcrNode.setProperty(qname, val);
        }
    }

    private static Map<String, String> getArtifactProperties(BaseArtifactType artifact) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (org.s_ramp.xmlns._2010.s_ramp.Property property : artifact.getProperty()) {
            props.put(property.getPropertyName(), property.getPropertyValue());
        }
        return props;
    }

    private static Set<String> getNodePropertyNames(Node jcrNode) throws RepositoryException {
        String srampPropsPrefix = "sramp-properties:";
        int srampPropsPrefixLen = srampPropsPrefix.length();
        HashSet<String> rval = new HashSet<String>();
        PropertyIterator properties = jcrNode.getProperties();
        while (properties.hasNext()) {
            Property prop = properties.nextProperty();
            String propName = prop.getName();
            if (!propName.startsWith(srampPropsPrefix)) continue;
            propName = propName.substring(srampPropsPrefixLen);
            rval.add(propName);
        }
        return rval;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public Exception getError() {
        return this.error;
    }
}

