/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.wagon.models;

import junit.framework.Assert;
import org.apache.maven.wagon.resource.Resource;
import org.junit.Test;
import org.overlord.sramp.wagon.models.MavenGavInfo;

public class MavenGavInfoTest {
    private static final String[][] TEST_DATA = new String[][]{{"org/example/schema/my-schema/1.3/my-schema-1.3.xsd", "org.example.schema", "my-schema", "1.3", "xsd"}, {"xsd/XsdDocument/29873-21983-2497822-1989/1.0/29873-21983-2497822-1989-1.0.pom", "xsd.XsdDocument", "29873-21983-2497822-1989", "1.0", "pom"}, {"org/apache/commons/commons-io/1.3.2/commons-io-1.3.2.jar", "org.apache.commons", "commons-io", "1.3.2", "jar"}, {"org/apache/commons/commons-io/1.3.2/commons-io-1.3.2.pom.sha1", "org.apache.commons", "commons-io", "1.3.2", "pom.sha1"}, {"org/apache/commons/commons-io/1.3.2/commons-io-1.3.2.jar.sha1", "org.apache.commons", "commons-io", "1.3.2", "jar.sha1"}};

    @Test
    public void testFromResource() {
        for (String[] testCase : TEST_DATA) {
            String resourcePath = testCase[0];
            String expectedGroupId = testCase[1];
            String expectedArtifactId = testCase[2];
            String expectedVersion = testCase[3];
            String expectedType = testCase[4];
            MavenGavInfo gavInfo = MavenGavInfo.fromResource((Resource)new Resource(resourcePath));
            String helpfulMsg = "Failure in test case: " + resourcePath;
            Assert.assertEquals((String)helpfulMsg, (String)expectedGroupId, (String)gavInfo.getGroupId());
            Assert.assertEquals((String)helpfulMsg, (String)expectedArtifactId, (String)gavInfo.getArtifactId());
            Assert.assertEquals((String)helpfulMsg, (String)expectedVersion, (String)gavInfo.getVersion());
            Assert.assertEquals((String)helpfulMsg, (String)expectedType, (String)gavInfo.getType());
        }
    }
}

