/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.AssertionFailure;
import org.hibernate.StaleStateException;
import org.hibernate.exception.LockAcquisitionException;
import org.ow2.bonita.definition.MultiInstantiator;
import org.ow2.bonita.definition.MultiInstantiatorDescriptor;
import org.ow2.bonita.definition.activity.ActivityUtil;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.definition.activity.ExternalActivity;
import org.ow2.bonita.env.Authentication;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalConnectorDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.BoundaryEvent;
import org.ow2.bonita.facade.def.element.DeadlineDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.element.MultiInstantiationDefinition;
import org.ow2.bonita.facade.def.element.impl.IterationDescriptor;
import org.ow2.bonita.facade.def.element.impl.MessageBoundaryEventImpl;
import org.ow2.bonita.facade.def.element.impl.SignalBoundaryEventImpl;
import org.ow2.bonita.facade.def.element.impl.TimerBoundaryEventImpl;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.TransitionDefinition;
import org.ow2.bonita.facade.exception.BonitaWrapperException;
import org.ow2.bonita.facade.exception.MultiInstantiatorInvocationException;
import org.ow2.bonita.facade.exception.UnRollbackableException;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.runtime.ExtensionPointsPolicy;
import org.ow2.bonita.runtime.IterationDetectionPolicy;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.event.JobBuilder;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.type.Variable;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.GroovyExpression;
import org.ow2.bonita.util.GroovyUtil;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessUtil;
import org.ow2.bonita.util.TransientData;
import org.ow2.bonita.util.VariableUtil;

public abstract class AbstractActivity
implements ExternalActivity {
    private static final long serialVersionUID = -2731157748250833266L;
    static final Logger LOG = Logger.getLogger(AbstractActivity.class.getName());
    protected long dbid;
    protected String activityName;
    public static final String BODY_FINISHED = "bodyFinished";
    public static final String BODY_SKIPPED = "bodySkipped";
    public static final String ACT_INSTANCE_FINISHED = "instFinished";

    protected AbstractActivity() {
    }

    public AbstractActivity(String activityName) {
        this.activityName = activityName;
    }

    protected abstract boolean executeBusinessLogic(Execution var1);

    protected abstract boolean bodyStartAutomatically();

    @Override
    public void execute(Execution execution, boolean checkJoinType) {
        InternalActivityDefinition activity = execution.getNode();
        if (activity.isAsynchronous()) {
            Authentication.setUserId("SYSTEM");
        }
        if (execution.getInstance().getInstanceState().equals((Object)InstanceState.FINISHED)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Instance ended : " + execution.getInstance());
            }
            execution.end();
            Execution parent = execution.getParent();
            if (parent != null) {
                parent.removeExecution(execution);
            }
            return;
        }
        boolean joinOK = true;
        joinOK = ActivityUtil.isJoinOk(execution.getInstance(), execution.getNode());
        if (joinOK || !checkJoinType) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Join for activity " + this + " is OK.");
            }
            if (activity.getJoinType().equals((Object)ActivityDefinition.JoinType.XOR)) {
                this.cancelJoinXORIncomingTransitions(execution);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Creating a new iteration on activity : " + this);
            }
            ActivityUtil.createNewIteration(execution, activity);
            if (LOG.isLoggable(Level.FINE)) {
                String nodeName = activity.getName();
                LOG.fine("Executing node: " + nodeName + ", class = " + this.getClass().getSimpleName());
            }
            MultiInstantiationDefinition multiInstantiator = activity.getMultiInstantiationDefinition();
            MultiInstantiationDefinition instantiator = activity.getMultipleInstancesInstantiator();
            if (multiInstantiator != null || instantiator != null) {
                this.instantiateMultiInstanceActivity(execution);
            } else if (activity.isInALoop() && activity.evaluateLoopConditionBeforeExecution()) {
                if (ActivityUtil.evaluateLoopCondition(activity, execution)) {
                    Execution newExecution = execution.createChildExecution(execution.getNode().getName());
                    this.initializeActivityInstance(newExecution, null);
                    this.startActivityInstance(newExecution);
                } else {
                    this.terminateInstanceIfNoOutgoingTransitions(execution);
                    this.executeSplit(execution, false);
                }
            } else {
                Execution newExecution = execution.createChildExecution(execution.getNode().getName());
                this.initializeActivityInstance(newExecution, null);
                this.startActivityInstance(newExecution);
            }
        } else {
            execution.end();
            Execution parent = execution.getParent();
            if (parent != null) {
                parent.removeExecution(execution);
            }
        }
    }

    private void instantiateMultiInstanceActivity(Execution execution) {
        List<UnRollbackableException> unrollBackableExceptions;
        InternalActivityDefinition activity = execution.getNode();
        MultiInstantiationDefinition instantiator = activity.getMultipleInstancesInstantiator();
        Recorder recorder = EnvTool.getRecorder();
        RuntimeException caughtException = null;
        RuntimeException firstException = null;
        ArrayList<Execution> activitiesToStart = new ArrayList<Execution>();
        if (instantiator != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("MultipleActivitiesInstantiation not null on activity " + this);
            }
            List<Map<String, Object>> contexts = this.getContextsFromMultiInstantiator(execution, activity, instantiator);
            execution.setWaitingForActivityInstanceNb(contexts.size());
            int childId = 0;
            for (Map<String, Object> context : contexts) {
                if (execution.getWaitingForActivityInstanceNb() <= 0) break;
                Execution childExec = this.createChildExecution(execution, childId);
                HashSet<Variable> variables = new HashSet<Variable>();
                try {
                    if (context != null) {
                        for (Map.Entry<String, Object> variable : context.entrySet()) {
                            Variable multiInstVar = VariableUtil.createVariable(activity.getProcessDefinitionUUID(), variable.getKey(), variable.getValue());
                            variables.add(multiInstVar);
                        }
                    }
                }
                catch (RuntimeException e) {
                    if (LOG.isLoggable(Level.SEVERE)) {
                        LOG.severe("Error while creating multiInstantiator variables" + e);
                    }
                    caughtException = e;
                }
                try {
                    this.initializeActivityInstance(childExec, variables);
                    activitiesToStart.add(childExec);
                }
                catch (StaleStateException sse) {
                    throw sse;
                }
                catch (AssertionFailure af) {
                    throw af;
                }
                catch (LockAcquisitionException lae) {
                    throw lae;
                }
                catch (RuntimeException e) {
                    if (LOG.isLoggable(Level.SEVERE)) {
                        LOG.severe("Error while initializing multiple instances" + e);
                    }
                    caughtException = e;
                }
                if (caughtException != null) {
                    if (firstException == null) {
                        firstException = caughtException;
                    }
                    this.putActivityInFailedStateIfNecessary(recorder, caughtException, childExec);
                    caughtException = null;
                }
                ++childId;
            }
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("MultiInstantiation not null on activity " + this);
            }
            MultiInstantiatorDescriptor actInstDescr = null;
            MultiInstantiationDefinition multiDef = activity.getMultiInstantiationDefinition();
            MultiInstantiator actInstantiator = EnvTool.getClassDataLoader().getInstance(MultiInstantiator.class, execution.getInstance().getProcessDefinitionUUID(), multiDef);
            try {
                actInstDescr = ConnectorExecutor.executeMultiInstantiator(execution, activity.getName(), actInstantiator, multiDef.getParameters());
                if (actInstDescr == null) {
                    String message = ExceptionManager.getInstance().getFullMessage("be_AA_3", activity.getName());
                    throw new BonitaRuntimeException(message);
                }
            }
            catch (Exception e) {
                throw new BonitaWrapperException(new MultiInstantiatorInvocationException("be_AA_4", activity.getMultiInstantiationDefinition().getClassName(), e));
            }
            execution.setWaitingForActivityInstanceNb(actInstDescr.getJoinNumber());
            int childId = 0;
            for (Object value : actInstDescr.getVariableValues()) {
                if (execution.getWaitingForActivityInstanceNb() <= 0) break;
                Execution childExec = this.createChildExecution(execution, childId);
                Variable multiInstVar = null;
                try {
                    multiInstVar = VariableUtil.createVariable(activity.getProcessDefinitionUUID(), activity.getMultiInstantiationDefinition().getVariableName(), value);
                }
                catch (StaleStateException sse) {
                    throw sse;
                }
                catch (AssertionFailure af) {
                    throw af;
                }
                catch (LockAcquisitionException lae) {
                    throw lae;
                }
                catch (RuntimeException e) {
                    if (LOG.isLoggable(Level.SEVERE)) {
                        LOG.severe("Error while creating multiInstantiator variable" + e);
                    }
                    caughtException = e;
                }
                HashSet<Variable> variables = new HashSet<Variable>();
                if (multiInstVar != null) {
                    variables.add(multiInstVar);
                }
                try {
                    this.initializeActivityInstance(childExec, variables);
                    activitiesToStart.add(childExec);
                }
                catch (RuntimeException e) {
                    if (LOG.isLoggable(Level.SEVERE)) {
                        LOG.severe("Error while initializing multiple instances" + e);
                    }
                    caughtException = e;
                }
                if (caughtException != null) {
                    if (firstException == null) {
                        firstException = caughtException;
                    }
                    this.putActivityInFailedStateIfNecessary(recorder, caughtException, childExec);
                    caughtException = null;
                }
                ++childId;
            }
        }
        if (!(unrollBackableExceptions = this.startActivityInstances(activitiesToStart)).isEmpty()) {
            throw unrollBackableExceptions.get(0);
        }
        if (firstException != null && ExtensionPointsPolicy.THROW_EXCPTION_ON_FAIL.equals((Object)EnvTool.getExtensionPointsPolicy())) {
            if (firstException instanceof UnRollbackableException) {
                throw firstException;
            }
            throw new UnRollbackableException("Error while initializing activity", firstException);
        }
    }

    private void putActivityInFailedStateIfNecessary(Recorder recorder, RuntimeException caughtException, Execution childExec) {
        InternalActivityInstance activityInstance = childExec.getActivityInstance();
        if (activityInstance != null) {
            if (!(caughtException instanceof UnRollbackableException)) {
                recorder.recordActivityFailed(activityInstance);
            }
        } else {
            throw caughtException;
        }
    }

    private List<Map<String, Object>> getContextsFromMultiInstantiator(Execution execution, ActivityDefinition activity, MultiInstantiationDefinition instantiator) {
        List<Map<String, Object>> contexts;
        try {
            contexts = ConnectorExecutor.executeMultipleInstancesInstantiatior(instantiator, execution.getInstance().getUUID(), this.activityName, execution.getIterationId());
            if (contexts == null) {
                String message = ExceptionManager.getInstance().getFullMessage("be_AA_8", activity.getName());
                throw new BonitaRuntimeException(message);
            }
            if (contexts.isEmpty()) {
                String message = ExceptionManager.getInstance().getFullMessage("be_AA_9", activity.getName());
                throw new BonitaRuntimeException(message);
            }
        }
        catch (Exception e) {
            throw new BonitaRuntimeException(e.getMessage(), e);
        }
        return contexts;
    }

    private Execution createChildExecution(Execution execution, int childId) {
        Execution childExec = execution.createChildExecution(execution.getName() + "/" + childId);
        childExec.setActivityInstanceId(Integer.toString(childId));
        return childExec;
    }

    private List<UnRollbackableException> startActivityInstances(List<Execution> activitiesToStart) {
        ArrayList<UnRollbackableException> unRollbackableExceptions = new ArrayList<UnRollbackableException>();
        for (Execution childExec : activitiesToStart) {
            if (!childExec.isActive()) continue;
            try {
                this.startActivityInstance(childExec);
            }
            catch (StaleStateException sse) {
                throw sse;
            }
            catch (AssertionFailure af) {
                throw af;
            }
            catch (LockAcquisitionException lae) {
                throw lae;
            }
            catch (RuntimeException e) {
                InternalActivityInstance activityInstance = childExec.getActivityInstance();
                if (activityInstance == null) continue;
                EnvTool.getRecorder().recordActivityFailed(activityInstance);
                if (!ExtensionPointsPolicy.THROW_EXCPTION_ON_FAIL.equals((Object)EnvTool.getExtensionPointsPolicy())) continue;
                unRollbackableExceptions.add(new UnRollbackableException("Error while executing starting", e));
            }
        }
        return unRollbackableExceptions;
    }

    private void cancelJoinXORIncomingTransitions(Execution execution) {
        InternalActivityDefinition currentNode = execution.getNode();
        InternalProcessInstance instance = execution.getInstance();
        this.cancelJoinXORIncomingTransitions(instance, currentNode, new HashSet<String>());
        for (TransitionDefinition t : currentNode.getIncomingTransitions()) {
            instance.setTransitionState(t.getName(), InternalProcessInstance.TransitionState.ABORTED);
        }
    }

    private void cancelJoinXORIncomingTransitions(InternalProcessInstance instance, InternalActivityDefinition currentNode, Set<String> checkedNodes) {
        Set<TransitionDefinition> incomingTransitions = currentNode.getIncomingTransitions();
        String currentNodeName = currentNode.getName();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Canceling other branches of the join XOR : " + currentNodeName);
        }
        checkedNodes.add(currentNodeName);
        for (TransitionDefinition incomingTransition : incomingTransitions) {
            String sourceNodeName = incomingTransition.getFrom();
            InternalProcessInstance.TransitionState transitionState = instance.getTransitionState(incomingTransition.getName());
            if (checkedNodes.contains(sourceNodeName) || transitionState != null && !transitionState.equals((Object)InternalProcessInstance.TransitionState.READY)) continue;
            boolean enable = false;
            InternalActivityDefinition sourceNode = instance.getRootExecution().getProcessDefinition().getActivity(sourceNodeName);
            if (transitionState != null) {
                instance.setTransitionState(incomingTransition.getName(), InternalProcessInstance.TransitionState.ABORTED);
                block1: for (TransitionDefinition tr : sourceNode.getOutgoingTransitions()) {
                    InternalProcessInstance.TransitionState ts = instance.getTransitionState(tr.getName());
                    if (ts != null && !ts.equals((Object)InternalProcessInstance.TransitionState.READY) || !currentNode.isInCycle()) continue;
                    InternalProcessDefinition process = EnvTool.getJournalQueriers().getProcess(instance.getProcessDefinitionUUID());
                    for (IterationDescriptor itDesc : process.getIterationDescriptors()) {
                        if (!itDesc.containsNode(tr.getTo())) continue;
                        enable = true;
                        break block1;
                    }
                }
            }
            if (enable) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(sourceNodeName + " has no more outgoing transitions enabled.");
            }
            List<Execution> execToAbortList = instance.getExecOnNode(sourceNodeName);
            for (Execution execToAbort : execToAbortList) {
                AbstractActivity.destroyEvents(execToAbort);
                if (!execToAbort.isActive()) {
                    execToAbort.unlock();
                }
                execToAbort.abort();
            }
            this.cancelJoinXORIncomingTransitions(instance, sourceNode, checkedNodes);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initializeActivityInstance(Execution internalExecution, Set<Variable> multiInstanceVariables) {
        InternalActivityDefinition activity = internalExecution.getNode();
        ProcessInstanceUUID instanceUUID = internalExecution.getInstance().getUUID();
        Recorder recorder = EnvTool.getRecorder();
        Map<String, Variable> initialVariables = null;
        RuntimeException exception = null;
        try {
            initialVariables = VariableUtil.createVariables(activity.getDataFields(), instanceUUID, null);
        }
        catch (StaleStateException sse) {
            throw sse;
        }
        catch (AssertionFailure af) {
            throw af;
        }
        catch (LockAcquisitionException lae) {
            throw lae;
        }
        catch (RuntimeException t) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Error while initializingVariables " + t);
            }
            exception = t;
        }
        if (multiInstanceVariables != null) {
            if (initialVariables == null) {
                initialVariables = new HashMap<String, Variable>();
            }
            for (Variable variable : multiInstanceVariables) {
                initialVariables.put(variable.getKey(), variable);
            }
        }
        String loopId = "noLoop";
        if (activity.isInALoop()) {
            loopId = Misc.getUniqueId("lp");
        }
        String iterationId = internalExecution.getIterationId();
        String activityInstanceId = internalExecution.getActivityInstanceId();
        ActivityInstanceUUID activityUUID = new ActivityInstanceUUID(instanceUUID, activity.getName(), iterationId, activityInstanceId, loopId);
        InternalActivityInstance activityInstance = new InternalActivityInstance(activityUUID, activity, instanceUUID, internalExecution.getInstance().getRootInstanceUUID(), iterationId, activityInstanceId, loopId);
        if (exception == null) {
            block23: {
                block22: {
                    activityInstance.setActivityState(ActivityState.READY, "SYSTEM");
                    activityInstance.setVariables(initialVariables);
                    TransientData.addTransientVariables(activityUUID, VariableUtil.createTransientVariables(activity.getDataFields(), instanceUUID));
                    recorder.recordEnterActivity(activityInstance);
                    if (activity.getDynamicDescription() != null) {
                        try {
                            if (GroovyExpression.isGroovyExpression(activity.getDynamicDescription())) {
                                Object dynamicDescription = GroovyUtil.evaluate(activity.getDynamicDescription(), null, activityUUID, false, false);
                                if (dynamicDescription != null) {
                                    activityInstance.setDynamicDescription(dynamicDescription.toString());
                                }
                                break block22;
                            }
                            activityInstance.setDynamicDescription(activity.getDynamicDescription());
                        }
                        catch (Exception e) {
                            internalExecution.setActivityInstance(activityInstance);
                            throw new BonitaWrapperException(new BonitaRuntimeException("Error while evaluating dynamic description: " + activity.getDynamicDescription(), e));
                        }
                    }
                }
                if (activity.getDynamicLabel() != null) {
                    try {
                        if (GroovyExpression.isGroovyExpression(activity.getDynamicLabel())) {
                            Object dynamicLabel = GroovyUtil.evaluate(activity.getDynamicLabel(), null, activityUUID, false, false);
                            if (dynamicLabel != null) {
                                activityInstance.setDynamicLabel(dynamicLabel.toString());
                            }
                            break block23;
                        }
                        activityInstance.setDynamicLabel(activity.getDynamicLabel());
                    }
                    catch (Exception e) {
                        internalExecution.setActivityInstance(activityInstance);
                        throw new BonitaWrapperException(new BonitaRuntimeException("Error while evaluating dynamic label: " + activity.getDynamicLabel(), e));
                    }
                }
            }
            internalExecution.setActivityInstance(activityInstance);
            return;
        }
        if (LOG.isLoggable(Level.SEVERE)) {
            LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
        recorder.recordEnterActivity(activityInstance);
        recorder.recordActivityFailed(activityInstance);
        internalExecution.setActivityInstance(activityInstance);
        throw exception;
    }

    private void startActivityInstance(Execution internalExecution) {
        InternalActivityDefinition activity = internalExecution.getNode();
        ActivityInstanceUUID activityUUID = internalExecution.getActivityInstanceUUID();
        try {
            this.initializeEvents(internalExecution);
        }
        catch (GroovyException e) {
            String message = "Error while initializing events: ";
            throw new BonitaWrapperException(new BonitaRuntimeException("Error while initializing events: ", e));
        }
        if (activity.isAsynchronous()) {
            EventService eventService = EnvTool.getEventService();
            String uuid = internalExecution.getEventUUID();
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
            }
            String eventName = "**bonita_async**-" + activityUUID;
            internalExecution.setEventUUID(uuid);
            internalExecution.lock("async continuation " + eventName);
            Job async = JobBuilder.asyncJob(eventName, internalExecution.getInstance().getRootInstanceUUID(), uuid, internalExecution.getInstance().getProcessInstanceUUID());
            eventService.storeJob(async);
        } else {
            this.executeActivityInstance(internalExecution);
        }
    }

    protected void executeActivityInstance(Execution internalExecution) {
        boolean canContinue = this.executeBody(internalExecution);
        if (canContinue) {
            this.end(internalExecution);
        } else {
            internalExecution.waitForSignal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void end(Execution internalExecution) {
        try {
            InternalActivityDefinition activity = internalExecution.getNode();
            if (activity.getDynamicExecutionSummary() != null) {
                try {
                    if (GroovyExpression.isGroovyExpression(activity.getDynamicExecutionSummary())) {
                        Object dynamicExecutionSummary = GroovyUtil.evaluate(activity.getDynamicExecutionSummary(), null, internalExecution.getActivityInstanceUUID(), false, false);
                        if (dynamicExecutionSummary != null) {
                            internalExecution.getActivityInstance().setDynamicExecutionSummary(dynamicExecutionSummary.toString());
                        }
                    } else {
                        internalExecution.getActivityInstance().setDynamicExecutionSummary(activity.getDynamicExecutionSummary());
                    }
                }
                catch (Exception e) {
                    throw new BonitaWrapperException(new BonitaRuntimeException("Error while evaluating dynamic execution summary: " + activity.getDynamicExecutionSummary(), e));
                }
            }
            EnvTool.getRecorder().recordBodyEnded(internalExecution.getActivityInstance());
            if (activity.getMultiInstantiationDefinition() != null || activity.getMultipleInstancesInstantiator() != null) {
                this.endMultiInstantiation(internalExecution);
            } else if (activity.isInALoop()) {
                this.endLoop(internalExecution);
            } else {
                this.terminateInstanceIfNoOutgoingTransitions(internalExecution);
                this.executeSplit(internalExecution, true);
            }
        }
        catch (StaleStateException sse) {
            throw sse;
        }
        catch (AssertionFailure af) {
            throw af;
        }
        catch (LockAcquisitionException lae) {
            throw lae;
        }
        catch (UnRollbackableException e) {
            throw e;
        }
        catch (RuntimeException e) {
            InternalActivityInstance activityInstance = internalExecution.getActivityInstance();
            EnvTool.getRecorder().recordActivityFailed(activityInstance);
            if (ExtensionPointsPolicy.THROW_EXCPTION_ON_FAIL.equals((Object)EnvTool.getExtensionPointsPolicy())) {
                throw new UnRollbackableException("Error while executing connector taskOnFinish", e);
            }
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        finally {
            TransientData.removeTransientData(internalExecution.getActivityInstance().getUUID());
        }
    }

    protected void skip(Execution internalExecution) {
        InternalActivityDefinition activity = internalExecution.getNode();
        if (activity.getDynamicExecutionSummary() != null) {
            try {
                if (GroovyExpression.isGroovyExpression(activity.getDynamicExecutionSummary())) {
                    Object dynamicExecutionSummary = GroovyUtil.evaluate(activity.getDynamicExecutionSummary(), null, internalExecution.getActivityInstanceUUID(), false, false);
                    if (dynamicExecutionSummary != null) {
                        internalExecution.getActivityInstance().setDynamicExecutionSummary(dynamicExecutionSummary.toString());
                    }
                } else {
                    internalExecution.getActivityInstance().setDynamicExecutionSummary(activity.getDynamicExecutionSummary());
                }
            }
            catch (Exception e) {
                throw new BonitaWrapperException(new BonitaRuntimeException("Error while ending execution: " + activity.getDynamicExecutionSummary(), e));
            }
        }
        if (activity.getMultiInstantiationDefinition() != null || activity.getMultipleInstancesInstantiator() != null) {
            this.removeChildrenActivityInstances(internalExecution);
            this.terminateInstanceIfNoOutgoingTransitions(internalExecution);
            this.executeSplit(internalExecution, false);
        } else {
            this.terminateInstanceIfNoOutgoingTransitions(internalExecution);
            this.executeSplit(internalExecution, true);
        }
    }

    protected void endMultiInstantiation(Execution internalExecution) {
        MultiInstantiationDefinition joinChecker;
        InternalActivityDefinition activity = internalExecution.getNode();
        Execution parent = internalExecution.getParent();
        if (parent.getWaitingForActivityInstanceNb() > 1 && (joinChecker = activity.getMultipleInstancesJoinChecker()) != null) {
            boolean join = false;
            try {
                join = ConnectorExecutor.executeMultipleInstancesJoinChecker(joinChecker, internalExecution.getActivityInstance().getUUID());
            }
            catch (Exception e) {
                throw new BonitaRuntimeException(e.getMessage(), e);
            }
            if (join) {
                parent.setWaitingForActivityInstanceNb(1);
            }
        }
        AbstractActivity.destroyEvents(internalExecution);
        internalExecution.end();
        parent.removeExecution(internalExecution);
        this.signal(parent, ACT_INSTANCE_FINISHED, null);
    }

    protected void endLoop(Execution internalExecution) {
        InternalActivityDefinition activity = internalExecution.getNode();
        Execution parent = internalExecution.getParent();
        int maxIterations = 0;
        String maxIterationsExpr = activity.getLoopMaximum();
        if (maxIterationsExpr != null) {
            try {
                if (Misc.isJustAGroovyExpression(maxIterationsExpr)) {
                    ProcessInstanceUUID instanceUUID = internalExecution.getInstance().getUUID();
                    Querier journal = EnvTool.getJournalQueriers();
                    InternalActivityInstance activityInstance = journal.getActivityInstance(instanceUUID, internalExecution.getNodeName(), internalExecution.getIterationId(), internalExecution.getActivityInstanceId(), internalExecution.getActivityInstance().getLoopId());
                    maxIterations = (Integer)GroovyUtil.evaluate(maxIterationsExpr, null, activityInstance.getUUID(), false, false);
                } else {
                    maxIterations = Integer.parseInt(maxIterationsExpr);
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "The maximum number of loop iterations for activity " + this.activityName + " must be an integer or an expression that evaluates to an integer", e);
            }
        }
        parent.setWaitingForActivityInstanceNb(maxIterations);
        this.signal(parent, ACT_INSTANCE_FINISHED, null);
        if (!internalExecution.isFinished()) {
            boolean loop = true;
            if (!activity.evaluateLoopConditionBeforeExecution()) {
                loop = ActivityUtil.evaluateLoopCondition(activity, internalExecution);
            }
            if (loop) {
                parent.removeExecution(internalExecution);
                this.execute(parent, false);
            } else {
                this.terminateInstanceIfNoOutgoingTransitions(internalExecution);
                this.executeSplit(internalExecution, true);
            }
        }
    }

    private void terminateInstanceIfNoOutgoingTransitions(Execution internalExecution) {
        InternalActivityDefinition activity = internalExecution.getNode();
        InternalProcessInstance instance = internalExecution.getInstance();
        ProcessInstanceUUID instanceUUID = instance.getUUID();
        ActivityInstanceUUID activityUUID = internalExecution.getActivityInstanceUUID();
        if (activity.isTerminateProcess() || !activity.hasOutgoingTransitions() && !this.hasStillReadyActivities(instanceUUID, activityUUID) && !this.hasStillReadyTransitions(instance)) {
            ProcessInstanceUUID parentInstanceUUID = instance.getParentInstanceUUID();
            ConnectorExecutor.executeConnectors(internalExecution, HookDefinition.Event.instanceOnFinish);
            Recorder recorder = EnvTool.getRecorder();
            recorder.recordInstanceEnded(instance.getUUID(), EnvTool.getUserId());
            ProcessUtil.removeInternalInstanceEvents(instance.getUUID());
            if (parentInstanceUUID != null) {
                if (LightProcessDefinition.ProcessType.EVENT_SUB_PROCESS.equals((Object)internalExecution.getProcessDefinition().getType())) {
                    InternalProcessInstance parentInstance = EnvTool.getJournalQueriers().getProcessInstance(parentInstanceUUID);
                    if (parentInstance.getParentActivityUUID() != null) {
                        Execution rootExecution = EnvTool.getAllQueriers().getExecutionOnActivity(parentInstance.getParentInstanceUUID(), parentInstance.getParentActivityUUID());
                        try {
                            rootExecution.getNode().getBehaviour().signal(rootExecution, BODY_FINISHED, null);
                        }
                        catch (Exception e) {
                            throw new BonitaRuntimeException(e.getMessage(), e);
                        }
                    } else {
                        parentInstance.finish();
                    }
                } else {
                    HashMap<String, Object> signalParameters = new HashMap<String, Object>();
                    signalParameters.put("childInstanceUUID", instanceUUID);
                    InternalProcessInstance parentInstance = EnvTool.getJournalQueriers().getProcessInstance(parentInstanceUUID);
                    Execution parentRootExecution = parentInstance.getRootExecution();
                    Execution execToSignal = this.getSubflowExecution(parentRootExecution, instanceUUID);
                    try {
                        execToSignal.getNode().getBehaviour().signal(execToSignal, "end_of_subflow", signalParameters);
                    }
                    catch (Exception e) {
                        throw new BonitaRuntimeException(e.getMessage(), e);
                    }
                }
            } else {
                instance.finish();
            }
        }
    }

    private boolean hasStillReadyActivities(ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityUUID) {
        return EnvTool.getJournalQueriers().containsOtherActiveActivities(instanceUUID, activityUUID);
    }

    private boolean hasStillReadyTransitions(InternalProcessInstance instance) {
        boolean hasStillReadyTransitions = false;
        Iterator<String> iterator = instance.getTransitionsStates().values().iterator();
        while (!hasStillReadyTransitions && iterator.hasNext()) {
            String state = iterator.next();
            if (!InternalProcessInstance.TransitionState.READY.toString().equals(state)) continue;
            hasStillReadyTransitions = true;
        }
        return hasStillReadyTransitions;
    }

    private Execution getSubflowExecution(Execution exec, ProcessInstanceUUID subflowInstanceUUID) {
        if (exec.getActivityInstance() != null && exec.getActivityInstance().getSubflowProcessInstanceUUID() != null && exec.getActivityInstance().getSubflowProcessInstanceUUID().equals(subflowInstanceUUID)) {
            return exec;
        }
        for (Execution child : exec.getExecutions()) {
            Execution e = this.getSubflowExecution(child, subflowInstanceUUID);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    @Override
    public void signal(Execution execution, String signal, Map<String, Object> parameters) {
        Execution internalExecution = execution;
        InternalActivityDefinition activity = execution.getNode();
        if (BODY_FINISHED.equals(signal)) {
            this.end(internalExecution);
        } else if (ACT_INSTANCE_FINISHED.equals(signal)) {
            if (activity.getMultiInstantiationDefinition() != null || activity.getMultipleInstancesInstantiator() != null) {
                internalExecution.setWaitingForActivityInstanceNb(internalExecution.getWaitingForActivityInstanceNb() - 1);
                if (internalExecution.getWaitingForActivityInstanceNb() == 0) {
                    this.removeChildrenActivityInstances(internalExecution);
                    this.terminateInstanceIfNoOutgoingTransitions(internalExecution);
                    this.executeSplit(internalExecution, false);
                }
            } else {
                internalExecution.setActivityInstanceNb(internalExecution.getActivityInstanceNb() + 1);
                int maxIterations = internalExecution.getWaitingForActivityInstanceNb();
                if (0 < maxIterations && maxIterations <= internalExecution.getActivityInstanceNb()) {
                    this.endChildrenActivityInstances(internalExecution);
                    this.terminateInstanceIfNoOutgoingTransitions(internalExecution);
                    this.executeSplit(internalExecution, false);
                }
            }
        } else if ("async".equals(signal)) {
            Authentication.setUserId("SYSTEM");
            this.executeActivityInstance(internalExecution);
        } else if ("deadline".equals(signal)) {
            Long id = (Long)parameters.get("id");
            DeadlineDefinition deadline = null;
            if (id != null) {
                deadline = this.getMatchingDeadline(id, activity.getDeadlines());
            } else {
                String className = (String)parameters.get("className");
                deadline = this.getCompatibleDeadline(className, activity.getDeadlines());
            }
            if (deadline != null) {
                Authentication.setUserId("SYSTEM");
                internalExecution.waitForSignal();
                String activityId = internalExecution.getNode().getName();
                ConnectorExecutor.executeConnector(internalExecution, activityId, deadline);
            }
        } else if ("boundary".equals(signal)) {
            AbstractActivity.destroyEvents(internalExecution);
            if ((activity.getMultiInstantiationDefinition() != null || activity.getMultipleInstancesInstantiator() != null) && internalExecution.getParent() != null) {
                for (Execution execToAbort : new ArrayList<Execution>(internalExecution.getParent().getExecutions())) {
                    if (execToAbort.equals(internalExecution) || !execToAbort.isActive()) continue;
                    execToAbort.abort();
                }
            }
            InternalActivityInstance activityInstance = internalExecution.getActivityInstance();
            EnvTool.getRecorder().recordBodyAborted(activityInstance);
            TransientData.removeTransientData(activityInstance.getUUID());
            if (activity.isSubflow()) {
                InternalProcessInstance subprocessInstance = EnvTool.getJournalQueriers().getProcessInstance(activityInstance.getSubflowProcessInstanceUUID());
                EnvTool.getRecorder().recordInstanceAborted(subprocessInstance.getUUID(), "SYSTEM");
            }
            internalExecution.setActivityInstance(null);
            if ("event.boundary.message".equals(signal)) {
                ConnectorExecutor.executeConnectors(activity, execution, HookDefinition.Event.onEvent, parameters);
            }
            BoundaryEvent event = activity.getBoundaryEvent(parameters.get("eventName").toString());
            TransitionDefinition exceptionTransition = event.getTransition();
            internalExecution.take(exceptionTransition);
        } else if (BODY_SKIPPED.equals(signal)) {
            this.skip(internalExecution);
        } else if ("sigCnnctAutEnd".equals(signal)) {
            ConnectorExecutor.executeConnectors(activity, execution, HookDefinition.Event.automaticOnExit);
            this.end(internalExecution);
        }
    }

    private DeadlineDefinition getCompatibleDeadline(String className, Set<DeadlineDefinition> deadlines) {
        for (DeadlineDefinition deadline : deadlines) {
            if (!deadline.getClassName().equals(className)) continue;
            return deadline;
        }
        return null;
    }

    private DeadlineDefinition getMatchingDeadline(Long id, Set<DeadlineDefinition> deadlines) {
        for (DeadlineDefinition d : deadlines) {
            InternalConnectorDefinition deadline = (InternalConnectorDefinition)d;
            if (deadline.getDbid() != id.longValue()) continue;
            return deadline;
        }
        return null;
    }

    private void removeChildrenActivityInstances(Execution execution) {
        if (execution.getExecutions() != null) {
            for (Execution execToAbort : new ArrayList<Execution>(execution.getExecutions())) {
                execToAbort.abort();
            }
        }
    }

    private void endChildrenActivityInstances(Execution execution) {
        if (execution.getExecutions() != null) {
            for (Execution execToEnd : new ArrayList<Execution>(execution.getExecutions())) {
                execToEnd.end();
                execution.removeExecution(execToEnd);
            }
        }
    }

    private void initializeEvents(Execution execution) throws GroovyException {
        InternalActivityDefinition activity = execution.getNode();
        Set<DeadlineDefinition> deadlines = activity.getDeadlines();
        List<BoundaryEvent> boundaryEvents = activity.getBoundaryEvents();
        if (!deadlines.isEmpty() || !boundaryEvents.isEmpty()) {
            String executionEventUUID = "event-" + UUID.randomUUID().toString();
            execution.setEventUUID(executionEventUUID);
            this.initializeTimers(execution, executionEventUUID);
            this.initializeBoundaryEvents(execution, executionEventUUID);
        }
    }

    private void initializeTimers(Execution execution, String executionEventUUID) throws GroovyException {
        InternalActivityDefinition activity = execution.getNode();
        ActivityInstanceUUID activityUUID = execution.getActivityInstanceUUID();
        Set<DeadlineDefinition> deadlines = activity.getDeadlines();
        if (!deadlines.isEmpty()) {
            EventService eventService = EnvTool.getEventService();
            for (DeadlineDefinition d : deadlines) {
                InternalConnectorDefinition deadline = (InternalConnectorDefinition)d;
                String condition = deadline.getCondition();
                long fireTime = ProcessUtil.getTimerDate(condition, activityUUID).getTime();
                Job dl = JobBuilder.deadlineJob("" + deadline.getDbid(), execution.getInstance().getRootInstanceUUID(), executionEventUUID, fireTime, execution.getInstance().getProcessInstanceUUID());
                eventService.storeJob(dl);
            }
        }
    }

    private void initializeBoundaryEvents(Execution execution, String executionEventUUID) throws GroovyException {
        InternalActivityDefinition activity = execution.getNode();
        List<BoundaryEvent> boundaryEvents = activity.getBoundaryEvents();
        if (!boundaryEvents.isEmpty()) {
            ActivityInstanceUUID activityUUID = execution.getActivityInstanceUUID();
            InternalActivityInstance activityInstance = execution.getActivityInstance();
            ProcessInstanceUUID instanceUUID = activityInstance.getProcessInstanceUUID();
            EventService eventService = EnvTool.getEventService();
            String processName = execution.getProcessDefinition().getName();
            for (BoundaryEvent boundaryEvent : boundaryEvents) {
                if (boundaryEvent instanceof TimerBoundaryEventImpl) {
                    TimerBoundaryEventImpl timer = (TimerBoundaryEventImpl)boundaryEvent;
                    String eventName = timer.getName();
                    String condition = timer.getCondition();
                    Date date = ProcessUtil.getTimerDate(condition, activityUUID);
                    ProcessInstanceUUID rootInstanceUUID = execution.getInstance().getRootInstanceUUID();
                    Job boundaryTimer = JobBuilder.boundaryTimerJob(eventName, rootInstanceUUID, executionEventUUID, date.getTime(), instanceUUID);
                    eventService.storeJob(boundaryTimer);
                    continue;
                }
                if (boundaryEvent instanceof MessageBoundaryEventImpl) {
                    MessageBoundaryEventImpl message = (MessageBoundaryEventImpl)boundaryEvent;
                    String expression = message.getExpression();
                    IncomingEventInstance eventInstance = new IncomingEventInstance(message.getName(), expression, instanceUUID, activity.getUUID(), activityUUID, processName, this.activityName, executionEventUUID, "event.boundary.message", System.currentTimeMillis(), true);
                    ActivityUtil.addCorrelationKeys(message, eventInstance, activityUUID);
                    eventService.subscribe(eventInstance);
                    continue;
                }
                if (!(boundaryEvent instanceof SignalBoundaryEventImpl)) continue;
                SignalBoundaryEventImpl signal = (SignalBoundaryEventImpl)boundaryEvent;
                String signalName = signal.getSignalCode();
                IncomingEventInstance signalEventInstance = new IncomingEventInstance(signalName, null, instanceUUID, activity.getUUID(), null, processName, signal.getName(), executionEventUUID, "event.boundary.signal", -1L, false);
                eventService.subscribe(signalEventInstance);
            }
        }
    }

    private static void destroyEvents(Execution execution) {
        ActivityInstanceUUID activityUUID;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("destroying events of " + execution.toString());
        }
        if ((activityUUID = execution.getActivityInstanceUUID()) != null) {
            if (execution.getNode() == null || execution.getNode().hasBoundaryEvents()) {
                ActivityUtil.deleteBoundaryEvents(activityUUID);
            }
            ActivityUtil.deleteJobs(execution.getEventUUID());
        }
    }

    private boolean executeBody(Execution internalExecution) {
        if (this.bodyStartAutomatically()) {
            EnvTool.getRecorder().recordBodyStarted(internalExecution.getActivityInstance());
        }
        return this.executeBusinessLogic(internalExecution);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append(": activtyName: " + this.getActivityName());
        return buffer.toString();
    }

    public String getActivityName() {
        return this.activityName;
    }

    public void executeSplit(Execution execution, boolean removeScope) {
        Set<TransitionDefinition> transitions;
        InternalActivityDefinition activity = execution.getNode();
        Execution internalExecution = execution;
        InternalActivityDefinition currentNode = internalExecution.getNode();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("node = " + currentNode.getName() + " - splitType = " + (Object)((Object)activity.getSplitType()) + " - execution = " + execution.getName());
        }
        if ((transitions = currentNode.getOutgoingTransitions()).isEmpty()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("node = " + currentNode.getName() + " - splitType = " + (Object)((Object)activity.getSplitType()) + " - execution = " + execution.getName() + " no transition available. Ending execution");
            }
            internalExecution.end();
            Execution parent = internalExecution.getParent();
            if (parent != null) {
                parent.removeExecution(internalExecution);
            }
        } else {
            InternalProcessInstance.TransitionState transitionState;
            TransitionDefinition defaultTransition = null;
            ArrayList<TransitionDefinition> transitionsToTake = new ArrayList<TransitionDefinition>();
            for (TransitionDefinition t : transitions) {
                InternalProcessInstance.TransitionState transitionState2;
                if (t.isDefault()) {
                    defaultTransition = t;
                    continue;
                }
                if (!ActivityUtil.evaluateTransition(t, internalExecution) || (transitionState2 = internalExecution.getInstance().getTransitionState(t.getName())) != null && !transitionState2.equals((Object)InternalProcessInstance.TransitionState.READY)) continue;
                internalExecution.getInstance().setTransitionState(t.getName(), InternalProcessInstance.TransitionState.READY);
                transitionsToTake.add(t);
            }
            if (defaultTransition != null && transitionsToTake.size() == 0 && (transitionState = internalExecution.getInstance().getTransitionState(defaultTransition.getName())) == null) {
                internalExecution.getInstance().setTransitionState(defaultTransition.getName(), InternalProcessInstance.TransitionState.READY);
                transitionsToTake.add(defaultTransition);
            }
            if (removeScope) {
                AbstractActivity.destroyEvents(internalExecution);
                internalExecution = internalExecution.backToParent();
            }
            internalExecution.setActivityInstance(null);
            if (transitionsToTake.size() == 0) {
                internalExecution.end();
                Execution parent = internalExecution.getParent();
                if (parent != null) {
                    parent.removeExecution(internalExecution);
                }
            } else {
                Set<IterationDescriptor> iterationDescriptors = null;
                if (activity.isInCycle()) {
                    InternalProcessDefinition process = EnvTool.getJournalQueriers().getProcess(activity.getProcessDefinitionUUID());
                    iterationDescriptors = process.getIterationDescriptors();
                    for (IterationDescriptor itD : iterationDescriptors) {
                        boolean isLeaving = false;
                        for (TransitionDefinition t : transitionsToTake) {
                            if (itD.containsNode(t.getTo()) || !itD.containsNode(t.getFrom())) continue;
                            isLeaving = true;
                        }
                        if (!isLeaving) continue;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine(activity.getName() + " is leaving a cycle, aborting other nodes in cycle.");
                        }
                        for (String nodeToAbort : itD.getCycleNodes()) {
                            if (nodeToAbort.equals(currentNode.getName())) continue;
                            List<Execution> execToAbortList = internalExecution.getInstance().getExecOnNode(nodeToAbort);
                            for (Execution execToAbort : execToAbortList) {
                                if (!execToAbort.isActive()) continue;
                                execToAbort.abort();
                            }
                        }
                    }
                }
                if (transitionsToTake.size() == 1 || ActivityDefinition.SplitType.XOR.equals((Object)activity.getSplitType())) {
                    TransitionDefinition t;
                    t = (TransitionDefinition)transitionsToTake.get(0);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Taking transition " + t);
                    }
                    internalExecution.take(t);
                } else {
                    int i;
                    if (EnvTool.getIterationDetectionPolicy() == IterationDetectionPolicy.ENABLE && activity.isInCycle()) {
                        for (IterationDescriptor itD : iterationDescriptors) {
                            boolean isLeaving = false;
                            boolean isStaying = false;
                            for (TransitionDefinition t : transitionsToTake) {
                                if (!itD.containsNode(t.getTo())) {
                                    isLeaving = true;
                                    continue;
                                }
                                isStaying = true;
                            }
                            if (!isStaying || !isLeaving) continue;
                            String message = ExceptionManager.getInstance().getFullMessage("be_AA_5", new Object[0]);
                            throw new BonitaWrapperException(new BonitaRuntimeException(message));
                        }
                    }
                    ArrayList<Execution> children = new ArrayList<Execution>();
                    for (i = 0; i < transitionsToTake.size(); ++i) {
                        TransitionDefinition t = (TransitionDefinition)transitionsToTake.get(i);
                        String name = t.getFrom() + "_to_" + t.getTo();
                        Execution childExecution = internalExecution.createChildExecution(name);
                        children.add(childExecution);
                    }
                    for (i = 0; i < transitionsToTake.size(); ++i) {
                        Execution childExecution = (Execution)children.get(i);
                        TransitionDefinition t = (TransitionDefinition)transitionsToTake.get(i);
                        if (childExecution.isFinished()) continue;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Execution " + childExecution.getName() + " is taking transition " + t);
                        }
                        childExecution.take(t);
                    }
                }
            }
        }
    }
}

