/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.deployment;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.def.element.impl.IterationDescriptor;
import org.ow2.bonita.iteration.IterationNode;
import org.ow2.bonita.iteration.IterationProcess;
import org.ow2.bonita.iteration.IterationTransition;
import org.ow2.bonita.iteration.SuspiciousIterationException;

public final class IterationDetection {
    private static final Logger LOG = Logger.getLogger(IterationDetection.class.getName());
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    protected IterationDetection() {
    }

    public static SortedSet<IterationDescriptor> findIterations(IterationProcess inProcess) {
        SortedMap<String, IterationNode> allProcessNodes = inProcess.getNodes();
        TreeSet<IterationNode> allPorcessNodesSorted = new TreeSet<IterationNode>(allProcessNodes.values());
        ArrayList<IterationNode> path = new ArrayList<IterationNode>(allProcessNodes.size());
        TreeSet<IterationNode> visitedNodes = new TreeSet<IterationNode>();
        TreeSet<IterationDescriptor> iterationDescriptors = new TreeSet<IterationDescriptor>();
        for (IterationNode sourceNode : allPorcessNodesSorted) {
            TreeSet<IterationTransition> incomingTransitions = new TreeSet<IterationTransition>(sourceNode.getIncomingTransitions());
            TreeSet<IterationDescriptor> temporaryIterationDescriptors = new TreeSet<IterationDescriptor>();
            for (IterationTransition transition : incomingTransitions) {
                IterationDetection.listCycles(inProcess, sourceNode, transition.getSource(), path, visitedNodes, temporaryIterationDescriptors);
                iterationDescriptors.addAll(temporaryIterationDescriptors);
            }
        }
        return iterationDescriptors;
    }

    private static void listCycles(IterationProcess inProcess, IterationNode sourceNode, IterationNode targetNode, List<IterationNode> path, SortedSet<IterationNode> visitedNodes, SortedSet<IterationDescriptor> iterationDescriptors) {
        path.add(sourceNode);
        if (sourceNode.getName().equals(targetNode.getName())) {
            IterationDescriptor descriptor = IterationDetection.buildIterationDescriptor(path);
            iterationDescriptors.add(descriptor);
            path.remove(sourceNode);
            return;
        }
        visitedNodes.add(sourceNode);
        TreeSet<IterationTransition> outgoingTransitions = new TreeSet<IterationTransition>(sourceNode.getOutgoingTransitions());
        for (IterationTransition transition : outgoingTransitions) {
            if (visitedNodes.contains(transition.getDestination())) continue;
            IterationDetection.listCycles(inProcess, transition.getDestination(), targetNode, path, visitedNodes, iterationDescriptors);
        }
        visitedNodes.remove(sourceNode);
        path.remove(sourceNode);
    }

    private static IterationDescriptor buildIterationDescriptor(List<IterationNode> path) {
        List<String> nodesInPath = IterationDetection.getNodeNames(path);
        TreeSet<String> entryNodes = new TreeSet<String>();
        TreeSet<String> exitNodes = new TreeSet<String>();
        TreeSet<String> otherNodes = new TreeSet<String>();
        boolean hasEntryPointXor = false;
        for (IterationNode node : path) {
            Set<IterationTransition> incomingTransitions = node.getIncomingTransitions();
            Set<IterationTransition> outgoingTransitions = node.getOutgoingTransitions();
            String nodeName = node.getName();
            for (IterationTransition transition : incomingTransitions) {
                if (path.contains(transition.getSource())) continue;
                hasEntryPointXor |= IterationDetection.checkEntryNodeIntegrity(node);
                entryNodes.add(nodeName);
            }
            for (IterationTransition transition : outgoingTransitions) {
                if (path.contains(transition.getDestination())) continue;
                exitNodes.add(nodeName);
                IterationNode.SplitType splitType = node.getSplitType();
                if (IterationNode.SplitType.XOR.equals((Object)splitType) || !LOG.isLoggable(Level.WARNING)) continue;
                StringBuilder builder = new StringBuilder("Potential issue in iteration : ");
                builder.append(nodeName).append(" is an exit node for cycle ").append(nodesInPath).append('.').append(LINE_SEPARATOR);
                builder.append("Split type of this node is ").append((Object)splitType).append(" but only XOR is supported.").append(LINE_SEPARATOR);
                builder.append("An exception will be thrown at runtime if more than one transition is enabled at the same time.");
                LOG.warning(builder.toString());
            }
            if (entryNodes.contains(nodeName) || exitNodes.contains(nodeName)) continue;
            otherNodes.add(nodeName);
        }
        IterationDescriptor itDescr = new IterationDescriptor(otherNodes, entryNodes, exitNodes);
        IterationDetection.checkCycleIntegrity(hasEntryPointXor, itDescr);
        return itDescr;
    }

    private static List<String> getNodeNames(List<IterationNode> path) {
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (IterationNode iterationNode : path) {
            nodeNames.add(iterationNode.getName());
        }
        return nodeNames;
    }

    private static void checkCycleIntegrity(boolean hasEntryPointXor, IterationDescriptor itDescr) {
        if (itDescr.getEntryNodes().size() == 0) {
            throw new SuspiciousIterationException("Error in cycle detection : cycle " + itDescr + " has no start node");
        }
        if (!hasEntryPointXor) {
            throw new SuspiciousIterationException("Error in cycle detection : cycle " + itDescr + " has no start node with a XOR join. Process execution can never enter this cycle.");
        }
    }

    private static boolean checkEntryNodeIntegrity(IterationNode sourceNode) {
        IterationNode.JoinType joinType = sourceNode.getJoinType();
        if (IterationNode.JoinType.AND.equals((Object)joinType)) {
            throw new SuspiciousIterationException("Error in cycle detection : start node " + sourceNode.getName() + " has a AND join. This is not allowed.");
        }
        return IterationNode.JoinType.XOR.equals((Object)joinType);
    }
}

