/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.binding;

import org.ow2.bonita.env.binding.WireDescriptorBinding;
import org.ow2.bonita.env.descriptor.BooleanDescriptor;
import org.ow2.bonita.env.descriptor.ContextTypeRefDescriptor;
import org.ow2.bonita.env.descriptor.EventExecutorDescriptor;
import org.ow2.bonita.env.descriptor.IntegerDescriptor;
import org.ow2.bonita.env.descriptor.ObjectDescriptor;
import org.ow2.bonita.env.descriptor.ReferenceDescriptor;
import org.ow2.bonita.env.descriptor.StringDescriptor;
import org.ow2.bonita.env.operation.InvokeOperation;
import org.ow2.bonita.services.CommandService;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class EventExecutorBinding
extends WireDescriptorBinding {
    public EventExecutorBinding() {
        super("event-executor");
    }

    @Override
    public Object parse(Element element, Parse parse, Parser parser) {
        EventExecutorDescriptor descriptor = new EventExecutorDescriptor();
        if (element.hasAttribute("command-service")) {
            descriptor.addInjection("commandService", new ReferenceDescriptor(element.getAttribute("command-service")));
        } else {
            descriptor.addInjection("commandService", new ContextTypeRefDescriptor(CommandService.class));
        }
        if (element.hasAttribute("name")) {
            descriptor.addInjection("name", new StringDescriptor(element.getAttribute("name")));
        }
        this.parseIntAttribute(element, "threads", descriptor, "nbrOfThreads", parse);
        this.parseIntAttribute(element, "idle", descriptor, "idleMillis", parse);
        this.parseIntAttribute(element, "idle-min", descriptor, "minimumInterval", parse);
        this.parseIntAttribute(element, "lock", descriptor, "lockMillis", parse);
        this.parseIntAttribute(element, "retries", descriptor, "retries", parse);
        Element jobExecutor = XmlUtil.element(element, "job-executor");
        String jobExecutorClassName = XmlUtil.attribute(jobExecutor, "class");
        descriptor.addInjection("jobExecutorClassName", new StringDescriptor(jobExecutorClassName));
        this.parseIntAttribute(jobExecutor, "locks-to-query", descriptor, "locksToQuery", parse);
        this.parseIntAttribute(jobExecutor, "lock-idle-time", descriptor, "lockIdleTime", parse);
        Element matcher = XmlUtil.element(element, "matcher");
        this.parseIntAttribute(matcher, "max-couples", descriptor, "matcherMaxCouples", parse);
        String eventMatcherClassName = XmlUtil.attribute(matcher, "class");
        descriptor.addInjection("eventMatcherClassName", new StringDescriptor(eventMatcherClassName));
        Element conditionMatching = XmlUtil.element(matcher, "condition-matching");
        this.parseBooleanAttribute(conditionMatching, "enable", descriptor, "expressionMatcherEnable", parse);
        Element masterChecker = XmlUtil.element(element, "master-checker");
        String masterCheckerClassName = XmlUtil.attribute(masterChecker, "class");
        descriptor.addInjection("masterCheckerClassName", new StringDescriptor(masterCheckerClassName));
        this.parseBooleanAttribute(masterChecker, "enable", descriptor, "masterCheckerEnable", parse);
        this.parseIntAttribute(masterChecker, "master-heartbeat-delay", descriptor, "masterCheckerMasterHeartbeatDelay", parse);
        this.parseIntAttribute(masterChecker, "slave-heartbeat-delay", descriptor, "masterCheckerSlaveHeartbeatDelay", parse);
        this.parseIntAttribute(masterChecker, "max-idle-delay", descriptor, "masterCheckerMaxIdleDelay", parse);
        if (XmlUtil.attributeBoolean(element, "auto-start", false, parse, true).booleanValue()) {
            InvokeOperation invokeStartOperation = new InvokeOperation();
            invokeStartOperation.setMethodName("start");
            descriptor.addOperation(invokeStartOperation);
            descriptor.setAutoStart(true);
        }
        return descriptor;
    }

    private void parseIntAttribute(Element element, String attributeName, ObjectDescriptor descriptor, String fieldName, Parse parse) {
        Integer intValue = XmlUtil.attributeInteger(element, attributeName, false, parse);
        if (intValue != null) {
            descriptor.addInjection(fieldName, new IntegerDescriptor(intValue));
        }
    }

    private void parseBooleanAttribute(Element element, String attributeName, ObjectDescriptor descriptor, String fieldName, Parse parse) {
        Boolean boolValue = XmlUtil.attributeBoolean(element, attributeName, false, parse);
        if (boolValue != null) {
            descriptor.addInjection(fieldName, new BooleanDescriptor(boolValue));
        }
    }
}

