/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.interceptor;

import org.ow2.bonita.env.interceptor.DescNullFirstInterceptor;

public class MSSQLServerDescNullsFirstInterceptor
extends DescNullFirstInterceptor {
    private static final long serialVersionUID = -1791670858498091038L;
    private final String[] keywords = new String[]{"limit"};

    @Override
    protected int getLast(String query, String end) {
        return query.indexOf(end);
    }

    @Override
    protected String getDescValue(String current) {
        StringBuilder builder = new StringBuilder("(case when ");
        builder.append(current).append(" is null then 0 else 1 end), ").append(current).append(" desc");
        return builder.toString();
    }

    @Override
    protected String getAscValue(String current) {
        StringBuilder builder = new StringBuilder("(case when ");
        builder.append(current).append(" is null then 1 else 0 end), ").append(current).append(" asc");
        return builder.toString();
    }

    @Override
    protected String formatSelectQuery(String sql, int orderByIndex, String orderByContent, int orderByEndIndex) {
        if (!sql.startsWith("select distinct ")) {
            return super.formatSelectQuery(sql, orderByIndex, orderByContent, orderByEndIndex);
        }
        return this.formatSelectDistinctQuery(sql, orderByIndex, orderByContent, orderByEndIndex);
    }

    String formatSelectDistinctQuery(String sql, int orderByIndex, String orderByContent, int orderByEndIndex) {
        int firstSelectedFieldIndex = 16;
        int lastSelectedFieldIndex = sql.indexOf("from ");
        String selectedFields = sql.substring(16, lastSelectedFieldIndex);
        selectedFields = selectedFields.replaceAll(" as [a-zA-Z_0-9]*", "");
        selectedFields = selectedFields.replaceAll("top [0-9]* ", "");
        StringBuilder builder = new StringBuilder("select ");
        builder.append(sql.substring(16, orderByIndex)).append("group by ").append(selectedFields).append("order by ").append(orderByContent).append(" ").append(sql.substring(orderByEndIndex));
        return builder.toString();
    }

    @Override
    protected String[] getKeyWordsAfterOrderBy() {
        return this.keywords;
    }
}

