/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.exception;

import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.ExceptionManager;

public class ActivityDefNotFoundException
extends BonitaException {
    private static final long serialVersionUID = 1L;
    private final String processId;
    private final String activityId;
    private final ActivityDefinitionUUID activityUUID;

    public ActivityDefNotFoundException(String id, String processId, String activityId) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("ADNFE1", activityId, processId));
        this.processId = processId;
        this.activityId = activityId;
        this.activityUUID = null;
    }

    public ActivityDefNotFoundException(String id, ActivityDefinitionUUID activityDefinitionUUID) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("ADNFE2", activityDefinitionUUID));
        this.activityUUID = activityDefinitionUUID;
        this.processId = null;
        this.activityId = null;
    }

    public ActivityDefNotFoundException(ActivityDefNotFoundException e) {
        super(e.getMessage());
        this.activityUUID = e.getActivityUUID();
        this.processId = e.getProcessId();
        this.activityId = e.getActivityId();
    }

    public static ActivityDefNotFoundException build(String id, Throwable e) {
        if (!(e instanceof ActivityDefNotFoundException)) {
            ExceptionManager manager = ExceptionManager.getInstance();
            String message = manager.getIdMessage(id) + manager.getMessage("ADNFE3", new Object[0]);
            throw new BonitaInternalException(message, e);
        }
        return new ActivityDefNotFoundException((ActivityDefNotFoundException)e);
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public ActivityDefinitionUUID getActivityUUID() {
        return this.activityUUID;
    }
}

