/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.exception;

import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.DataFieldDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.ExceptionManager;

public class DataFieldNotFoundException
extends BonitaException {
    private static final long serialVersionUID = -2248193638347196601L;
    private final String dataFieldId;
    private final ProcessDefinitionUUID processUUID;
    private final ActivityDefinitionUUID activityUUID;
    private final DataFieldDefinitionUUID dataFieldUUID;

    public DataFieldNotFoundException(String id, String dataFieldId, ProcessDefinitionUUID processDefinitionUUID) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("DFNFE1", dataFieldId, processDefinitionUUID));
        this.dataFieldId = dataFieldId;
        this.processUUID = processDefinitionUUID;
        this.activityUUID = null;
        this.dataFieldUUID = null;
    }

    public DataFieldNotFoundException(String id, String dataFieldId, ActivityDefinitionUUID activityDefinitionUUID) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("DFNFE2", dataFieldId, activityDefinitionUUID));
        this.dataFieldId = dataFieldId;
        this.processUUID = null;
        this.activityUUID = activityDefinitionUUID;
        this.dataFieldUUID = null;
    }

    public DataFieldNotFoundException(String id, DataFieldDefinitionUUID dataFieldDefinitionUUID) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("DFNFE3", dataFieldDefinitionUUID));
        this.dataFieldUUID = dataFieldDefinitionUUID;
        this.dataFieldId = null;
        this.processUUID = null;
        this.activityUUID = null;
    }

    public DataFieldNotFoundException(DataFieldNotFoundException e) {
        super(e.getMessage());
        this.dataFieldId = e.getDataFieldId();
        this.processUUID = e.getProcessUUID();
        this.activityUUID = e.getActivityUUID();
        this.dataFieldUUID = e.getDataFieldUUID();
    }

    public static DataFieldNotFoundException build(String id, Throwable e) {
        if (!(e instanceof DataFieldNotFoundException)) {
            ExceptionManager manager = ExceptionManager.getInstance();
            String message = manager.getIdMessage(id) + manager.getMessage("DFNFE4", new Object[0]);
            throw new BonitaInternalException(message, e);
        }
        return new DataFieldNotFoundException((DataFieldNotFoundException)e);
    }

    public String getDataFieldId() {
        return this.dataFieldId;
    }

    public ProcessDefinitionUUID getProcessUUID() {
        return this.processUUID;
    }

    public DataFieldDefinitionUUID getDataFieldUUID() {
        return this.dataFieldUUID;
    }

    public ActivityDefinitionUUID getActivityUUID() {
        return this.activityUUID;
    }
}

