/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.internal;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.ow2.bonita.facade.exception.DeploymentException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.exception.RuleNotFoundException;
import org.ow2.bonita.facade.exception.UndeletableInstanceException;
import org.ow2.bonita.facade.exception.UndeletableProcessException;
import org.ow2.bonita.facade.internal.AbstractRemoteManagementAPI;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.rest.wrapper.RESTSet;
import org.ow2.bonita.facade.uuid.AbstractUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;

@Path(value="/API/managementAPI/")
@Produces(value={"text/*", "application/xml"})
@Consumes(value={"application/x-www-form-urlencoded", "text/*", "application/xml"})
public interface RESTRemoteManagementAPI
extends AbstractRemoteManagementAPI {
    @POST
    @Path(value="disable")
    public void disable(@FormParam(value="processUUIDs") List<ProcessDefinitionUUID> var1, @FormParam(value="options") Map<String, String> var2) throws DeploymentException, RemoteException;

    @POST
    @Path(value="enable")
    public void enable(@FormParam(value="processUUIDs") List<ProcessDefinitionUUID> var1, @FormParam(value="options") Map<String, String> var2) throws DeploymentException, RemoteException;

    @POST
    @Path(value="archive")
    public void archive(@FormParam(value="processUUIDs") List<ProcessDefinitionUUID> var1, @FormParam(value="options") Map<String, String> var2) throws DeploymentException, RemoteException;

    @POST
    @Path(value="delete")
    public void delete(@FormParam(value="processUUIDs") List<ProcessDefinitionUUID> var1, @FormParam(value="options") Map<String, String> var2) throws ProcessNotFoundException, UndeletableProcessException, UndeletableInstanceException, RemoteException;

    @POST
    @Path(value="applyRuleToEntities/{ruleUUID}")
    public void applyRuleToEntities(@PathParam(value="ruleUUID") String var1, @FormParam(value="userUUIDs") List<String> var2, @FormParam(value="roleUUIDs") List<String> var3, @FormParam(value="groupUUIDs") List<String> var4, @FormParam(value="membershipUUIDs") List<String> var5, @FormParam(value="entityIDs") List<String> var6, @FormParam(value="options") Map<String, String> var7) throws RuleNotFoundException, RemoteException;

    @POST
    @Path(value="getAllApplicableRules")
    public List<Rule> getAllApplicableRules(@QueryParam(value="userUUID") String var1, @FormParam(value="roleUUIDs") List<String> var2, @FormParam(value="groupUUIDs") List<String> var3, @FormParam(value="membershipUUIDs") List<String> var4, @QueryParam(value="entityID") String var5, @FormParam(value="options") Map<String, String> var6) throws RemoteException;

    @POST
    @Path(value="getApplicableRules")
    public List<Rule> getApplicableRules(@QueryParam(value="ruleType") Rule.RuleType var1, @QueryParam(value="userUUID") String var2, @FormParam(value="roleUUIDs") List<String> var3, @FormParam(value="groupUUIDs") List<String> var4, @FormParam(value="membershipUUIDs") List<String> var5, @QueryParam(value="entityID") String var6, @FormParam(value="options") Map<String, String> var7) throws RemoteException;

    @POST
    @Path(value="getRulesByUUIDs")
    public List<Rule> getRulesByUUIDs(@FormParam(value="ruleUUIDs") List<String> var1, @FormParam(value="options") Map<String, String> var2) throws RuleNotFoundException, RemoteException;

    @POST
    @Path(value="removeRuleFromEntities/{ruleUUID}")
    public void removeRuleFromEntities(@PathParam(value="ruleUUID") String var1, @FormParam(value="userUUIDs") List<String> var2, @FormParam(value="roleUUIDs") List<String> var3, @FormParam(value="groupUUIDs") List<String> var4, @FormParam(value="membershipUUIDs") List<String> var5, @FormParam(value="entityIDs") List<String> var6, @FormParam(value="options") Map<String, String> var7) throws RuleNotFoundException, RemoteException;

    @POST
    @Path(value="addExceptionsToRuleByUUID/{ruleUUID}")
    public <E extends AbstractUUID> void addExceptionsToRuleByUUID(@PathParam(value="ruleUUID") String var1, @FormParam(value="exceptions") RESTSet var2, @FormParam(value="options") Map<String, String> var3) throws RuleNotFoundException, RemoteException;

    @POST
    @Path(value="removeExceptionsFromRuleByUUID/{ruleUUID}")
    public <E extends AbstractUUID> void removeExceptionsFromRuleByUUID(@PathParam(value="ruleUUID") String var1, @FormParam(value="exceptions") RESTSet var2, @FormParam(value="options") Map<String, String> var3) throws RuleNotFoundException, RemoteException;
}

