/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.rest.stringconverter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.spi.StringConverter;
import org.ow2.bonita.facade.rest.wrapper.RESTMap;
import org.ow2.bonita.util.xml.XStreamUtil;

@Provider
public class MapStringConverter
implements StringConverter<Map<?, ?>> {
    private static final Logger LOG = Logger.getLogger(MapStringConverter.class.getName());

    public Map<?, ?> fromString(String str) {
        block6: {
            try {
                if (!str.startsWith("<")) {
                    str = URLDecoder.decode(str, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                if (!LOG.isLoggable(Level.WARNING)) break block6;
                LOG.warning("Cannot decode " + str + " using UTF-8");
            }
        }
        XStream xstream = XStreamUtil.getDefaultXstream();
        try {
            return (Map)xstream.fromXML(str);
        }
        catch (ConversionException ce) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Unable to deserialize map due to " + ce.getMessage() + ". Keep the XML and deserialise it later");
            }
            return new RESTMap(str);
        }
    }

    public String toString(Map<?, ?> value) {
        XStream xstream = XStreamUtil.getDefaultXstream();
        return xstream.toXML(value);
    }
}

