/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ConnectorExecutionDescriptor
implements Serializable {
    private static final long serialVersionUID = 3490306986344558425L;
    private final String className;
    private Map<String, Serializable[]> inputParameters;
    private Map<String, Serializable[]> outputParameters;
    private boolean throwingException;

    public ConnectorExecutionDescriptor(String className) {
        this.className = className;
        this.throwingException = true;
    }

    public ConnectorExecutionDescriptor(String className, Map<String, Serializable[]> inputParameters, Map<String, Serializable[]> outputParameters) {
        this(className);
        this.inputParameters = inputParameters;
        this.outputParameters = outputParameters;
        this.throwingException = true;
    }

    public ConnectorExecutionDescriptor(String className, Map<String, Serializable[]> inputParameters, Map<String, Serializable[]> outputParameters, boolean throwingException) {
        this(className, inputParameters, outputParameters);
        this.throwingException = throwingException;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, Serializable[]> getInputParameters() {
        if (this.inputParameters == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.inputParameters);
    }

    public void addInputParameter(String key, Serializable ... values) {
        if (this.inputParameters == null) {
            this.inputParameters = new HashMap<String, Serializable[]>();
        }
        this.inputParameters.put(key, values);
    }

    public void addInputParameters(Map<String, Serializable[]> parameters) {
        if (this.inputParameters == null) {
            this.inputParameters = new HashMap<String, Serializable[]>();
        }
        this.inputParameters.putAll(parameters);
    }

    public Map<String, Serializable[]> getOutputParameters() {
        if (this.outputParameters == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.outputParameters);
    }

    public void addOutputParameter(String key, Serializable ... values) {
        if (this.outputParameters == null) {
            this.outputParameters = new HashMap<String, Serializable[]>(1);
        }
        this.outputParameters.put(key, values);
    }

    public void addOutputParameters(Map<String, Serializable[]> parameters) {
        if (this.outputParameters == null) {
            this.outputParameters = new HashMap<String, Serializable[]>(parameters.size());
        }
        this.outputParameters.putAll(parameters);
    }

    public boolean isThrowingException() {
        return this.throwingException;
    }

    public void setThrowingException(boolean throwingException) {
        this.throwingException = throwingException;
    }
}

