/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;

public class ReplayCommand
implements Command<Boolean> {
    private static final long serialVersionUID = -2748779080782099313L;
    protected ActivityInstanceUUID myActivityUUID;

    public ReplayCommand(ActivityInstanceUUID activityUUID) {
        this.myActivityUUID = activityUUID;
    }

    @Override
    public Boolean execute(Environment env) throws Exception {
        InternalActivityInstance activityInstance = EnvTool.getJournalQueriers().getActivityInstance(this.myActivityUUID);
        if (activityInstance == null) {
            throw new ActivityNotFoundException("R1", this.myActivityUUID);
        }
        if (activityInstance.getState() == ActivityState.FAILED) {
            activityInstance.setActivityState(ActivityState.READY, "SYSTEM");
            Execution internalExecution = ReplayCommand.getExecution(activityInstance);
            InternalActivityDefinition activityDef = internalExecution.getNode();
            AbstractActivity abstractActivity = (AbstractActivity)activityDef.getBehaviour();
            abstractActivity.signal(internalExecution, "async", null);
            return true;
        }
        return false;
    }

    protected static Execution getExecution(ActivityInstance activityInstance) throws ActivityNotFoundException {
        return EnvTool.getJournalQueriers().getExecutionOnActivity(activityInstance.getProcessInstanceUUID(), activityInstance.getUUID());
    }
}

