/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.WebAPI;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.Document;
import org.ow2.bonita.facade.uuid.DocumentUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.LightProcessInstance;
import org.ow2.bonita.search.DocumentResult;
import org.ow2.bonita.search.DocumentSearchBuilder;
import org.ow2.bonita.search.index.DocumentIndex;
import org.ow2.bonita.util.Command;

public class WebDeleteAllProcessInstancesCommand
implements Command<Void> {
    private static final long serialVersionUID = 1L;
    private Set<ProcessDefinitionUUID> processUUIDs;
    private boolean deleteAttachments;

    public WebDeleteAllProcessInstancesCommand(Set<ProcessDefinitionUUID> processUUIDs) {
        this.processUUIDs = processUUIDs;
        this.deleteAttachments = false;
    }

    public WebDeleteAllProcessInstancesCommand(Set<ProcessDefinitionUUID> processUUIDs, boolean deleteAttachments) {
        this.processUUIDs = processUUIDs;
        this.deleteAttachments = deleteAttachments;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        if (this.processUUIDs != null && !this.processUUIDs.isEmpty()) {
            QueryRuntimeAPI queryRuntimeAPI = accessor.getQueryRuntimeAPI();
            Set<LightProcessInstance> instances = queryRuntimeAPI.getLightWeightProcessInstances(this.processUUIDs);
            WebAPI webAPI = accessor.getWebAPI();
            HashSet<ProcessInstanceUUID> uuids = new HashSet<ProcessInstanceUUID>();
            for (LightProcessInstance instance : instances) {
                uuids.add(instance.getUUID());
                this.deleteAttachments(instance.getProcessDefinitionUUID());
                if (uuids.size() != 100) continue;
                webAPI.removeAllCasesFromLabels(uuids);
                uuids.clear();
            }
            webAPI.removeAllCasesFromLabels(uuids);
            RuntimeAPI runtimeAPI = accessor.getRuntimeAPI();
            runtimeAPI.deleteAllProcessInstances(this.processUUIDs);
        }
        return null;
    }

    private void deleteAttachments(ProcessDefinitionUUID uuid) throws DocumentNotFoundException {
        DocumentResult searchResult;
        DocumentSearchBuilder documentSearchBuilder = new DocumentSearchBuilder();
        documentSearchBuilder.criterion(this.deleteAttachments ? DocumentIndex.PROCESS_DEFINITION_UUID : DocumentIndex.PROCESS_DEFINITION_UUID_WITHOUT_INSTANCES).equalsTo(uuid.getValue());
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        QueryRuntimeAPI queryRuntimeAPI = accessor.getQueryRuntimeAPI();
        RuntimeAPI runtimeAPI = accessor.getRuntimeAPI();
        do {
            searchResult = queryRuntimeAPI.searchDocuments(documentSearchBuilder, 0, 100);
            List<Document> documentsFound = searchResult.getDocuments();
            DocumentUUID[] documentsToDelete = new DocumentUUID[documentsFound.size()];
            int i = 0;
            for (Document document : documentsFound) {
                documentsToDelete[i] = document.getUUID();
                ++i;
            }
            runtimeAPI.deleteDocuments(true, documentsToDelete);
        } while (searchResult.getCount() > 0);
    }
}

