/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.light.LightProcessInstance;
import org.ow2.bonita.util.Command;

public class WebGetLightProcessInstancesFromActiveUsersAndActivityInstanceExpectedEndDate
implements Command<List<LightProcessInstance>> {
    private static final long serialVersionUID = 1073206586260605889L;
    private final String userId;
    private final Collection<String> roleUUIDs;
    private final Collection<String> groupUUIDs;
    private final Collection<String> membershipUUIDs;
    private final String username;
    private final int fromIndex;
    private final int pageSize;
    private final boolean searchInHistory;
    private final int remainingDays;

    public WebGetLightProcessInstancesFromActiveUsersAndActivityInstanceExpectedEndDate(String userId, Set<String> roleUUIDs, Set<String> groupUUIDs, Set<String> membershipUUIDs, String username, int remainingDays, int fromIndex, int pageSize, boolean searchInHistory) {
        this.remainingDays = remainingDays;
        this.userId = userId;
        this.roleUUIDs = roleUUIDs;
        this.groupUUIDs = groupUUIDs;
        this.membershipUUIDs = membershipUUIDs;
        this.username = username;
        this.fromIndex = fromIndex;
        this.pageSize = pageSize;
        this.searchInHistory = searchInHistory;
    }

    @Override
    public List<LightProcessInstance> execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        QueryRuntimeAPI queryRuntimeAPI = this.searchInHistory ? accessor.getQueryRuntimeAPI("historyQueryList") : accessor.getQueryRuntimeAPI("journalQueryList");
        ManagementAPI managementAPI = accessor.getManagementAPI();
        HashSet<String> exceptions = new HashSet<String>();
        List<Rule> applicableRules = managementAPI.getApplicableRules(Rule.RuleType.PROCESS_READ, this.userId, this.roleUUIDs, this.groupUUIDs, this.membershipUUIDs, this.username);
        for (Rule rule : applicableRules) {
            exceptions.addAll(rule.getItems());
        }
        HashSet<ProcessDefinitionUUID> processUUIDs = new HashSet<ProcessDefinitionUUID>();
        for (String processUUID : exceptions) {
            processUUIDs.add(new ProcessDefinitionUUID(processUUID));
        }
        PrivilegePolicy processStartPolicy = managementAPI.getRuleTypePolicy(Rule.RuleType.PROCESS_READ);
        switch (processStartPolicy) {
            case ALLOW_BY_DEFAULT: {
                List<LightProcessInstance> result;
                if (processUUIDs != null && !processUUIDs.isEmpty()) {
                    result = queryRuntimeAPI.getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDateExcept(this.username, this.remainingDays, this.fromIndex, this.pageSize, processUUIDs);
                    return result;
                }
                result = queryRuntimeAPI.getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(this.username, this.remainingDays, this.fromIndex, this.pageSize);
                return result;
            }
            case DENY_BY_DEFAULT: {
                List<LightProcessInstance> result;
                if (processUUIDs.size() > 0) {
                    result = queryRuntimeAPI.getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(this.username, this.remainingDays, this.fromIndex, this.pageSize, processUUIDs);
                    return result;
                }
                return Collections.emptyList();
            }
        }
        throw new IllegalArgumentException();
    }
}

