/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.paging.ProcessDefinitionCriterion;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.util.Command;

public class WebGetManageableProcessesCommand
implements Command<List<LightProcessDefinition>> {
    private static final long serialVersionUID = -822497593009305244L;
    private final String userUUID;
    private final Collection<String> roleUUIDs;
    private final Collection<String> groupUUIDs;
    private final Collection<String> membershipUUIDs;
    private final String entityID;
    private final int fromIndex;
    private final int pageSize;
    private final boolean searchInHistory;

    public WebGetManageableProcessesCommand(int fromIndex, int pageSize, boolean searchInHistory, String userUUID, Collection<String> roleUUIDs, Collection<String> groupUUIDs, Collection<String> membershipUUIDs, String entityID) {
        this.fromIndex = fromIndex;
        this.pageSize = pageSize;
        this.searchInHistory = searchInHistory;
        this.userUUID = userUUID;
        this.roleUUIDs = roleUUIDs;
        this.groupUUIDs = groupUUIDs;
        this.membershipUUIDs = membershipUUIDs;
        this.entityID = entityID;
    }

    @Override
    public List<LightProcessDefinition> execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        ManagementAPI managementAPI = accessor.getManagementAPI();
        QueryDefinitionAPI queryDefinitionAPI = this.searchInHistory ? accessor.getQueryDefinitionAPI("historyQueryList") : accessor.getQueryDefinitionAPI("journalQueryList");
        HashSet<String> exceptions = new HashSet<String>();
        List<Rule> applicableRules = managementAPI.getApplicableRules(Rule.RuleType.PROCESS_MANAGE, this.userUUID, this.roleUUIDs, this.groupUUIDs, this.membershipUUIDs, this.entityID);
        for (Rule rule : applicableRules) {
            exceptions.addAll(rule.getItems());
        }
        HashSet<ProcessDefinitionUUID> processUUIDs = new HashSet<ProcessDefinitionUUID>();
        for (String processUUID : exceptions) {
            processUUIDs.add(new ProcessDefinitionUUID(processUUID));
        }
        PrivilegePolicy processStartPolicy = managementAPI.getRuleTypePolicy(Rule.RuleType.PROCESS_MANAGE);
        switch (processStartPolicy) {
            case ALLOW_BY_DEFAULT: {
                if (processUUIDs != null && !processUUIDs.isEmpty()) {
                    return queryDefinitionAPI.getAllLightProcessesExcept(processUUIDs, this.fromIndex, this.pageSize);
                }
                return queryDefinitionAPI.getLightProcesses(this.fromIndex, this.pageSize);
            }
            case DENY_BY_DEFAULT: {
                if (processUUIDs.size() > 0) {
                    return queryDefinitionAPI.getLightProcesses(processUUIDs, this.fromIndex, this.pageSize, ProcessDefinitionCriterion.DEFAULT);
                }
                return Collections.emptyList();
            }
        }
        throw new IllegalArgumentException();
    }
}

