/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.util.Command;

public class WebGetProcessInstancesNumberWithInvolvedUserAndCategory
implements Command<Integer> {
    private static final long serialVersionUID = 6841540520107266785L;
    private final String userId;
    private final Set<String> roleUUIDs;
    private final Set<String> groupUUIDs;
    private final Set<String> membershipUUIDs;
    private final String username;
    private final boolean searchInHistory;
    private final String category;

    public WebGetProcessInstancesNumberWithInvolvedUserAndCategory(String userId, Set<String> roleUUIDs, Set<String> groupUUIDs, Set<String> membershipUUIDs, String username, String category, boolean searchInHistory) {
        this.userId = userId;
        this.roleUUIDs = roleUUIDs;
        this.groupUUIDs = groupUUIDs;
        this.membershipUUIDs = membershipUUIDs;
        this.username = username;
        this.searchInHistory = searchInHistory;
        this.category = category;
    }

    @Override
    public Integer execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        QueryRuntimeAPI queryRuntimeAPI = this.searchInHistory ? accessor.getQueryRuntimeAPI("historyQueryList") : accessor.getQueryRuntimeAPI("journalQueryList");
        ManagementAPI managementAPI = accessor.getManagementAPI();
        HashSet<String> exceptions = new HashSet<String>();
        List<Rule> applicableRules = managementAPI.getApplicableRules(Rule.RuleType.PROCESS_READ, this.userId, this.roleUUIDs, this.groupUUIDs, this.membershipUUIDs, this.username);
        for (Rule rule : applicableRules) {
            exceptions.addAll(rule.getItems());
        }
        HashSet<ProcessDefinitionUUID> processUUIDs = new HashSet<ProcessDefinitionUUID>();
        for (String processUUID : exceptions) {
            processUUIDs.add(new ProcessDefinitionUUID(processUUID));
        }
        PrivilegePolicy processStartPolicy = managementAPI.getRuleTypePolicy(Rule.RuleType.PROCESS_READ);
        switch (processStartPolicy) {
            case ALLOW_BY_DEFAULT: {
                Integer result;
                if (processUUIDs != null && !processUUIDs.isEmpty()) {
                    result = queryRuntimeAPI.getNumberOfParentProcessInstancesWithInvolvedUserAndCategoryExcept(this.username, this.category, processUUIDs);
                    return result;
                }
                result = queryRuntimeAPI.getNumberOfParentProcessInstancesWithInvolvedUserAndCategory(this.username, this.category);
                return result;
            }
            case DENY_BY_DEFAULT: {
                Integer result;
                if (processUUIDs.size() > 0) {
                    result = queryRuntimeAPI.getNumberOfParentProcessInstancesWithInvolvedUserAndCategory(this.username, this.category, processUUIDs);
                    return result;
                }
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }
}

