/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.impl;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Arrays;
import org.ow2.bonita.util.Misc;

public class ObjectVariable
implements Serializable {
    private static final long serialVersionUID = 233822925089125972L;
    private byte[] value;

    public ObjectVariable(Object value) throws IOException, ClassNotFoundException, NotSerializableException {
        this.setValue(value);
    }

    public void setValue(Object value) throws IOException, ClassNotFoundException {
        if (value == null) {
            return;
        }
        if (!(value instanceof Serializable)) {
            throw new NotSerializableException(value.getClass().getName());
        }
        this.value = Misc.serialize((Serializable)value);
    }

    public Serializable getValue() throws IOException, ClassNotFoundException {
        if (this.value == null) {
            return null;
        }
        return Misc.deserialize(this.value);
    }

    public String toString() {
        if (this.value == null) {
            return this.getClass().getSimpleName() + " is null";
        }
        return this.getClass().getSimpleName() + ": " + this.value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectVariable)) {
            return false;
        }
        ObjectVariable other = (ObjectVariable)obj;
        return Arrays.equals(this.value, other.value);
    }
}

