/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.persistence.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.transform.Transformers;
import org.hibernate.type.Type;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.impl.MetaDataImpl;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.identity.impl.GroupImpl;
import org.ow2.bonita.facade.identity.impl.MembershipImpl;
import org.ow2.bonita.facade.identity.impl.ProfileMetadataImpl;
import org.ow2.bonita.facade.identity.impl.RoleImpl;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.facade.paging.ActivityInstanceCriterion;
import org.ow2.bonita.facade.paging.GroupCriterion;
import org.ow2.bonita.facade.paging.ProcessDefinitionCriterion;
import org.ow2.bonita.facade.paging.ProcessInstanceCriterion;
import org.ow2.bonita.facade.paging.RoleCriterion;
import org.ow2.bonita.facade.paging.UserCriterion;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.privilege.RuleTypePolicy;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.Category;
import org.ow2.bonita.facade.runtime.Comment;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.runtime.WebTemporaryToken;
import org.ow2.bonita.facade.runtime.impl.CaseImpl;
import org.ow2.bonita.facade.runtime.impl.CategoryImpl;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.runtime.impl.LabelImpl;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.CategoryUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.persistence.DocumentDbSession;
import org.ow2.bonita.persistence.EventDbSession;
import org.ow2.bonita.persistence.IdentityDbSession;
import org.ow2.bonita.persistence.JournalDbSession;
import org.ow2.bonita.persistence.PrivilegeDbSession;
import org.ow2.bonita.persistence.QuerierDbSession;
import org.ow2.bonita.persistence.WebDbSession;
import org.ow2.bonita.persistence.WebTokenManagementDbSession;
import org.ow2.bonita.persistence.db.HibernateDbSession;
import org.ow2.bonita.runtime.event.EventCouple;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.event.JobLock;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.search.DocumentCriterion;
import org.ow2.bonita.search.DocumentSearchBuilder;
import org.ow2.bonita.search.SearchQueryBuilder;
import org.ow2.bonita.search.SearchUtil;
import org.ow2.bonita.search.index.DocumentIndex;
import org.ow2.bonita.services.Document;
import org.ow2.bonita.services.DocumentContent;
import org.ow2.bonita.services.DocumentDescriptor;
import org.ow2.bonita.services.DocumentDescriptorMapping;
import org.ow2.bonita.services.DocumentVersion;
import org.ow2.bonita.services.impl.DocumentContentImpl;
import org.ow2.bonita.services.impl.DocumentDescriptorImpl;
import org.ow2.bonita.services.impl.DocumentVersionImpl;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.DateUtil;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessInstanceEndedDateComparatorAsc;
import org.ow2.bonita.util.ProcessInstanceEndedDateComparatorDesc;
import org.ow2.bonita.util.ProcessInstanceLastUpdateComparator;
import org.ow2.bonita.util.ProcessInstanceLastUpdateComparatorAsc;
import org.ow2.bonita.util.ProcessInstanceNbComparatorAsc;
import org.ow2.bonita.util.ProcessInstanceNbComparatorDesc;
import org.ow2.bonita.util.ProcessInstanceStartedDateComparatorAsc;
import org.ow2.bonita.util.ProcessInstanceStartedDateComparatorDesc;
import org.ow2.bonita.util.ProcessInstanceUUIDComparatorAsc;
import org.ow2.bonita.util.ProcessInstanceUUIDComparatorDesc;
import org.ow2.bonita.util.hibernate.GenericEnumUserType;

public class DbSessionImpl
extends HibernateDbSession
implements QuerierDbSession,
JournalDbSession,
WebDbSession,
IdentityDbSession,
EventDbSession,
PrivilegeDbSession,
WebTokenManagementDbSession,
DocumentDbSession {
    private static final Logger LOG = Logger.getLogger(DbSessionImpl.class.getName());
    private static final int MAX_LOOP = 100;
    private static final long PAUSE_TIME_MILLIS = 100L;
    private static final String METADATA_TABLE = "BN_METADATA";
    private static final String EXECUTION_TABLE = "BN_PVM_EXEC";
    private static final Type DEFINITION_STATE_USER_TYPE = Hibernate.custom(GenericEnumUserType.class, (String[])new String[]{"enumClass"}, (String[])new String[]{ProcessDefinition.ProcessState.class.getName()});
    private static final Type ACTIVITY_STATE_USER_TYPE = Hibernate.custom(GenericEnumUserType.class, (String[])new String[]{"enumClass"}, (String[])new String[]{ActivityState.class.getName()});
    private static final Type INSTANCE_STATE_USER_TYPE = Hibernate.custom(GenericEnumUserType.class, (String[])new String[]{"enumClass"}, (String[])new String[]{InstanceState.class.getName()});
    protected static final Version LUCENE_VERSION = SearchUtil.LUCENE_VERSION;

    public DbSessionImpl(Session session) {
        this.setSession(session);
    }

    private static String getInsertMetadataStatement(String schemaPrefix) {
        return "insert into " + schemaPrefix + METADATA_TABLE + " (key_, value_) values (?,'0')";
    }

    private static String getSelectMetadataStatement(String schemaPrefix) {
        return "select value_ from " + schemaPrefix + METADATA_TABLE + " where key_=?";
    }

    private static String getLockMetadataStatement(String schemaPrefix) {
        return "update " + schemaPrefix + METADATA_TABLE + " set value_ = value_ where key_=?";
    }

    private static String getUpdateMetadata(String schemaPrefix) {
        return "update " + schemaPrefix + METADATA_TABLE + " set value_ = ? where key_=?";
    }

    private static String getRemoveMetadataStatement(String schemaPrefix) {
        return "delete from " + schemaPrefix + METADATA_TABLE + " where key_=?";
    }

    private static String getRemoveExecution(String schemaPrefix) {
        return "delete from " + schemaPrefix + EXECUTION_TABLE + " where dbid_=?";
    }

    @Override
    public long getLockedMetadata(String key) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            long l = this.getMetadata(connection, key);
            return l;
        }
        catch (SQLException e) {
            throw new BonitaInternalException("Unexpected DB access exception: " + e, e);
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    @Override
    public void lockMetadata(String key) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            boolean locked = this.lockMetadata(connection, key);
            if (!locked) {
                this.createMetadata(connection, key);
            }
        }
        catch (SQLException e) {
            throw new BonitaInternalException("Unexpected DB access exception: " + e, e);
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    @Override
    public void updateLockedMetadata(String key, long value) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            this.updateMetadata(connection, key, value);
        }
        catch (SQLException e) {
            throw new BonitaInternalException("Unexpected DB access exception: " + e, e);
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    @Override
    public void removeLockedMetadata(String key) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            this.removeMetadata(connection, key);
        }
        catch (SQLException e) {
            throw new BonitaInternalException("Unexpected DB access exception: " + e, e);
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    private void releaseConnection(Connection connection) {
        block3: {
            if (connection != null && this.shouldReleaseConnections()) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("SQLException during connection close: " + e);
                }
            }
        }
    }

    private boolean shouldReleaseConnections() {
        return ((SessionFactoryImplementor)this.session.getSessionFactory()).getSettings().getConnectionReleaseMode() == ConnectionReleaseMode.AFTER_STATEMENT;
    }

    private Connection getConnection() {
        return this.session.connection();
    }

    private long getMetadata(Connection connection, String key) throws SQLException {
        String schemaPrefix = this.getSchemaPrefix();
        PreparedStatement selectStmt = connection.prepareStatement(DbSessionImpl.getSelectMetadataStatement(schemaPrefix));
        try {
            selectStmt.setString(1, key);
            ResultSet resultSet = selectStmt.executeQuery();
            try {
                if (resultSet.next()) {
                    String value = resultSet.getString(1);
                    long l = Long.valueOf(value);
                    return l;
                }
                throw new IllegalStateException("value not found for key=" + key);
            }
            finally {
                resultSet.close();
            }
        }
        finally {
            selectStmt.close();
        }
    }

    private String getSchemaPrefix() throws SQLException {
        String schemaPrefix = "";
        String defaultSchema = ((SessionFactoryImplementor)this.session.getSessionFactory()).getSettings().getDefaultSchemaName();
        if (defaultSchema != null && !defaultSchema.trim().isEmpty()) {
            schemaPrefix = defaultSchema + ".";
        }
        return schemaPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetadata(Connection connection, String key, long nb) throws SQLException {
        String schemaName = this.getSchemaPrefix();
        PreparedStatement updateStmt = connection.prepareStatement(DbSessionImpl.getUpdateMetadata(schemaName));
        try {
            updateStmt.setString(1, String.valueOf(nb));
            updateStmt.setString(2, key);
            updateStmt.executeUpdate();
        }
        finally {
            updateStmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteExecution(long id) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            String schemaName = this.getSchemaPrefix();
            PreparedStatement updateStmt = connection.prepareStatement(DbSessionImpl.getRemoveExecution(schemaName));
            try {
                updateStmt.setLong(1, id);
                updateStmt.executeUpdate();
            }
            finally {
                updateStmt.close();
            }
        }
        catch (SQLException e) {
            throw new BonitaInternalException("Unexpected DB access exception: " + e, e);
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMetadata(Connection connection, String key) throws SQLException {
        String schemaName = this.getSchemaPrefix();
        PreparedStatement updateStmt = connection.prepareStatement(DbSessionImpl.getRemoveMetadataStatement(schemaName));
        try {
            updateStmt.setString(1, key);
            updateStmt.executeUpdate();
        }
        finally {
            updateStmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMetadata(Connection connection, String key) throws SQLException {
        int loops = 0;
        String schemaName = this.getSchemaPrefix();
        do {
            PreparedStatement insertStmt = connection.prepareStatement(DbSessionImpl.getInsertMetadataStatement(schemaName));
            try {
                insertStmt.setString(1, key);
                insertStmt.executeUpdate();
                return;
            }
            catch (SQLException e) {
                if (this.isConstraintViolation(e)) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        LOG.log(Level.FINE, "interrupted");
                    }
                    boolean locked = this.lockMetadata(connection, key);
                    if (locked) {
                        return;
                    }
                    continue;
                }
                throw e;
            }
            finally {
                insertStmt.close();
            }
        } while (++loops < 100);
        throw new IllegalStateException(" Could not create or lock value for key=" + key + ". Giving up after " + loops + " iterations.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lockMetadata(Connection connection, String key) throws SQLException {
        String schemaName = this.getSchemaPrefix();
        PreparedStatement updateStmt = connection.prepareStatement(DbSessionImpl.getLockMetadataStatement(schemaName));
        try {
            updateStmt.setString(1, key);
            int updateCount = updateStmt.executeUpdate();
            boolean bl = updateCount > 0;
            return bl;
        }
        finally {
            updateStmt.close();
        }
    }

    private boolean isConstraintViolation(SQLException e) {
        String classCode;
        String sqlState = this.getSqlState(e);
        boolean isConstraintViolation = false;
        if (sqlState != null && sqlState.length() >= 2 && "23".equals(classCode = sqlState.substring(0, 2))) {
            isConstraintViolation = true;
        }
        return isConstraintViolation;
    }

    private String getSqlState(SQLException e) {
        SQLException nextException;
        String sqlState = e.getSQLState();
        if (sqlState == null && e.getCause() != null && (nextException = e.getNextException()) != null) {
            sqlState = nextException.getSQLState();
        }
        return sqlState;
    }

    @Override
    public int getNumberOfParentProcessInstances() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfParentProcessInstances");
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfProcessInstances() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfProcessInstances");
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfProcesses() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfProcesses");
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Set<TaskInstance> getUserInstanceTasks(String userId, ProcessInstanceUUID instanceUUID, ActivityState taskState) {
        HashSet<TaskInstance> result = new HashSet<TaskInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getUserInstanceTasksWithState");
        query.setString("userId", userId);
        query.setString("instanceUUID", instanceUUID.toString());
        query.setParameter("state", (Object)taskState, ACTIVITY_STATE_USER_TYPE);
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<TaskInstance> getUserTasks(String userId, Collection<ActivityState> taskStates) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getUserTasksWithStates");
        query.setString("userId", userId);
        query.setParameterList("states", taskStates, ACTIVITY_STATE_USER_TYPE);
        HashSet<TaskInstance> result = new HashSet<TaskInstance>();
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<InternalActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID, String activityName) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstancesWithName");
        query.setString("instanceUUID", instanceUUID.getValue());
        query.setString("name", activityName);
        HashSet<InternalActivityInstance> result = new HashSet<InternalActivityInstance>();
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<InternalActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID, String activityName, String iterationId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstances");
        query.setString("instanceUUID", instanceUUID.getValue());
        query.setString("activityName", activityName);
        query.setString("iterationId", iterationId);
        HashSet<InternalActivityInstance> result = new HashSet<InternalActivityInstance>();
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public List<InternalActivityInstance> getActivityInstancesFromRoot(ProcessInstanceUUID rootInstanceUUID) {
        if (rootInstanceUUID == null) {
            return Collections.emptyList();
        }
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstancesFromRoot");
        query.setString("rootInstanceUUID", rootInstanceUUID.getValue());
        return query.list();
    }

    @Override
    public List<InternalActivityInstance> getActivityInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs) {
        if (rootInstanceUUIDs == null || rootInstanceUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID processInstanceUUID : rootInstanceUUIDs) {
            uuids.add(processInstanceUUID.getValue());
        }
        org.hibernate.Query query = this.getSession().getNamedQuery("getMatchingActivityInstancesFromRoot");
        query.setParameterList("rootInstanceUUIDs", uuids);
        return query.list();
    }

    @Override
    public Map<ProcessInstanceUUID, InternalActivityInstance> getLastUpdatedActivityInstanceFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, boolean considerSystemTaks) {
        if (rootInstanceUUIDs == null || rootInstanceUUIDs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ProcessInstanceUUID, InternalActivityInstance> result = new HashMap<ProcessInstanceUUID, InternalActivityInstance>();
        for (ProcessInstanceUUID processInstanceUUID : rootInstanceUUIDs) {
            org.hibernate.Query query = considerSystemTaks ? this.getSession().getNamedQuery("getMatchingActivityInstancesFromRoot") : this.getSession().getNamedQuery("getMatchingHumanTaskInstancesFromRoot");
            query.setParameterList("rootInstanceUUIDs", Arrays.asList(processInstanceUUID.getValue()));
            query.setMaxResults(1);
            List tmp = query.list();
            if (tmp == null || tmp.isEmpty()) continue;
            result.put(processInstanceUUID, (InternalActivityInstance)tmp.get(0));
        }
        return result;
    }

    @Override
    public List<InternalActivityInstance> getActivityInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, ActivityState state) {
        if (rootInstanceUUIDs == null || rootInstanceUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID processInstanceUUID : rootInstanceUUIDs) {
            uuids.add(processInstanceUUID.getValue());
        }
        org.hibernate.Query query = this.getSession().getNamedQuery("getMatchingActivityInstancesWithStateFromRoot");
        query.setParameterList("rootInstanceUUIDs", uuids);
        query.setParameter("state", (Object)state, ACTIVITY_STATE_USER_TYPE);
        return query.list();
    }

    @Override
    public TaskInstance getOneTask(String userId, ActivityState taskState) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getOneTask");
        query.setString("userId", userId);
        query.setParameter("state", (Object)taskState, ACTIVITY_STATE_USER_TYPE);
        query.setMaxResults(1);
        return (TaskInstance)query.uniqueResult();
    }

    @Override
    public TaskInstance getOneTask(String userId, ProcessDefinitionUUID processUUID, ActivityState taskState) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getOneTaskOfProcess");
        query.setString("userId", userId);
        query.setString("processUUID", processUUID.getValue());
        query.setParameter("state", (Object)taskState, ACTIVITY_STATE_USER_TYPE);
        query.setMaxResults(1);
        return (TaskInstance)query.uniqueResult();
    }

    @Override
    public TaskInstance getOneTask(String userId, ProcessInstanceUUID instanceUUID, ActivityState taskState) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getOneTaskOfInstance");
        query.setString("userId", userId);
        query.setString("instanceUUID", instanceUUID.getValue());
        query.setParameter("state", (Object)taskState, ACTIVITY_STATE_USER_TYPE);
        query.setMaxResults(1);
        return (TaskInstance)query.uniqueResult();
    }

    @Override
    public Set<InternalProcessInstance> getUserInstances(String userId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getUserInstances");
        query.setString("userId", userId);
        HashSet<InternalProcessInstance> result = new HashSet<InternalProcessInstance>();
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public List<InternalProcessInstance> getParentUserInstances(String userId, int fromIndex, int pageSize) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentUserInstancesPage");
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        query.setString("userId", userId);
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getParentUserInstances(String userId, int startingIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageOrderByInstanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageOrderByInstanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPage");
            }
        }
        query.setFirstResult(startingIndex);
        query.setMaxResults(pageSize);
        query.setString("userId", userId);
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public Set<InternalProcessInstance> getUserInstances(String userId, Date minStartDate) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getUserInstancesAfterDate");
        query.setString("userId", userId);
        query.setLong("minStartDate", minStartDate.getTime());
        HashSet<InternalProcessInstance> result = new HashSet<InternalProcessInstance>();
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<InternalProcessInstance> getUserParentInstances(String userId, Date minStartDate) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getUserParentInstancesAfterDate");
        query.setString("userId", userId);
        query.setLong("minStartDate", minStartDate.getTime());
        HashSet<InternalProcessInstance> result = new HashSet<InternalProcessInstance>();
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<InternalProcessInstance> getUserInstancesExcept(String userId, Set<ProcessInstanceUUID> instances) {
        if (instances == null || instances.isEmpty()) {
            return this.getUserInstances(userId);
        }
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID processInstanceUUID : instances) {
            uuids.add(processInstanceUUID.getValue());
        }
        org.hibernate.Query query = this.getSession().getNamedQuery("getUserInstancesExcept");
        query.setString("userId", userId);
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "uuids", uuids);
    }

    @Override
    public Set<InternalActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("findActivityInstances");
        query.setString("instanceUUID", instanceUUID.toString());
        List results = query.list();
        if (results != null) {
            return new HashSet<InternalActivityInstance>(results);
        }
        return null;
    }

    @Override
    public List<InternalActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID, int fromIndex, int pageSize, ActivityInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                query = this.getSession().getNamedQuery("findActivityInstancesOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                query = this.getSession().getNamedQuery("findActivityInstancesOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                query = this.getSession().getNamedQuery("findActivityInstancesOrderByEndedDateAsc");
                break;
            }
            case NAME_ASC: {
                query = this.getSession().getNamedQuery("findActivityInstancesOrderByNameAsc");
                break;
            }
            case PRIORITY_ASC: {
                query = this.getSession().getNamedQuery("findActivityInstancesOrderByPriorityAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                query = this.getSession().getNamedQuery("findActivityInstancesOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                query = this.getSession().getNamedQuery("findActivityInstancesOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                query = this.getSession().getNamedQuery("findActivityInstancesOrderByEndedDateDesc");
                break;
            }
            case NAME_DESC: {
                query = this.getSession().getNamedQuery("findActivityInstancesOrderByNameDesc");
                break;
            }
            case PRIORITY_DESC: {
                query = this.getSession().getNamedQuery("findActivityInstancesOrderByPriorityDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("findActivityInstancesOrderByLastUpdateDesc");
            }
        }
        query.setString("instanceUUID", instanceUUID.toString());
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        List results = query.list();
        if (results != null) {
            return new ArrayList<InternalActivityInstance>(results);
        }
        return null;
    }

    @Override
    public long getLastProcessInstanceNb(ProcessDefinitionUUID processUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getLastProcessInstanceNb");
        query.setString("processUUID", processUUID.getValue());
        query.setMaxResults(1);
        Long result = (Long)query.uniqueResult();
        if (result == null) {
            return -1L;
        }
        return result;
    }

    @Override
    public InternalProcessInstance getProcessInstance(ProcessInstanceUUID instanceUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("findProcessInstance");
        query.setString("instanceUUID", instanceUUID.toString());
        query.setMaxResults(1);
        return (InternalProcessInstance)query.uniqueResult();
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances() {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("findAllProcessInstances");
        List results = query.list();
        if (results != null) {
            processInsts.addAll(results);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(int fromIndex, int pageSize) {
        org.hibernate.Query query = this.getSession().getNamedQuery("findAllProcessInstances");
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                query = this.getSession().getNamedQuery("findAllProcessInstancesOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                query = this.getSession().getNamedQuery("findAllProcessInstancesOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                query = this.getSession().getNamedQuery("findAllProcessInstancesOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                query = this.getSession().getNamedQuery("findAllProcessInstancesOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                query = this.getSession().getNamedQuery("findAllProcessInstancesOrderByInstanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                query = this.getSession().getNamedQuery("findAllProcessInstancesOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                query = this.getSession().getNamedQuery("findAllProcessInstancesOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                query = this.getSession().getNamedQuery("findAllProcessInstancesOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                query = this.getSession().getNamedQuery("findAllProcessInstancesOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                query = this.getSession().getNamedQuery("findAllProcessInstancesOrderByInstanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("findAllProcessInstances");
            }
        }
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentProcessInstances(int maxResults, long time) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getMostRecentProcessInstances");
        query.setFirstResult(0);
        query.setLong("time", time);
        query.setMaxResults(maxResults);
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentProcessInstances(int maxResults, long time, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                query = this.getSession().getNamedQuery("getMostRecentProcessInstancesOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getMostRecentProcessInstancesOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getMostRecentProcessInstancesOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                query = this.getSession().getNamedQuery("getMostRecentProcessInstancesOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                query = this.getSession().getNamedQuery("getMostRecentProcessInstancesOrderByInstanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                query = this.getSession().getNamedQuery("getMostRecentProcessInstancesOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getMostRecentProcessInstancesOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getMostRecentProcessInstancesOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                query = this.getSession().getNamedQuery("getMostRecentProcessInstancesOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                query = this.getSession().getNamedQuery("getMostRecentProcessInstancesOrderByInstanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getMostRecentProcessInstances");
            }
        }
        query.setFirstResult(0);
        query.setLong("time", time);
        query.setMaxResults(maxResults);
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentParentProcessInstances(int maxResults, long time) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getMostRecentParentProcessInstances");
        query.setFirstResult(0);
        query.setLong("time", time);
        query.setMaxResults(maxResults);
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentParentProcessInstances(int maxResults, long time, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                query = this.getSession().getNamedQuery("getMostRecentParentProcessInstancesOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getMostRecentParentProcessInstancesOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getMostRecentParentProcessInstancesOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                query = this.getSession().getNamedQuery("getMostRecentParentProcessInstancesOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                query = this.getSession().getNamedQuery("getMostRecentParentProcessInstancesOrderByInstanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                query = this.getSession().getNamedQuery("getMostRecentParentProcessInstancesOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getMostRecentParentProcessInstancesOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getMostRecentParentProcessInstancesOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                query = this.getSession().getNamedQuery("getMostRecentParentProcessInstancesOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                query = this.getSession().getNamedQuery("getMostRecentParentProcessInstancesOrderByInstanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getMostRecentParentProcessInstances");
            }
        }
        query.setFirstResult(0);
        query.setLong("time", time);
        query.setMaxResults(maxResults);
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentMatchingProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs, int maxResults, long time) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getMostRecentMatchingProcessInstances");
        query.setFirstResult(0);
        query.setLong("time", time);
        query.setMaxResults(maxResults);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID uuid : instanceUUIDs) {
            uuids.add(uuid.toString());
        }
        ArrayList<InternalProcessInstance> allInstances = new ArrayList<InternalProcessInstance>();
        allInstances.addAll(this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids));
        Collections.sort(allInstances, new ProcessInstanceLastUpdateComparator());
        List<InternalProcessInstance> results = Misc.subList(InternalProcessInstance.class, allInstances, 0, maxResults);
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentMatchingProcessInstances(Set<ProcessInstanceUUID> instanceUUIDs, int maxResults, long time, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        Comparator<InternalProcessInstance> comparator = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                comparator = new ProcessInstanceLastUpdateComparatorAsc();
                query = this.getSession().getNamedQuery("getMostRecentMatchingProcessInstancesOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                comparator = new ProcessInstanceStartedDateComparatorAsc();
                query = this.getSession().getNamedQuery("getMostRecentMatchingProcessInstancesOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                comparator = new ProcessInstanceEndedDateComparatorAsc();
                query = this.getSession().getNamedQuery("getMostRecentMatchingProcessInstancesOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                comparator = new ProcessInstanceNbComparatorAsc();
                query = this.getSession().getNamedQuery("getMostRecentMatchingProcessInstancesOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                comparator = new ProcessInstanceUUIDComparatorAsc();
                query = this.getSession().getNamedQuery("getMostRecentMatchingProcessInstancesOrderByInstanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                comparator = new ProcessInstanceLastUpdateComparator();
                query = this.getSession().getNamedQuery("getMostRecentMatchingProcessInstancesOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                comparator = new ProcessInstanceStartedDateComparatorDesc();
                query = this.getSession().getNamedQuery("getMostRecentMatchingProcessInstancesOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                comparator = new ProcessInstanceEndedDateComparatorDesc();
                query = this.getSession().getNamedQuery("getMostRecentMatchingProcessInstancesOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                comparator = new ProcessInstanceNbComparatorDesc();
                query = this.getSession().getNamedQuery("getMostRecentMatchingProcessInstancesOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                comparator = new ProcessInstanceUUIDComparatorDesc();
                query = this.getSession().getNamedQuery("getMostRecentMatchingProcessInstancesOrderByInstanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                comparator = new ProcessInstanceLastUpdateComparator();
                query = this.getSession().getNamedQuery("getMostRecentMatchingProcessInstances");
            }
        }
        query.setFirstResult(0);
        query.setLong("time", time);
        query.setMaxResults(maxResults);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID uuid : instanceUUIDs) {
            uuids.add(uuid.toString());
        }
        ArrayList<InternalProcessInstance> allInstances = new ArrayList<InternalProcessInstance>();
        allInstances.addAll(this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids));
        Collections.sort(allInstances, comparator);
        List<InternalProcessInstance> results = Misc.subList(InternalProcessInstance.class, allInstances, 0, maxResults);
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentProcessesProcessInstances(Collection<ProcessDefinitionUUID> definitionUUIDs, int maxResults, long time, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        Comparator<InternalProcessInstance> comparator = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                comparator = new ProcessInstanceLastUpdateComparatorAsc();
                query = this.getSession().getNamedQuery("getMostRecentProcessesProcessInstancesOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                comparator = new ProcessInstanceStartedDateComparatorAsc();
                query = this.getSession().getNamedQuery("getMostRecentProcessesProcessInstancesOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                comparator = new ProcessInstanceEndedDateComparatorAsc();
                query = this.getSession().getNamedQuery("getMostRecentProcessesProcessInstancesOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                comparator = new ProcessInstanceNbComparatorAsc();
                query = this.getSession().getNamedQuery("getMostRecentProcessesProcessInstancesOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                comparator = new ProcessInstanceUUIDComparatorAsc();
                query = this.getSession().getNamedQuery("getMostRecentProcessesProcessInstancesOrderByInstanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                comparator = new ProcessInstanceLastUpdateComparator();
                query = this.getSession().getNamedQuery("getMostRecentProcessesProcessInstancesOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                comparator = new ProcessInstanceStartedDateComparatorDesc();
                query = this.getSession().getNamedQuery("getMostRecentProcessesProcessInstancesOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                comparator = new ProcessInstanceEndedDateComparatorDesc();
                query = this.getSession().getNamedQuery("getMostRecentProcessesProcessInstancesOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                comparator = new ProcessInstanceNbComparatorDesc();
                query = this.getSession().getNamedQuery("getMostRecentProcessesProcessInstancesOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                comparator = new ProcessInstanceUUIDComparatorDesc();
                query = this.getSession().getNamedQuery("getMostRecentProcessesProcessInstancesOrderByInstanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                comparator = new ProcessInstanceLastUpdateComparator();
                query = this.getSession().getNamedQuery("getMostRecentProcessesProcessInstances");
            }
        }
        query.setFirstResult(0);
        query.setLong("time", time);
        query.setMaxResults(maxResults);
        HashSet<String> uuids = new HashSet<String>();
        if (definitionUUIDs != null) {
            for (ProcessDefinitionUUID uuid : definitionUUIDs) {
                uuids.add(uuid.toString());
            }
        }
        ArrayList<InternalProcessInstance> allInstances = new ArrayList<InternalProcessInstance>();
        allInstances.addAll(this.executeSplittedQuery(InternalProcessInstance.class, query, "processUUIDs", uuids));
        Collections.sort(allInstances, comparator);
        List<InternalProcessInstance> results = Misc.subList(InternalProcessInstance.class, allInstances, 0, maxResults);
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentProcessesProcessInstances(Collection<ProcessDefinitionUUID> definitionUUIDs, int maxResults, long time) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getMostRecentProcessesProcessInstances");
        query.setFirstResult(0);
        query.setLong("time", time);
        query.setMaxResults(maxResults);
        HashSet<String> uuids = new HashSet<String>();
        if (definitionUUIDs != null) {
            for (ProcessDefinitionUUID uuid : definitionUUIDs) {
                uuids.add(uuid.toString());
            }
        }
        ArrayList<InternalProcessInstance> allInstances = new ArrayList<InternalProcessInstance>();
        allInstances.addAll(this.executeSplittedQuery(InternalProcessInstance.class, query, "processUUIDs", uuids));
        Collections.sort(allInstances, new ProcessInstanceLastUpdateComparator());
        List<InternalProcessInstance> results = Misc.subList(InternalProcessInstance.class, allInstances, 0, maxResults);
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstances(ProcessDefinitionUUID definitionUUID, int fromIndex, int pageSize) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentInstancesOfProcessDefinition");
        query.setString("definitionUUID", definitionUUID.getValue());
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        return this.formatList(query.list());
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstances(int fromIndex, int pageSize) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentInstances");
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        return this.formatList(query.list());
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstances(int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                query = this.getSession().getNamedQuery("getParentInstancesOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentInstancesOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentInstancesOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                query = this.getSession().getNamedQuery("getParentInstancesOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                query = this.getSession().getNamedQuery("getParentInstancesOrderByInstanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                query = this.getSession().getNamedQuery("getParentInstancesOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentInstancesOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentInstancesOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                query = this.getSession().getNamedQuery("getParentInstancesOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                query = this.getSession().getNamedQuery("getParentInstancesOrderByInstanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getParentInstances");
            }
        }
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        return this.formatList(query.list());
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstances(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                query = this.getSession().getNamedQuery("getParentInstancesFromProcessUUIDsOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentInstancesFromProcessUUIDsOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentInstancesFromProcessUUIDsOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                query = this.getSession().getNamedQuery("getParentInstancesFromProcessUUIDsOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                query = this.getSession().getNamedQuery("getParentInstancesFromProcessUUIDsOrderByInstanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                query = this.getSession().getNamedQuery("getParentInstancesFromProcessUUIDsOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentInstancesFromProcessUUIDsOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentInstancesFromProcessUUIDsOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                query = this.getSession().getNamedQuery("getParentInstancesFromProcessUUIDsOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                query = this.getSession().getNamedQuery("getParentInstancesFromProcessUUIDsOrderByInstanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getParentInstancesFromProcessUUIDsOrderByLastUpdateDesc");
            }
        }
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : processUUIDs) {
            uuids.add(uuid.toString());
        }
        List<InternalProcessInstance> results = this.executeSplittedQueryList(InternalProcessInstance.class, query, "processUUIDs", uuids);
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesExcept(Set<ProcessDefinitionUUID> exceptions, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                query = this.getSession().getNamedQuery("getParentInstancesExceptOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentInstancesExceptOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentInstancesExceptOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                query = this.getSession().getNamedQuery("getParentInstancesExceptOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                query = this.getSession().getNamedQuery("getParentInstancesExceptOrderByInstanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                query = this.getSession().getNamedQuery("getParentInstancesExceptOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentInstancesExceptOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentInstancesExceptOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                query = this.getSession().getNamedQuery("getParentInstancesExceptOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                query = this.getSession().getNamedQuery("getParentInstancesExceptOrderByInstanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getParentInstancesExceptOrderByLastUpdateDesc");
            }
        }
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : exceptions) {
            uuids.add(uuid.toString());
        }
        List<InternalProcessInstance> results = this.executeSplittedQueryList(InternalProcessInstance.class, query, "processUUIDs", uuids);
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessDefinition> getProcesses(int fromIndex, int pageSize) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllProcesses");
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        return this.formatList(query.list());
    }

    @Override
    public List<InternalProcessDefinition> getProcesses(int fromIndex, int pageSize, ProcessDefinitionCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case NAME_ASC: {
                query = this.getSession().getNamedQuery("getAllProcessesOrderByNameAsc");
                break;
            }
            case LABEL_ASC: {
                query = this.getSession().getNamedQuery("getAllProcessesOrderByLabelAsc");
                break;
            }
            case VERSION_ASC: {
                query = this.getSession().getNamedQuery("getAllProcessesOrderByVersionAsc");
                break;
            }
            case STATE_ASC: {
                query = this.getSession().getNamedQuery("getAllProcessesOrderByStateAsc");
                break;
            }
            case NAME_DESC: {
                query = this.getSession().getNamedQuery("getAllProcessesOrderByNameDesc");
                break;
            }
            case LABEL_DESC: {
                query = this.getSession().getNamedQuery("getAllProcessesOrderByLabelDesc");
                break;
            }
            case VERSION_DESC: {
                query = this.getSession().getNamedQuery("getAllProcessesOrderByVersionDesc");
                break;
            }
            case STATE_DESC: {
                query = this.getSession().getNamedQuery("getAllProcessesOrderByStateDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getAllProcesses");
            }
        }
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        return this.formatList(query.list());
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs, int fromIndex, int pageSize) {
        org.hibernate.Query query = this.getSession().getNamedQuery("findMatchingProcessInstances");
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        HashSet<String> uuids = new HashSet<String>();
        if (instanceUUIDs != null) {
            for (ProcessInstanceUUID uuid : instanceUUIDs) {
                uuids.add(uuid.toString());
            }
        }
        ArrayList<InternalProcessInstance> allInstances = new ArrayList<InternalProcessInstance>();
        allInstances.addAll(this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids));
        Collections.sort(allInstances, new ProcessInstanceLastUpdateComparator());
        List<InternalProcessInstance> results = Misc.subList(InternalProcessInstance.class, allInstances, 0, pageSize);
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getProcessInstancesWithInstanceUUIDs(Set<ProcessInstanceUUID> instanceUUIDs, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        Comparator<InternalProcessInstance> comparator = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                comparator = new ProcessInstanceLastUpdateComparatorAsc();
                query = this.getSession().getNamedQuery("findMatchingProcessInstancesOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                comparator = new ProcessInstanceStartedDateComparatorAsc();
                query = this.getSession().getNamedQuery("findMatchingProcessInstancesOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                comparator = new ProcessInstanceEndedDateComparatorAsc();
                query = this.getSession().getNamedQuery("findMatchingProcessInstancesOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                comparator = new ProcessInstanceNbComparatorAsc();
                query = this.getSession().getNamedQuery("findMatchingProcessInstancesOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                comparator = new ProcessInstanceUUIDComparatorAsc();
                query = this.getSession().getNamedQuery("findMatchingProcessInstancesOrderByIntanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                comparator = new ProcessInstanceLastUpdateComparator();
                query = this.getSession().getNamedQuery("findMatchingProcessInstancesOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                comparator = new ProcessInstanceStartedDateComparatorDesc();
                query = this.getSession().getNamedQuery("findMatchingProcessInstancesOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                comparator = new ProcessInstanceEndedDateComparatorDesc();
                query = this.getSession().getNamedQuery("findMatchingProcessInstancesOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                comparator = new ProcessInstanceNbComparatorDesc();
                query = this.getSession().getNamedQuery("findMatchingProcessInstancesOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                comparator = new ProcessInstanceUUIDComparatorDesc();
                query = this.getSession().getNamedQuery("findMatchingProcessInstancesOrderByIntanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                comparator = new ProcessInstanceLastUpdateComparator();
                query = this.getSession().getNamedQuery("findMatchingProcessInstances");
            }
        }
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        HashSet<String> uuids = new HashSet<String>();
        if (instanceUUIDs != null) {
            for (ProcessInstanceUUID uuid : instanceUUIDs) {
                uuids.add(uuid.toString());
            }
        }
        ArrayList<InternalProcessInstance> allInstances = new ArrayList<InternalProcessInstance>();
        allInstances.addAll(this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids));
        Collections.sort(allInstances, comparator);
        List<InternalProcessInstance> results = Misc.subList(InternalProcessInstance.class, allInstances, 0, pageSize);
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<ProcessInstanceUUID> getLabelsCaseUUIDs(String ownerName, Set<String> labelNames, int fromIndex, int pageSize) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getLabelsCaseUUIDs");
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        query.setString("ownerName", ownerName);
        query.setParameterList("labelNames", labelNames);
        return query.list();
    }

    @Override
    public Set<InternalProcessInstance> getParentInstances() {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentInstances");
        List results = query.list();
        if (results != null) {
            processInsts.addAll(results);
        }
        return processInsts;
    }

    @Override
    public Set<ProcessInstanceUUID> getParentInstancesUUIDs() {
        HashSet<ProcessInstanceUUID> processInsts = new HashSet<ProcessInstanceUUID>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentInstancesUUIDs");
        List results = query.list();
        if (results != null) {
            processInsts.addAll(results);
        }
        return processInsts;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("findMatchingProcessInstances");
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID uuid : instanceUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids);
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithTaskState(Collection<ActivityState> activityStates) {
        org.hibernate.Query getActivitiesQuery = this.getSession().getNamedQuery("findActivityInstancesWithTaskState");
        getActivitiesQuery.setParameterList("activityStates", activityStates, ACTIVITY_STATE_USER_TYPE);
        List uuids = getActivitiesQuery.list();
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        if (uuids.isEmpty()) {
            return processInsts;
        }
        org.hibernate.Query query = this.getSession().getNamedQuery("findMatchingProcessInstances");
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids);
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithInstanceStates(Collection<InstanceState> instanceStates) {
        org.hibernate.Query getProcessInstancesQuery = this.getSession().getNamedQuery("findProcessInstancesWithInstanceStates");
        getProcessInstancesQuery.setParameterList("instanceStates", instanceStates, DEFINITION_STATE_USER_TYPE);
        List uuids = getProcessInstancesQuery.list();
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        if (uuids.isEmpty()) {
            return processInsts;
        }
        org.hibernate.Query query = this.getSession().getNamedQuery("findMatchingProcessInstances");
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids);
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(ProcessDefinitionUUID processUUID) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("findProcessInstances");
        query.setString("processUUID", processUUID.toString());
        List results = query.list();
        if (results != null) {
            processInsts.addAll(results);
        }
        return processInsts;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(ProcessDefinitionUUID processUUID, InstanceState instanceState) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("findProcessInstancesWithState");
        query.setString("processUUID", processUUID.toString());
        query.setParameter("state", (Object)instanceState, INSTANCE_STATE_USER_TYPE);
        List results = query.list();
        if (results != null) {
            processInsts.addAll(results);
        }
        return processInsts;
    }

    @Override
    public TaskInstance getTaskInstance(ActivityInstanceUUID taskUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("findTaskInstance");
        query.setString("taskUUID", taskUUID.toString());
        query.setMaxResults(1);
        return (TaskInstance)query.uniqueResult();
    }

    @Override
    public Set<TaskInstance> getTaskInstances(ProcessInstanceUUID instanceUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("findTaskInstances");
        query.setString("instanceUUID", instanceUUID.toString());
        HashSet<TaskInstance> taskInstances = new HashSet<TaskInstance>();
        List results = query.list();
        if (results != null) {
            taskInstances.addAll(results);
        }
        return taskInstances;
    }

    @Override
    public Set<TaskInstance> getTaskInstances(ProcessInstanceUUID instanceUUID, Set<String> taskNames) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getTasksFromNames");
        query.setString("instanceUUID", instanceUUID.getValue());
        query.setParameterList("taskNames", taskNames);
        HashSet<TaskInstance> taskInstances = new HashSet<TaskInstance>();
        List results = query.list();
        if (results != null) {
            taskInstances.addAll(results);
        }
        return taskInstances;
    }

    private Set<InternalProcessDefinition> getProcessSet(org.hibernate.Query query) {
        List results = query.list();
        if (results != null) {
            return new HashSet<InternalProcessDefinition>(results);
        }
        return null;
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllProcesses");
        return this.getProcessSet(query);
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(String processId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProcesses2");
        query.setString("processId", processId);
        return this.getProcessSet(query);
    }

    @Override
    public InternalProcessDefinition getProcess(ProcessDefinitionUUID processUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProcess");
        query.setString("processUUID", processUUID.toString());
        query.setMaxResults(1);
        return (InternalProcessDefinition)query.uniqueResult();
    }

    @Override
    public InternalProcessDefinition getProcess(String processId, String version) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProcessFromIdAndVersion");
        query.setString("processId", processId);
        query.setString("version", version);
        return (InternalProcessDefinition)query.uniqueResult();
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(ProcessDefinition.ProcessState processState) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProcessesFromState");
        query.setParameter("state", (Object)processState, DEFINITION_STATE_USER_TYPE);
        return this.getProcessSet(query);
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(String processId, ProcessDefinition.ProcessState processState) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProcessesFromProcessIdAndState");
        query.setParameter("state", (Object)processState, DEFINITION_STATE_USER_TYPE);
        query.setString("processId", processId);
        return this.getProcessSet(query);
    }

    @Override
    public String getLastProcessVersion(String processName) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getLastProcessVersion");
        query.setString("name", processName);
        query.setMaxResults(1);
        return (String)query.uniqueResult();
    }

    @Override
    public InternalProcessDefinition getLastProcess(String processId, ProcessDefinition.ProcessState processState) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getLastProcessFromProcessIdAndState");
        query.setParameter("state", (Object)processState, DEFINITION_STATE_USER_TYPE);
        query.setString("processId", processId);
        query.setMaxResults(1);
        return (InternalProcessDefinition)query.uniqueResult();
    }

    @Override
    public InternalActivityInstance getActivityInstance(ProcessInstanceUUID instanceUUID, String activityId, String iterationId, String activityInstanceId, String loopId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstance");
        query.setString("instanceUUID", instanceUUID.toString());
        query.setString("activityId", activityId);
        query.setString("iterationId", iterationId);
        query.setString("activityInstanceId", activityInstanceId);
        query.setString("loopId", loopId);
        return (InternalActivityInstance)query.uniqueResult();
    }

    @Override
    public InternalActivityInstance getActivityInstance(ActivityInstanceUUID activityInstanceUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstanceFromUUID");
        query.setString("activityUUID", activityInstanceUUID.toString());
        return (InternalActivityInstance)query.uniqueResult();
    }

    @Override
    public ActivityState getActivityInstanceState(ActivityInstanceUUID activityInstanceUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstanceStateFromUUID");
        query.setString("activityUUID", activityInstanceUUID.toString());
        return (ActivityState)((Object)query.uniqueResult());
    }

    @Override
    public InternalActivityDefinition getActivityDefinition(ActivityDefinitionUUID activityDefinitionUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityDefinition");
        query.setString("activityUUID", activityDefinitionUUID.toString());
        query.setMaxResults(1);
        return (InternalActivityDefinition)query.uniqueResult();
    }

    @Override
    public Execution getExecutionWithEventUUID(String eventUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getExecutionWithEventUUID");
        query.setString("eventUUID", eventUUID);
        return (Execution)query.uniqueResult();
    }

    @Override
    public Set<Execution> getExecutions(ProcessInstanceUUID instanceUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getInstanceExecutions");
        query.setString("instanceUUID", instanceUUID.getValue());
        HashSet<Execution> executions = new HashSet<Execution>();
        CollectionUtils.addAll(executions, (Iterator)query.iterate());
        return executions;
    }

    @Override
    public Execution getExecutionPointingOnNode(ActivityInstanceUUID activityUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("findInstanceExecutionPointingOnNode");
        query.setString("activityUUID", activityUUID.toString());
        return (Execution)query.uniqueResult();
    }

    @Override
    public MetaDataImpl getMetaData(String key) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getMetaData");
        query.setString("key", key);
        return (MetaDataImpl)query.uniqueResult();
    }

    @Override
    public Set<ProcessInstanceUUID> getAllCases() {
        HashSet<ProcessInstanceUUID> result = new HashSet<ProcessInstanceUUID>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllCases");
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<CaseImpl> getCases(Set<ProcessInstanceUUID> caseUUIDs) {
        HashSet<String> uuids = new HashSet<String>();
        if (caseUUIDs != null) {
            for (ProcessInstanceUUID processInstanceUUID : caseUUIDs) {
                uuids.add(processInstanceUUID.getValue());
            }
        }
        org.hibernate.Query query = this.getSession().getNamedQuery("getMatchingCases");
        return this.executeSplittedQuery(CaseImpl.class, query, "uuids", uuids);
    }

    @Override
    public List<LabelImpl> getUserCustomLabels(String ownerName) {
        ArrayList<LabelImpl> result = new ArrayList<LabelImpl>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getUserCustomLabels");
        query.setString("ownerName", ownerName);
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public List<LabelImpl> getSystemLabels(String ownerName) {
        ArrayList<LabelImpl> result = new ArrayList<LabelImpl>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getSystemLabels");
        query.setString("ownerName", ownerName);
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public LabelImpl getLabel(String ownerName, String labelName) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getLabelByID");
        query.setString("ownerName", ownerName);
        query.setString("labelName", labelName);
        query.setMaxResults(1);
        LabelImpl theResult = (LabelImpl)query.uniqueResult();
        return theResult;
    }

    @Override
    public Set<LabelImpl> getLabels(String ownerName) {
        HashSet<LabelImpl> result = new HashSet<LabelImpl>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllLabels");
        query.setString("ownerName", ownerName);
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<LabelImpl> getCaseLabels(String ownerName, ProcessInstanceUUID case_) {
        org.hibernate.Query getUserCases = this.getSession().getNamedQuery("getUserCases");
        getUserCases.setString("ownerName", ownerName);
        getUserCases.setString("caseId", case_.getValue());
        List caseLabelsNames = getUserCases.list();
        Set<LabelImpl> result = new HashSet<LabelImpl>();
        if (!caseLabelsNames.isEmpty()) {
            org.hibernate.Query query = this.getSession().getNamedQuery("getLabels");
            query.setString("ownerName", ownerName);
            result = this.executeSplittedQuery(LabelImpl.class, query, "labelNames", caseLabelsNames);
        }
        return result;
    }

    private <T> Set<T> executeSplittedQuery(Class<T> clazz, org.hibernate.Query query, String parameterName, Collection<? extends Object> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet result = new HashSet();
        if (values.size() <= 500) {
            query.setParameterList(parameterName, values);
            CollectionUtils.addAll(result, (Iterator)query.iterate());
            return result;
        }
        List<Collection<Object>> newValues = Misc.splitCollection(values, 500);
        for (Collection<Object> set : newValues) {
            query.setParameterList(parameterName, set);
            CollectionUtils.addAll(result, (Iterator)query.iterate());
        }
        return result;
    }

    private <T> List<T> executeSplittedQueryList(Class<T> clazz, org.hibernate.Query query, String parameterName, Collection<? extends Object> values) {
        return this.executeSplittedQueryList(clazz, query, parameterName, values, 500);
    }

    private <T> List<T> executeSplittedQueryList(Class<T> clazz, org.hibernate.Query query, String parameterName, Collection<? extends Object> values, int size) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        if (values.size() <= size) {
            query.setParameterList(parameterName, values);
            return query.list();
        }
        List<Collection<Object>> newValues = Misc.splitCollection(values, size);
        for (Collection<Object> set : newValues) {
            query.setParameterList(parameterName, set);
            CollectionUtils.addAll(result, (Iterator)query.iterate());
        }
        return result;
    }

    @Override
    public Set<CaseImpl> getCases(String ownerName, String labelName) {
        HashSet<CaseImpl> result = new HashSet<CaseImpl>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getLabelCases");
        query.setString("ownerName", ownerName);
        query.setString("labelName", labelName);
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<CaseImpl> getCases(ProcessInstanceUUID case_) {
        HashSet<CaseImpl> result = new HashSet<CaseImpl>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getCases");
        query.setString("caseId", case_.getValue());
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public CaseImpl getCase(ProcessInstanceUUID caseUUID, String ownerName, String labelName) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getCase");
        query.setString("caseUUID", caseUUID.getValue());
        query.setString("ownerName", ownerName);
        query.setString("labelName", labelName);
        return (CaseImpl)query.uniqueResult();
    }

    @Override
    public Set<LabelImpl> getLabels(String ownerName, Set<String> labelsName) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getLabels");
        query.setString("ownerName", ownerName);
        return this.executeSplittedQuery(LabelImpl.class, query, "labelNames", labelsName);
    }

    @Override
    public Set<LabelImpl> getLabels(Set<String> labelsName) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getLabelsWithName");
        return this.executeSplittedQuery(LabelImpl.class, query, "labelNames", labelsName);
    }

    @Override
    public Set<LabelImpl> getLabelsByNameExcept(Set<String> labelNames) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getLabelsByNameExcept");
        return this.executeSplittedQuery(LabelImpl.class, query, "labelNames", labelNames);
    }

    @Override
    public int getCasesNumberWithTwoLabels(String ownerName, String label1Name, String label2Name) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getCasesNumberWithTwoLabels");
        query.setString("label1", CaseImpl.buildLabel(ownerName, label1Name));
        query.setString("label2", CaseImpl.buildLabel(ownerName, label2Name));
        query.setReadOnly(true);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getCasesNumber(String ownerName, String labelName) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getCasesNumber");
        query.setString("ownerName", ownerName);
        query.setString("label", labelName);
        query.setReadOnly(true);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Set<CaseImpl> getCasesWithTwoLabels(String ownerName, String label1Name, String label2Name, int limit) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getCasesWithTwoLabelsWithLimit");
        query.setString("label1", CaseImpl.buildLabel(ownerName, label1Name));
        query.setString("label2", CaseImpl.buildLabel(ownerName, label2Name));
        query.setReadOnly(true);
        query.setMaxResults(limit);
        List results = query.list();
        if (results != null) {
            return new HashSet<CaseImpl>(results);
        }
        return new HashSet<CaseImpl>();
    }

    @Override
    public Set<CaseImpl> getCases(String ownerName, String labelName, int limit) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getLabelCases");
        query.setString("ownerName", ownerName);
        query.setString("labelName", labelName);
        query.setMaxResults(limit);
        List results = query.list();
        if (results != null) {
            return new HashSet<CaseImpl>(results);
        }
        return new HashSet<CaseImpl>();
    }

    @Override
    public Set<ProcessInstanceUUID> getCases(String ownerName, Set<String> theLabelsName) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getLabelsCases");
        query.setString("ownerName", ownerName);
        return this.executeSplittedQuery(ProcessInstanceUUID.class, query, "labelNames", theLabelsName);
    }

    @Override
    public void deleteAllCases() {
        Session session = this.getSession();
        org.hibernate.Query query = session.getNamedQuery("getAllWebCases");
        for (Object webCase : query.list()) {
            session.delete(webCase);
        }
    }

    @Override
    public void deleteCases(Set<ProcessInstanceUUID> webCases) {
        Session session = this.getSession();
        org.hibernate.Query query = session.getNamedQuery("getMatchingCases");
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID processInstanceUUID : webCases) {
            uuids.add(processInstanceUUID.getValue());
        }
        for (CaseImpl caseImpl : this.executeSplittedQuery(CaseImpl.class, query, "uuids", uuids)) {
            session.delete((Object)caseImpl);
        }
    }

    @Override
    public Set<ProcessInstanceUUID> getCasesUUIDs(String ownerName, String labelName, Set<ProcessInstanceUUID> cases) {
        HashSet<String> uuids = new HashSet<String>();
        if (cases != null) {
            for (ProcessInstanceUUID processInstanceUUID : cases) {
                uuids.add(processInstanceUUID.getValue());
            }
        }
        org.hibernate.Query query = this.getSession().getNamedQuery("getLabelCasesUUIDsSublist");
        query.setString("ownerName", ownerName);
        query.setString("labelName", labelName);
        return this.executeSplittedQuery(ProcessInstanceUUID.class, query, "caseUUIDs", uuids);
    }

    @Override
    public Set<ProcessInstanceUUID> getLabelCases(String labelName, Set<ProcessInstanceUUID> caseUUIDs) {
        if (caseUUIDs == null || caseUUIDs.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID processInstanceUUID : caseUUIDs) {
            uuids.add(processInstanceUUID.getValue());
        }
        org.hibernate.Query query = this.getSession().getNamedQuery("getLabelNameCases");
        query.setString("labelName", labelName);
        return this.executeSplittedQuery(ProcessInstanceUUID.class, query, "uuids", uuids);
    }

    @Override
    public Set<CaseImpl> getLabelCases(String ownerName, Set<String> labelsNames, Set<ProcessInstanceUUID> caseUUIDs) {
        if (caseUUIDs == null || caseUUIDs.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID processInstanceUUID : caseUUIDs) {
            uuids.add(processInstanceUUID.getValue());
        }
        org.hibernate.Query query = this.getSession().getNamedQuery("getLabelsNameCases");
        query.setParameterList("labelsNames", labelsNames);
        query.setString("ownerName", ownerName);
        return this.executeSplittedQuery(CaseImpl.class, query, "uuids", uuids);
    }

    @Override
    public Set<CaseImpl> getCases(String ownerName, String labelName, Set<ProcessInstanceUUID> caseList) {
        HashSet<String> uuids = new HashSet<String>();
        if (caseList != null) {
            for (ProcessInstanceUUID processInstanceUUID : caseList) {
                uuids.add(processInstanceUUID.getValue());
            }
        }
        org.hibernate.Query query = this.getSession().getNamedQuery("getLabelCasesSublist");
        query.setString("ownerName", ownerName);
        query.setString("labelName", labelName);
        return this.executeSplittedQuery(CaseImpl.class, query, "caseUUIDs", uuids);
    }

    @Override
    public List<Integer> getNumberOfExecutingCasesPerDay(Date since, Date to) {
        ArrayList<Integer> executingCases = new ArrayList<Integer>();
        while (since.before(to) || since.equals(to)) {
            Date nextDayBegining = DateUtil.getBeginningOfTheDay(DateUtil.getNextDay(since));
            org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfExecutingCases");
            query.setLong("date", nextDayBegining.getTime());
            executingCases.add(((Long)query.uniqueResult()).intValue());
            since = DateUtil.getNextDay(since);
        }
        return executingCases;
    }

    @Override
    public List<Integer> getNumberOfFinishedCasesPerDay(Date since, Date to) {
        ArrayList<Integer> finishedCases = new ArrayList<Integer>();
        while (since.before(to) || since.equals(to)) {
            Date beginningOfTheDay = DateUtil.getBeginningOfTheDay(since);
            Date nextBeginningOfTheDay = DateUtil.getBeginningOfTheDay(DateUtil.getNextDay(since));
            org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfFinishedCases");
            query.setLong("beginningOfTheDay", beginningOfTheDay.getTime());
            query.setLong("nextBeginningOfTheDay", nextBeginningOfTheDay.getTime());
            finishedCases.add(((Long)query.uniqueResult()).intValue());
            since = DateUtil.getNextDay(since);
        }
        return finishedCases;
    }

    @Override
    public List<Integer> getNumberOfOpenStepsPerDay(Date since, Date to) {
        ArrayList<Integer> finishedCases = new ArrayList<Integer>();
        while (since.before(to) || since.equals(to)) {
            Date nextDayBegining = DateUtil.getBeginningOfTheDay(DateUtil.getNextDay(since));
            org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfOpenSteps2");
            query.setLong("date", nextDayBegining.getTime());
            finishedCases.add(((Long)query.uniqueResult()).intValue());
            since = DateUtil.getNextDay(since);
        }
        return finishedCases;
    }

    @Override
    public int getNumberOfOpenSteps() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfOpenSteps");
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfOverdueSteps(Date currentDate) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfOverdueSteps");
        query.setLong("currentDate", currentDate.getTime());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfStepsAtRisk(Date currentDate, Date atRisk) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfStepsAtRisk");
        query.setLong("atRisk", atRisk.getTime());
        query.setLong("currentDate", currentDate.getTime());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfUserOpenSteps(String userId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfUserOpenSteps");
        query.setString("userId", userId);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfUserOverdueSteps(String userId, Date currentDate) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfUserOverdueSteps");
        query.setString("userId", userId);
        query.setLong("currentDate", currentDate.getTime());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfUserStepsAtRisk(String userId, Date currentDate, Date atRisk) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfUserStepsAtRisk");
        query.setString("userId", userId);
        query.setLong("atRisk", atRisk.getTime());
        query.setLong("currentDate", currentDate.getTime());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfFinishedSteps(int priority, Date since) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfFinishedSteps");
        query.setInteger("priority", priority);
        query.setLong("since", since.getTime());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfOpenSteps(int priority) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfPriorityOpenSteps");
        query.setInteger("priority", priority);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfUserFinishedSteps(String userId, int priority, Date since) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfUserFinishedSteps");
        query.setInteger("priority", priority);
        query.setLong("since", since.getTime());
        query.setString("userId", userId);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfUserOpenSteps(String userId, int priority) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfPriorityUserOpenSteps");
        query.setInteger("priority", priority);
        query.setString("userId", userId);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Set<IncomingEventInstance> getIncomingEvents(ProcessInstanceUUID instanceUUID) {
        HashSet<IncomingEventInstance> result = new HashSet<IncomingEventInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getInstanceIncomingEvents");
        query.setString("instanceUUID", instanceUUID.getValue());
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public IncomingEventInstance getIncomingEvent(ProcessInstanceUUID instanceUUID, String name) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getUniqueInstanceIncomingEvent");
        query.setString("instanceUUID", instanceUUID.getValue());
        query.setString("eventName", name);
        return (IncomingEventInstance)query.uniqueResult();
    }

    @Override
    public Set<IncomingEventInstance> getIncomingEvents(ActivityDefinitionUUID activityUUID) {
        HashSet<IncomingEventInstance> result = new HashSet<IncomingEventInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityDefinitionIncomingEvents");
        query.setString("activityUUID", activityUUID.getValue());
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<IncomingEventInstance> getIncomingEvents(ActivityInstanceUUID activityUUID) {
        HashSet<IncomingEventInstance> result = new HashSet<IncomingEventInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstanceIncomingEvents");
        query.setString("activityUUID", activityUUID.getValue());
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<IncomingEventInstance> getBoundaryIncomingEvents(ActivityInstanceUUID activityUUID) {
        HashSet<IncomingEventInstance> result = new HashSet<IncomingEventInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityBoundaryIncomingEvents");
        query.setString("activityUUID", activityUUID.getValue());
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<OutgoingEventInstance> getBoundaryOutgoingEvents(ActivityInstanceUUID activityUUID) {
        HashSet<OutgoingEventInstance> result = new HashSet<OutgoingEventInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityBoundaryOutgoingEvents");
        query.setString("activityUUID", activityUUID.getValue());
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<OutgoingEventInstance> getOutgoingEvents(ProcessInstanceUUID instanceUUID) {
        HashSet<OutgoingEventInstance> result = new HashSet<OutgoingEventInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getInstanceOutgoingEvents");
        query.setString("instanceUUID", instanceUUID.getValue());
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<OutgoingEventInstance> getOutgoingEvents() {
        HashSet<OutgoingEventInstance> result = new HashSet<OutgoingEventInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getOutgoingEvents");
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<OutgoingEventInstance> getOutgoingEvents(String eventName, String toProcessName, String toActivityName, ActivityInstanceUUID activityUUID) {
        HashSet<OutgoingEventInstance> result = new HashSet<OutgoingEventInstance>();
        org.hibernate.Query query = null;
        query = this.getSession().getNamedQuery("getOutgoingEventsWithUUID");
        query.setString("processName", toProcessName);
        query.setString("activityName", toActivityName);
        query.setString("activityUUID", activityUUID == null ? null : activityUUID.getValue());
        query.setString("name", eventName);
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<IncomingEventInstance> getIncomingEvents(String eventName, String toProcessName, String toActivityName, ActivityInstanceUUID actiivtyUUID) {
        HashSet<IncomingEventInstance> result = new HashSet<IncomingEventInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getIncomingEventsWithUUID");
        query.setString("name", eventName);
        query.setString("processName", toProcessName);
        query.setString("activityName", toActivityName);
        query.setString("activityUUID", actiivtyUUID.getValue());
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<IncomingEventInstance> getSignalIncomingEvents(String signal) {
        HashSet<IncomingEventInstance> result = new HashSet<IncomingEventInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getSignalIncomingEvents");
        query.setString("eventName", signal);
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<OutgoingEventInstance> getOverdueEvents() {
        long currentTime = System.currentTimeMillis();
        org.hibernate.Query oeiQuery = this.getSession().getNamedQuery("getOverdueEvents");
        oeiQuery.setLong("current", currentTime);
        HashSet<OutgoingEventInstance> result = new HashSet<OutgoingEventInstance>();
        CollectionUtils.addAll(result, (Iterator)oeiQuery.iterate());
        return result;
    }

    @Override
    public Set<IncomingEventInstance> getIncomingEvents() {
        HashSet<IncomingEventInstance> result = new HashSet<IncomingEventInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getIncomingEvents");
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public Set<IncomingEventInstance> getActivityIncomingEvents(ActivityInstanceUUID activityUUID) {
        HashSet<IncomingEventInstance> result = new HashSet<IncomingEventInstance>();
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityIncomingEvents");
        query.setString("activityUUID", activityUUID.getValue());
        CollectionUtils.addAll(result, (Iterator)query.iterate());
        return result;
    }

    @Override
    public List<EventCouple> getMessageEventCouples() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getMessageEventCouples");
        query.setResultTransformer(Transformers.aliasToBean(EventCouple.class));
        return this.formatList(query.list());
    }

    @Override
    public IncomingEventInstance getIncomingEvent(long incomingId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getIncomingEvent");
        query.setLong("id", incomingId);
        return (IncomingEventInstance)query.uniqueResult();
    }

    @Override
    public OutgoingEventInstance getOutgoingEvent(long outgoingId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getOutgoingEvent");
        query.setLong("id", outgoingId);
        return (OutgoingEventInstance)query.uniqueResult();
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(Set<ProcessDefinitionUUID> definitionUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProcessesList");
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQuery(InternalProcessDefinition.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(Set<ProcessDefinitionUUID> definitionUUIDs, ProcessDefinition.ProcessState processState) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProcessesListByState");
        query.setParameter("state", (Object)processState);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQuery(InternalProcessDefinition.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public List<InternalProcessDefinition> getProcesses(Set<ProcessDefinitionUUID> definitionUUIDs, int fromIndex, int pageSize) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllProcessesList");
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQueryList(InternalProcessDefinition.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public List<InternalProcessDefinition> getProcesses(Set<ProcessDefinitionUUID> definitionUUIDs, int fromIndex, int pageSize, ProcessDefinitionCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case NAME_ASC: {
                query = this.getSession().getNamedQuery("getAllProcessesListOrderByNameAsc");
                break;
            }
            case LABEL_ASC: {
                query = this.getSession().getNamedQuery("getAllProcessesListOrderByLabelAsc");
                break;
            }
            case VERSION_ASC: {
                query = this.getSession().getNamedQuery("getAllProcessesListOrderByVersionAsc");
                break;
            }
            case STATE_ASC: {
                query = this.getSession().getNamedQuery("getAllProcessesListOrderByStateAsc");
                break;
            }
            case NAME_DESC: {
                query = this.getSession().getNamedQuery("getAllProcessesListOrderByNameDesc");
                break;
            }
            case LABEL_DESC: {
                query = this.getSession().getNamedQuery("getAllProcessesListOrderByLabelDesc");
                break;
            }
            case VERSION_DESC: {
                query = this.getSession().getNamedQuery("getAllProcessesListOrderByVersionDesc");
                break;
            }
            case STATE_DESC: {
                query = this.getSession().getNamedQuery("getAllProcessesListOrderByStateDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getAllProcessesList");
            }
        }
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQueryList(InternalProcessDefinition.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public InternalProcessDefinition getLastProcess(Set<ProcessDefinitionUUID> definitionUUIDs, ProcessDefinition.ProcessState processState) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getLastProcessFromProcessSetAndState");
        query.setParameter("state", (Object)processState, DEFINITION_STATE_USER_TYPE);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setMaxResults(1);
        Set<InternalProcessDefinition> result = this.executeSplittedQuery(InternalProcessDefinition.class, query, "definitionsUUIDs", uuids);
        return result.iterator().next();
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProcessInstancesFromDefinitionUUIDs");
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public Set<InternalProcessInstance> getUserInstances(String userId, Set<ProcessDefinitionUUID> definitionUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getUserInstancesFromDefinitionUUIDs");
        query.setString("userId", userId);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public List<InternalProcessInstance> getParentUserInstances(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> definitionUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentUserInstancesPageFromDefinitionUUIDs");
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        query.setString("userId", userId);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        return this.formatList(query.list());
    }

    @Override
    public List<InternalProcessInstance> getParentUserInstances(String userId, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> definitionUUIDs, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageFromDefinitionUUIDsOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageFromDefinitionUUIDsOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageFromDefinitionUUIDsOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageFromDefinitionUUIDsOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageFromDefinitionUUIDsOrderByInstanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageFromDefinitionUUIDsOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageFromDefinitionUUIDsOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageFromDefinitionUUIDsOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageFromDefinitionUUIDsOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageFromDefinitionUUIDsOrderByInstanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getParentUserInstancesPageFromDefinitionUUIDs");
            }
        }
        query.setFirstResult(startingIndex);
        query.setMaxResults(pageSize);
        query.setString("userId", userId);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        return this.formatList(query.list());
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUser(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserFromDefinitionUUIDs");
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        query.setString("userId", userId);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : visibleProcessUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        return this.formatList(query.list());
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUser(String aUserId, int aStartingIndex, int aPageSize, Set<ProcessDefinitionUUID> aVisibleProcessUUIDs, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserFromDefinitionUUIDsOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserFromDefinitionUUIDsOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserFromDefinitionUUIDsOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserFromDefinitionUUIDsOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserFromDefinitionUUIDsOrderByInstanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserFromDefinitionUUIDsOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserFromDefinitionUUIDsOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserFromDefinitionUUIDsOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserFromDefinitionUUIDsOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserFromDefinitionUUIDsOrderByInstanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserFromDefinitionUUIDs");
            }
        }
        query.setFirstResult(aStartingIndex);
        query.setMaxResults(aPageSize);
        query.setString("userId", aUserId);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : aVisibleProcessUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        return this.formatList(query.list());
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUser(String userId, int fromIndex, int pageSize) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUser");
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        query.setString("userId", userId);
        return this.formatList(query.list());
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUser(String aUserId, int aStartingIndex, int aPageSize, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserOrderByInstanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserOrderByInstanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUser");
            }
        }
        query.setFirstResult(aStartingIndex);
        query.setMaxResults(aPageSize);
        query.setString("userId", aUserId);
        return this.formatList(query.list());
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, Date currentDate, Date atRisk, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDateFromDefinitionUUIDs");
        query.setString("userId", userId);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : visibleProcessUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        query.setLong("atRisk", atRisk.getTime());
        query.setLong("currentDate", currentDate.getTime());
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return new ArrayList<InternalProcessInstance>(this.getProcessInstances((Collection<ProcessInstanceUUID>)new HashSet<ProcessInstanceUUID>(results), startingIndex, pageSize));
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, Date currentDate, Date atRisk, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> visibleProcessUUIDs, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDateFromDefinitionUUIDs");
        query.setString("userId", userId);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : visibleProcessUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        query.setLong("atRisk", atRisk.getTime());
        query.setLong("currentDate", currentDate.getTime());
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return this.getProcessInstancesWithInstanceUUIDs(new HashSet<ProcessInstanceUUID>(results), startingIndex, pageSize, pagingCriterion);
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, Date currentDate, Date atRisk, int startingIndex, int pageSize) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate");
        query.setString("userId", userId);
        query.setLong("atRisk", atRisk.getTime());
        query.setLong("currentDate", currentDate.getTime());
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return new ArrayList<InternalProcessInstance>(this.getProcessInstances((Collection<ProcessInstanceUUID>)new HashSet<ProcessInstanceUUID>(results), startingIndex, pageSize));
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, Date currentDate, Date atRisk, int startingIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate");
        query.setString("userId", userId);
        query.setLong("atRisk", atRisk.getTime());
        query.setLong("currentDate", currentDate.getTime());
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return new ArrayList<InternalProcessInstance>(this.getProcessInstancesWithInstanceUUIDs(new HashSet<ProcessInstanceUUID>(results), startingIndex, pageSize, pagingCriterion));
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithOverdueTasks(String userId, Date currentDate, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentProcessInstancesWithOverdueTasksFromDefinitionUUIDs");
        query.setString("userId", userId);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : visibleProcessUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        query.setLong("currentDate", currentDate.getTime());
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return this.getProcessInstances((Collection<ProcessInstanceUUID>)new HashSet<ProcessInstanceUUID>(results), startingIndex, pageSize);
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithOverdueTasks(String userId, Date currentDate, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> visibleProcessUUIDs, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentProcessInstancesWithOverdueTasksFromDefinitionUUIDs");
        query.setString("userId", userId);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : visibleProcessUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        query.setLong("currentDate", currentDate.getTime());
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return this.getProcessInstancesWithInstanceUUIDs(new HashSet<ProcessInstanceUUID>(results), startingIndex, pageSize, pagingCriterion);
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithOverdueTasks(String userId, Date currentDate, int startingIndex, int pageSize) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentProcessInstancesWithOverdueTasks");
        query.setString("userId", userId);
        query.setLong("currentDate", currentDate.getTime());
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return this.getProcessInstances((Collection<ProcessInstanceUUID>)new HashSet<ProcessInstanceUUID>(results), startingIndex, pageSize);
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithOverdueTasks(String userId, Date currentDate, int startingIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentProcessInstancesWithOverdueTasks");
        query.setString("userId", userId);
        query.setLong("currentDate", currentDate.getTime());
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return this.getProcessInstancesWithInstanceUUIDs(new HashSet<ProcessInstanceUUID>(results), startingIndex, pageSize, pagingCriterion);
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithInvolvedUser(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserFromDefinitionUUIDs");
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        query.setString("userId", userId);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : visibleProcessUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        return this.formatList(query.list());
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithInvolvedUser(String userId, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> visibleProcessUUIDs, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserFromDefinitionUUIDsOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserFromDefinitionUUIDsOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserFromDefinitionUUIDsOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserFromDefinitionUUIDsOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserFromDefinitionUUIDsOrderByInstanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserFromDefinitionUUIDsOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserFromDefinitionUUIDsOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserFromDefinitionUUIDsOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserFromDefinitionUUIDsOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserFromDefinitionUUIDsOrderByInstanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserFromDefinitionUUIDs");
            }
        }
        query.setFirstResult(startingIndex);
        query.setMaxResults(pageSize);
        query.setString("userId", userId);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : visibleProcessUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        return this.formatList(query.list());
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithInvolvedUser(String userId, int fromIndex, int pageSize) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUser");
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        query.setString("userId", userId);
        return this.formatList(query.list());
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstancesWithInvolvedUser(String aUserId, int aStartingIndex, int aPageSize, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserOrderByInstanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUserOrderByInstanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getParentProcessInstancesWithInvolvedUser");
            }
        }
        query.setFirstResult(aStartingIndex);
        query.setMaxResults(aPageSize);
        query.setString("userId", aUserId);
        return this.formatList(query.list());
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUser(String userId, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfParentProcessInstancesWithActiveUserFromDefinitionUUIDs");
        query.setString("userId", userId);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : visibleProcessUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUser(String userId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfParentProcessInstancesWithActiveUser");
        query.setString("userId", userId);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, Date currentDate, Date atRisk, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDateFromDefinitionUUIDs");
        query.setString("userId", userId);
        query.setLong("atRisk", atRisk.getTime());
        query.setLong("currentDate", currentDate.getTime());
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : visibleProcessUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, Date currentDate, Date atRisk) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate");
        query.setString("userId", userId);
        query.setLong("atRisk", atRisk.getTime());
        query.setLong("currentDate", currentDate.getTime());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithOverdueTasks(String userId, Date currentDate, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfParentProcessInstancesWithOverdueTasksFromDefinitionUUIDs");
        query.setString("userId", userId);
        query.setLong("currentDate", currentDate.getTime());
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : visibleProcessUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithOverdueTasks(String userId, Date currentDate) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfParentProcessInstancesWithOverdueTasks");
        query.setString("userId", userId);
        query.setLong("currentDate", currentDate.getTime());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUser(String userId, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfParentProcessInstancesWithInvolvedUserFromDefinitionUUIDs");
        query.setString("userId", userId);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : visibleProcessUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUser(String userId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfParentProcessInstancesWithInvolvedUser");
        query.setString("userId", userId);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithStartedBy(String userId, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfParentProcessInstancesWithStartedByFromDefinitionUUIDs");
        query.setString("userId", userId);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : visibleProcessUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithStartedBy(String userId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfParentProcessInstancesWithStartedBy");
        query.setString("userId", userId);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfProcessInstancesFromDefinitionUUIDs");
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfParentProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfParentProcessInstancesFromDefinitionUUIDs");
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithTaskState(Collection<ActivityState> activityStates, Set<ProcessDefinitionUUID> definitionUUIDs) {
        org.hibernate.Query getActivitiesQuery = this.getSession().getNamedQuery("findActivityInstancesWithTaskStateAndDefinitionsUUIDs");
        getActivitiesQuery.setParameterList("activityStates", activityStates, ACTIVITY_STATE_USER_TYPE);
        List uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        getActivitiesQuery.setParameterList("definitionsUUIDs", uuids);
        uuids = getActivitiesQuery.list();
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        if (uuids.isEmpty()) {
            return processInsts;
        }
        org.hibernate.Query query = this.getSession().getNamedQuery("findMatchingProcessInstances");
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids);
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithInstanceStates(Collection<InstanceState> instanceStates, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        org.hibernate.Query getProcessInstancesQuery = this.getSession().getNamedQuery("ProcessInstancesWithInstanceStatesAndDefinitionsUUIDs");
        getProcessInstancesQuery.setParameterList("instanceStates", instanceStates, INSTANCE_STATE_USER_TYPE);
        List uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : visibleProcessUUIDs) {
            uuids.add(uuid.toString());
        }
        getProcessInstancesQuery.setParameterList("definitionsUUIDs", uuids);
        uuids = getProcessInstancesQuery.list();
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        if (uuids.isEmpty()) {
            return processInsts;
        }
        org.hibernate.Query query = this.getSession().getNamedQuery("findMatchingProcessInstances");
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids);
    }

    @Override
    public TaskInstance getOneTask(String userId, ActivityState taskState, Set<ProcessDefinitionUUID> definitionUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getOneTaskOfProcessFromDefinitionUUIDs");
        query.setString("userId", userId);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        query.setParameter("state", (Object)taskState, ACTIVITY_STATE_USER_TYPE);
        query.setMaxResults(1);
        return (TaskInstance)query.uniqueResult();
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs, int fromIndex, int pageSize) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProcessInstancesWithDefinitionUUIDs");
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQueryList(InternalProcessInstance.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case LAST_UPDATE_ASC: {
                query = this.getSession().getNamedQuery("getProcessInstancesWithDefinitionUUIDsOrderByLastUpdateAsc");
                break;
            }
            case STARTED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getProcessInstancesWithDefinitionUUIDsOrderByStartedDateAsc");
                break;
            }
            case ENDED_DATE_ASC: {
                query = this.getSession().getNamedQuery("getProcessInstancesWithDefinitionUUIDsOrderByEndedDateAsc");
                break;
            }
            case INSTANCE_NUMBER_ASC: {
                query = this.getSession().getNamedQuery("getProcessInstancesWithDefinitionUUIDsOrderByInstanceNumberAsc");
                break;
            }
            case INSTANCE_UUID_ASC: {
                query = this.getSession().getNamedQuery("getProcessInstancesWithDefinitionUUIDsOrderByInstanceUUIDAsc");
                break;
            }
            case LAST_UPDATE_DESC: {
                query = this.getSession().getNamedQuery("getProcessInstancesWithDefinitionUUIDsOrderByLastUpdateDesc");
                break;
            }
            case STARTED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getProcessInstancesWithDefinitionUUIDsOrderByStartedDateDesc");
                break;
            }
            case ENDED_DATE_DESC: {
                query = this.getSession().getNamedQuery("getProcessInstancesWithDefinitionUUIDsOrderByEndedDateDesc");
                break;
            }
            case INSTANCE_NUMBER_DESC: {
                query = this.getSession().getNamedQuery("getProcessInstancesWithDefinitionUUIDsOrderByInstanceNumberDesc");
                break;
            }
            case INSTANCE_UUID_DESC: {
                query = this.getSession().getNamedQuery("getProcessInstancesWithDefinitionUUIDsOrderByInstanceUUIDDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getProcessInstancesWithDefinitionUUIDs");
            }
        }
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQueryList(InternalProcessInstance.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public Rule findRuleByName(String name) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getRuleByName");
        query.setString("name", name);
        query.setMaxResults(1);
        return (Rule)query.uniqueResult();
    }

    @Override
    public Rule getRule(String ruleUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getRule");
        query.setString("ruleUUID", ruleUUID);
        query.setMaxResults(1);
        return (Rule)query.uniqueResult();
    }

    @Override
    public List<Rule> getRules() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllRules");
        List results = query.list();
        if (results != null) {
            return results;
        }
        return Collections.emptyList();
    }

    @Override
    @Deprecated
    public Set<Rule> findRulesByNames(Set<String> rulesNames) {
        org.hibernate.Query query = this.getSession().getNamedQuery("findRulesByNames");
        query.setParameterList("names", rulesNames);
        List results = query.list();
        if (results != null) {
            return new HashSet<Rule>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public List<Rule> getRules(Collection<String> ruleUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getRules");
        query.setParameterList("uuids", ruleUUIDs);
        return this.formatList(query.list());
    }

    @Override
    public List<Rule> getAllApplicableRules(String userUUID, Collection<String> roleUUIDs, Collection<String> groupUUIDs, Collection<String> membershipUUIDs, String entityID) {
        HashSet rules = new HashSet();
        if (userUUID != null) {
            org.hibernate.Query usersQuery = this.getSession().getNamedQuery("getAllApplicableRulesForUser");
            usersQuery.setParameter("userUUID", (Object)userUUID);
            List userResults = usersQuery.list();
            if (userResults != null) {
                rules.addAll(userResults);
            }
        }
        if (entityID != null) {
            org.hibernate.Query entityQuery = this.getSession().getNamedQuery("getAllApplicableRulesForEntity");
            entityQuery.setParameter("entityID", (Object)entityID);
            List entityResults = entityQuery.list();
            if (entityResults != null) {
                rules.addAll(entityResults);
            }
        }
        if (groupUUIDs != null && !groupUUIDs.isEmpty()) {
            org.hibernate.Query groupsQuery = this.getSession().getNamedQuery("getAllApplicableRulesForGroups");
            groupsQuery.setParameterList("groupUUIDs", groupUUIDs);
            List groupsResults = groupsQuery.list();
            if (groupsResults != null) {
                rules.addAll(groupsResults);
            }
        }
        if (roleUUIDs != null && !roleUUIDs.isEmpty()) {
            org.hibernate.Query rolesQuery = this.getSession().getNamedQuery("getAllApplicableRulesForRoles");
            rolesQuery.setParameterList("roleUUIDs", roleUUIDs);
            List rolesResults = rolesQuery.list();
            if (rolesResults != null) {
                rules.addAll(rolesResults);
            }
        }
        if (membershipUUIDs != null && !membershipUUIDs.isEmpty()) {
            org.hibernate.Query membershipsQuery = this.getSession().getNamedQuery("getAllApplicableRulesForMemberships");
            membershipsQuery.setParameterList("membershipUUIDs", membershipUUIDs);
            List membershipsResults = membershipsQuery.list();
            if (membershipsResults != null) {
                rules.addAll(membershipsResults);
            }
        }
        ArrayList<Rule> rulesList = new ArrayList<Rule>(rules);
        Collections.sort(rulesList);
        return rulesList;
    }

    @Override
    public List<Rule> getApplicableRules(Rule.RuleType ruleType, String userUUID, Collection<String> roleUUIDs, Collection<String> groupUUIDs, Collection<String> membershipUUIDs, String entityID) {
        HashSet rules = new HashSet();
        if (userUUID != null) {
            org.hibernate.Query usersQuery = this.getSession().getNamedQuery("getApplicableRulesForUser");
            usersQuery.setParameter("ruleType", (Object)ruleType.name());
            usersQuery.setParameter("userUUID", (Object)userUUID);
            List userResults = usersQuery.list();
            if (userResults != null) {
                rules.addAll(userResults);
            }
        }
        if (entityID != null) {
            org.hibernate.Query entityQuery = this.getSession().getNamedQuery("getApplicableRulesForEntity");
            entityQuery.setParameter("ruleType", (Object)ruleType.name());
            entityQuery.setParameter("entityID", (Object)entityID);
            List entityResults = entityQuery.list();
            if (entityResults != null) {
                rules.addAll(entityResults);
            }
        }
        if (groupUUIDs != null && !groupUUIDs.isEmpty()) {
            org.hibernate.Query groupsQuery = this.getSession().getNamedQuery("getApplicableRulesForGroups");
            groupsQuery.setParameter("ruleType", (Object)ruleType.name());
            groupsQuery.setParameterList("groupUUIDs", groupUUIDs);
            List groupsResults = groupsQuery.list();
            if (groupsResults != null) {
                rules.addAll(groupsResults);
            }
        }
        if (roleUUIDs != null && !roleUUIDs.isEmpty()) {
            org.hibernate.Query rolesQuery = this.getSession().getNamedQuery("getApplicableRulesForRoles");
            rolesQuery.setParameter("ruleType", (Object)ruleType.name());
            rolesQuery.setParameterList("roleUUIDs", roleUUIDs);
            List rolesResults = rolesQuery.list();
            if (rolesResults != null) {
                rules.addAll(rolesResults);
            }
        }
        if (membershipUUIDs != null && !membershipUUIDs.isEmpty()) {
            org.hibernate.Query membershipsQuery = this.getSession().getNamedQuery("getApplicableRulesForMemberships");
            membershipsQuery.setParameter("ruleType", (Object)ruleType.name());
            membershipsQuery.setParameterList("membershipUUIDs", membershipUUIDs);
            List membershipsResults = membershipsQuery.list();
            if (membershipsResults != null) {
                rules.addAll(membershipsResults);
            }
        }
        ArrayList<Rule> rulesList = new ArrayList<Rule>(rules);
        Collections.sort(rulesList);
        return rulesList;
    }

    @Override
    public Set<Rule> getRulesByType(Set<String> ruleTypes) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getRuleListByType");
        query.setParameterList("types", ruleTypes);
        List results = query.list();
        if (results != null) {
            return new HashSet<Rule>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public RuleTypePolicy getRuleTypePolicy(Rule.RuleType ruleType) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getRuleTypePolicy");
        query.setParameter("type", (Object)ruleType.name());
        query.setMaxResults(1);
        return (RuleTypePolicy)query.uniqueResult();
    }

    @Override
    @Deprecated
    public Set<Rule> getAllApplicableRules(String entityID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getRuleListByEntity");
        query.setString("entity", entityID);
        List results = query.list();
        if (results != null) {
            return new HashSet<Rule>(results);
        }
        return Collections.emptySet();
    }

    @Override
    @Deprecated
    public Set<Rule> getAllApplicableRules(String entityID, Rule.RuleType ruleType) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getRuleListByEntityAndType");
        query.setString("entity", entityID);
        String name = ruleType.name();
        query.setString("ruletype", name);
        List results = query.list();
        if (results != null) {
            return new HashSet<Rule>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public List<InternalProcessDefinition> getProcessesExcept(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllProcessesListExcept");
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : processUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQueryList(InternalProcessDefinition.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public List<InternalProcessDefinition> getProcessesExcept(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize, ProcessDefinitionCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case NAME_ASC: {
                query = this.getSession().getNamedQuery("getAllProcessesListExceptOrderByNameAsc");
                break;
            }
            case LABEL_ASC: {
                query = this.getSession().getNamedQuery("getAllProcessesListExceptOrderByLabelAsc");
                break;
            }
            case VERSION_ASC: {
                query = this.getSession().getNamedQuery("getAllProcessesListExceptOrderByVersionAsc");
                break;
            }
            case STATE_ASC: {
                query = this.getSession().getNamedQuery("getAllProcessesListExceptOrderByStateAsc");
                break;
            }
            case NAME_DESC: {
                query = this.getSession().getNamedQuery("getAllProcessesListExceptOrderByNameDesc");
                break;
            }
            case LABEL_DESC: {
                query = this.getSession().getNamedQuery("getAllProcessesListExceptOrderByLabelDesc");
                break;
            }
            case VERSION_DESC: {
                query = this.getSession().getNamedQuery("getAllProcessesListExceptOrderByVersionDesc");
                break;
            }
            case STATE_DESC: {
                query = this.getSession().getNamedQuery("getAllProcessesListExceptOrderByStateDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getAllProcessesListExcept");
            }
        }
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : processUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQueryList(InternalProcessDefinition.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public int getNumberOfActivityInstanceComments(ActivityInstanceUUID activityUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfActivityComments");
        query.setString("activityUUID", activityUUID.getValue());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfComments(ProcessInstanceUUID instanceUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfAllComments");
        query.setString("instanceUUID", instanceUUID.getValue());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfProcessInstanceComments(ProcessInstanceUUID instanceUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfInstanceComments");
        query.setString("instanceUUID", instanceUUID.getValue());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Map<ActivityInstanceUUID, Integer> getNumberOfActivityInstanceComments(Set<ActivityInstanceUUID> activityUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivitiesComments");
        ArrayList<String> uuids = new ArrayList<String>();
        for (ActivityInstanceUUID uuid : activityUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("uuids", uuids);
        List comments = query.list();
        HashMap<ActivityInstanceUUID, Integer> result = new HashMap<ActivityInstanceUUID, Integer>();
        for (Comment comment : comments) {
            ActivityInstanceUUID activityUUID = comment.getActivityUUID();
            if (result.containsKey(activityUUID)) {
                result.put(activityUUID, (Integer)result.get(activityUUID) + 1);
                continue;
            }
            result.put(activityUUID, 1);
        }
        return result;
    }

    @Override
    public List<Comment> getActivityInstanceCommentFeed(ActivityInstanceUUID activityUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityComments");
        query.setString("activityUUID", activityUUID.getValue());
        return query.list();
    }

    @Override
    public List<Comment> getProcessInstanceCommentFeed(ProcessInstanceUUID instanceUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getInstanceComments");
        query.setString("instanceUUID", instanceUUID.getValue());
        return query.list();
    }

    @Override
    public List<Comment> getCommentFeed(ProcessInstanceUUID instanceUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllComments");
        query.setString("instanceUUID", instanceUUID.getValue());
        return query.list();
    }

    @Override
    public List<Rule> getRules(Rule.RuleType ruleType, int fromIndex, int pageSize) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getRuleListByExactType");
        query.setString("ruletype", ruleType.name());
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        return this.formatList(query.list());
    }

    @Override
    public Set<String> getAllExceptions(String entityID, Rule.RuleType ruleType) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getExceptionListByEntityAndRuleType");
        query.setString("entity", entityID);
        query.setString("ruletype", ruleType.name());
        List results = query.list();
        if (results != null) {
            return new HashSet<String>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<ProcessDefinitionUUID> getAllProcessDefinitionUUIDs() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllProcessDefinitionUUIDs");
        List results = query.list();
        if (results != null) {
            return new HashSet<ProcessDefinitionUUID>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<ProcessDefinitionUUID> getAllProcessDefinitionUUIDsExcept(Set<ProcessDefinitionUUID> processUUIDs) {
        if (processUUIDs == null || processUUIDs.isEmpty()) {
            return this.getAllProcessDefinitionUUIDs();
        }
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllProcessDefinitionUUIDsExcept");
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : processUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQuery(ProcessDefinitionUUID.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public long getNumberOfRules(Rule.RuleType ruleType) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfRulesForType");
        query.setString("ruletype", ruleType.name());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public WebTemporaryToken getToken(String token) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getTemporaryTokenFromKey");
        query.setString("tokenKey", token);
        query.setMaxResults(1);
        return (WebTemporaryToken)query.uniqueResult();
    }

    @Override
    public Set<WebTemporaryToken> getExpiredTokens() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getExpiredTemporaryTokens");
        query.setLong("currentDate", new Date().getTime());
        List results = query.list();
        if (results != null) {
            return new HashSet<WebTemporaryToken>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Category> getCategories(Collection<String> categoryNames) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getCategoriesByName");
        query.setParameterList("names", categoryNames);
        List results = query.list();
        if (results != null) {
            return new HashSet<Category>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Category> getAllCategories() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllCategories");
        List results = query.list();
        if (results != null) {
            return new HashSet<Category>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Category> getAllCategoriesExcept(Set<String> uuids) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllCategoriesExcept");
        query.setParameterList("uuids", uuids);
        List results = query.list();
        if (results != null) {
            return new HashSet<Category>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<CategoryImpl> getCategoriesByUUIDs(Set<CategoryUUID> uuids) {
        if (uuids == null || uuids.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> ids = new HashSet<String>();
        for (CategoryUUID categoryUUID : uuids) {
            ids.add(categoryUUID.getValue());
        }
        org.hibernate.Query query = this.getSession().getNamedQuery("getCategoriesByUUID");
        query.setParameterList("uuids", ids);
        List results = query.list();
        if (results != null) {
            return new HashSet<CategoryImpl>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public CategoryImpl getCategoryByUUID(String uuid) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getCategoryByUUID");
        query.setString("uuid", uuid);
        return (CategoryImpl)query.uniqueResult();
    }

    @Override
    public Set<ProcessDefinitionUUID> getProcessUUIDsFromCategory(String category) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProcessUUIDsFromCategory");
        query.setString("category", category);
        List results = query.list();
        if (results != null) {
            return new HashSet<ProcessDefinitionUUID>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public List<Object> search(SearchQueryBuilder query, int firstResult, int maxResults, Class<?> indexClass) {
        List<Object> result = new ArrayList<Object>();
        FullTextQuery hibernateQuery = this.createFullTextQuery(query, indexClass);
        if (hibernateQuery != null) {
            if (firstResult >= 0) {
                hibernateQuery.setFirstResult(firstResult);
                hibernateQuery.setMaxResults(maxResults);
            }
            result = hibernateQuery.list();
        }
        return result;
    }

    @Override
    public int search(SearchQueryBuilder query, Class<?> indexClass) {
        int result = 0;
        FullTextQuery hibernateQuery = this.createFullTextQuery(query, indexClass);
        if (hibernateQuery != null) {
            result = hibernateQuery.getResultSize();
        }
        return result;
    }

    private FullTextQuery createFullTextQuery(SearchQueryBuilder query, Class<?> indexClass) {
        QueryParser parser = null;
        String expression = query.getQuery();
        if (!expression.contains("\\:")) {
            parser = new QueryParser(LUCENE_VERSION, query.getIndex().getDefaultField(), (Analyzer)new StandardAnalyzer(LUCENE_VERSION));
        } else {
            List<String> list = query.getIndex().getAllFields();
            String[] fields = list.toArray(new String[list.size()]);
            parser = new MultiFieldQueryParser(LUCENE_VERSION, fields, (Analyzer)new StandardAnalyzer(LUCENE_VERSION));
        }
        FullTextSession searchSession = Search.getFullTextSession((Session)this.getSession());
        try {
            Query luceneQuery = parser.parse(query.getQuery());
            return searchSession.createFullTextQuery(luceneQuery, new Class[]{indexClass});
        }
        catch (ParseException e) {
            throw new BonitaRuntimeException(e.getMessage());
        }
    }

    @Override
    public RoleImpl findRoleByName(String name) {
        org.hibernate.Query query = this.getSession().getNamedQuery("findRoleByName");
        query.setString("roleName", name);
        return (RoleImpl)query.uniqueResult();
    }

    @Override
    public UserImpl findUserByUsername(String username) {
        org.hibernate.Query query = this.getSession().getNamedQuery("findUserByUsername");
        query.setString("username", username);
        return (UserImpl)query.uniqueResult();
    }

    @Override
    public Set<GroupImpl> findGroupsByName(String name) {
        org.hibernate.Query query = this.getSession().getNamedQuery("findGroupsByName");
        query.setString("groupName", name);
        List results = query.list();
        if (results != null) {
            return new HashSet<GroupImpl>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public ProfileMetadataImpl findProfileMetadataByName(String metadataName) {
        org.hibernate.Query query = this.getSession().getNamedQuery("findProfileMetadataByName");
        query.setString("metadataName", metadataName);
        return (ProfileMetadataImpl)query.uniqueResult();
    }

    @Override
    public List<GroupImpl> getAllGroups() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllGroups");
        return this.formatList(query.list());
    }

    @Override
    public Set<MembershipImpl> getAllMemberships() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getMemberships");
        List results = query.list();
        if (results != null) {
            return new HashSet<MembershipImpl>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public List<ProfileMetadataImpl> getAllProfileMetadata() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProfileMetadata");
        return this.formatList(query.list());
    }

    @Override
    public List<RoleImpl> getAllRoles() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllRoles");
        return this.formatList(query.list());
    }

    @Override
    public List<UserImpl> getAllUsers() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllUsers");
        return this.formatList(query.list());
    }

    @Override
    public List<GroupImpl> getGroupChildren(String parentGroupUUID) {
        org.hibernate.Query query;
        if (parentGroupUUID == null) {
            query = this.getSession().getNamedQuery("getRootGroups");
        } else {
            query = this.getSession().getNamedQuery("getGroupChildren");
            query.setString("parentGroupUUID", parentGroupUUID);
        }
        return this.formatList(query.list());
    }

    @Override
    public MembershipImpl findMembershipByRoleAndGroup(String roleUUID, String groupUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("findMembershipByRoleAndGroup");
        query.setString("roleUUID", roleUUID);
        query.setString("groupUUID", groupUUID);
        return (MembershipImpl)query.uniqueResult();
    }

    @Override
    public Set<MembershipImpl> getMembershipsByGroup(String groupUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getMembershipsByGroup");
        query.setString("groupUUID", groupUUID);
        List results = query.list();
        if (results != null) {
            return new HashSet<MembershipImpl>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<MembershipImpl> getMembershipsByRole(String roleUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getMembershipsByRole");
        query.setString("roleUUID", roleUUID);
        List results = query.list();
        if (results != null) {
            return new HashSet<MembershipImpl>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public GroupImpl getGroup(String groupUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getGroup");
        query.setString("groupUUID", groupUUID);
        return (GroupImpl)query.uniqueResult();
    }

    @Override
    public RoleImpl getRole(String roleUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getRole");
        query.setString("roleUUID", roleUUID);
        return (RoleImpl)query.uniqueResult();
    }

    @Override
    public UserImpl getUser(String userUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getUser");
        query.setString("userUUID", userUUID);
        return (UserImpl)query.uniqueResult();
    }

    @Override
    public MembershipImpl getMembership(String membershipUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getMembership");
        query.setString("membershipUUID", membershipUUID);
        return (MembershipImpl)query.uniqueResult();
    }

    @Override
    public ProfileMetadataImpl getProfileMetadata(String profileMetadataUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProfileMetadataByUUID");
        query.setString("profileMetadataUUID", profileMetadataUUID);
        return (ProfileMetadataImpl)query.uniqueResult();
    }

    @Override
    public List<UserImpl> getUsersByGroup(String groupUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getUsersByGroup");
        query.setString("groupUUID", groupUUID);
        return this.formatList(query.list());
    }

    @Override
    public List<UserImpl> getUsersByMembership(String membershipUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getUsersByMembership");
        query.setString("membershipUUID", membershipUUID);
        return this.formatList(query.list());
    }

    @Override
    public List<UserImpl> getUsersByRole(String roleUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getUsersByRole");
        query.setString("roleUUID", roleUUID);
        return this.formatList(query.list());
    }

    @Override
    public List<GroupImpl> getGroups(int fromIndex, int numberOfGroups) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllGroups");
        query.setFirstResult(fromIndex);
        query.setMaxResults(numberOfGroups);
        return this.formatList(query.list());
    }

    @Override
    public List<GroupImpl> getGroups(int fromIndex, int numberOfGroups, GroupCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case NAME_ASC: {
                query = this.getSession().getNamedQuery("getAllGroupsOrderByNameAsc");
                break;
            }
            case LABEL_ASC: {
                query = this.getSession().getNamedQuery("getAllGroupsOrderByLabelAsc");
                break;
            }
            case NAME_DESC: {
                query = this.getSession().getNamedQuery("getAllGroupsOrderByNameDesc");
                break;
            }
            case LABEL_DESC: {
                query = this.getSession().getNamedQuery("getAllGroupsOrderByLabelDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getAllGroups");
            }
        }
        query.setFirstResult(fromIndex);
        query.setMaxResults(numberOfGroups);
        return this.formatList(query.list());
    }

    @Override
    public int getNumberOfGroups() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfGroups");
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfRoles() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfRoles");
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfUsers() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfUsers");
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfUsersByGroup(String groupUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfUsersByGroup");
        query.setString("groupUUID", groupUUID);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfUsersByRole(String roleUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfUsersByRole");
        query.setString("roleUUID", roleUUID);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public List<RoleImpl> getRoles(int fromIndex, int numberOfRoles) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllRoles");
        query.setFirstResult(fromIndex);
        query.setMaxResults(numberOfRoles);
        return this.formatList(query.list());
    }

    @Override
    public List<RoleImpl> getRoles(int fromIndex, int numberOfRoles, RoleCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case NAME_ASC: {
                query = this.getSession().getNamedQuery("getAllRolesOrderByNameAsc");
                break;
            }
            case LABEL_ASC: {
                query = this.getSession().getNamedQuery("getAllRolesOrderByLabelAsc");
                break;
            }
            case NAME_DESC: {
                query = this.getSession().getNamedQuery("getAllRolesOrderByNameDesc");
                break;
            }
            case LABEL_DESC: {
                query = this.getSession().getNamedQuery("getAllRolesOrderByLabelDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getAllRoles");
            }
        }
        query.setFirstResult(fromIndex);
        query.setMaxResults(numberOfRoles);
        return this.formatList(query.list());
    }

    @Override
    public List<UserImpl> getUsers(int fromIndex, int numberOfUsers) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getAllUsers");
        query.setFirstResult(fromIndex);
        query.setMaxResults(numberOfUsers);
        return this.formatList(query.list());
    }

    @Override
    public List<UserImpl> getUsers(int fromIndex, int numberOfUsers, UserCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case FIRST_NAME_ASC: {
                query = this.getSession().getNamedQuery("getAllUsersOderByFirstNameAsc");
                break;
            }
            case LAST_NAME_ASC: {
                query = this.getSession().getNamedQuery("getAllUsersOderByLastNameAsc");
                break;
            }
            case USER_NAME_ASC: {
                query = this.getSession().getNamedQuery("getAllUsersOderByUserNameAsc");
                break;
            }
            case FIRST_NAME_DESC: {
                query = this.getSession().getNamedQuery("getAllUsersOderByFirtNameDesc");
                break;
            }
            case LAST_NAME_DESC: {
                query = this.getSession().getNamedQuery("getAllUsersOderByLastNameDesc");
                break;
            }
            case USER_NAME_DESC: {
                query = this.getSession().getNamedQuery("getAllUsersOderByUserNameDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getAllUsers");
            }
        }
        query.setFirstResult(fromIndex);
        query.setMaxResults(numberOfUsers);
        return this.formatList(query.list());
    }

    @Override
    public List<UserImpl> getUsersByGroup(String groupUUID, int fromIndex, int numberOfUsers) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getUsersByGroup");
        query.setString("groupUUID", groupUUID);
        query.setFirstResult(fromIndex);
        query.setMaxResults(numberOfUsers);
        return this.formatList(query.list());
    }

    @Override
    public List<UserImpl> getUsersByGroup(String groupUUID, int fromIndex, int numberOfUsers, UserCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case FIRST_NAME_ASC: {
                query = this.getSession().getNamedQuery("getUsersByGroupOrderByFirstNameAsc");
                break;
            }
            case LAST_NAME_ASC: {
                query = this.getSession().getNamedQuery("getUsersByGroupOrderByLastNameAsc");
                break;
            }
            case USER_NAME_ASC: {
                query = this.getSession().getNamedQuery("getUsersByGroupOrderByUserNameAsc");
                break;
            }
            case FIRST_NAME_DESC: {
                query = this.getSession().getNamedQuery("getUsersByGroupOrderByFirstNameDesc");
                break;
            }
            case LAST_NAME_DESC: {
                query = this.getSession().getNamedQuery("getUsersByGroupOrderByLastNameDesc");
                break;
            }
            case USER_NAME_DESC: {
                query = this.getSession().getNamedQuery("getUsersByGroupOrderByUserNameDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getUsersByGroup");
            }
        }
        query.setString("groupUUID", groupUUID);
        query.setFirstResult(fromIndex);
        query.setMaxResults(numberOfUsers);
        return this.formatList(query.list());
    }

    @Override
    public List<UserImpl> getUsersByRole(String roleUUID, int fromIndex, int numberOfUsers) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getUsersByRole");
        query.setString("roleUUID", roleUUID);
        query.setFirstResult(fromIndex);
        query.setMaxResults(numberOfUsers);
        return this.formatList(query.list());
    }

    @Override
    public List<UserImpl> getUsersByRole(String roleUUID, int fromIndex, int numberOfUsers, UserCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case FIRST_NAME_ASC: {
                query = this.getSession().getNamedQuery("getUsersByRoleOrderByFirstNameAsc");
                break;
            }
            case LAST_NAME_ASC: {
                query = this.getSession().getNamedQuery("getUsersByRoleOrderByLastNameAsc");
                break;
            }
            case USER_NAME_ASC: {
                query = this.getSession().getNamedQuery("getUsersByRoleOrderByUserNameAsc");
                break;
            }
            case FIRST_NAME_DESC: {
                query = this.getSession().getNamedQuery("getUsersByRoleOrderByFirstNameDesc");
                break;
            }
            case LAST_NAME_DESC: {
                query = this.getSession().getNamedQuery("getUsersByRoleOrderByLastNameDesc");
                break;
            }
            case USER_NAME_DESC: {
                query = this.getSession().getNamedQuery("getUsersByRoleOrderByUserNameDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getUsersByRole");
            }
        }
        query.setString("roleUUID", roleUUID);
        query.setFirstResult(fromIndex);
        query.setMaxResults(numberOfUsers);
        return this.formatList(query.list());
    }

    @Override
    public List<UserImpl> getUsersByManager(String managerUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getUsersByManager");
        query.setString("managerUUID", managerUUID);
        return this.formatList(query.list());
    }

    @Override
    public List<UserImpl> getUsersByDelegee(String delegeeUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getUsersByDelegee");
        query.setString("delegeeUUID", delegeeUUID);
        return this.formatList(query.list());
    }

    @Override
    public List<ProfileMetadataImpl> getProfileMetadata(int fromIndex, int numberOfMetadata) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProfileMetadata");
        query.setFirstResult(fromIndex);
        query.setMaxResults(numberOfMetadata);
        return this.formatList(query.list());
    }

    @Override
    public int getNumberOfProfileMetadata() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfProfileMetadata");
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public List<GroupImpl> getGroupChildren(String parentGroupUUID, int fromIndex, int numberOfGroups) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getGroupChildren");
        query.setFirstResult(fromIndex);
        query.setMaxResults(numberOfGroups);
        query.setString("parentGroupUUID", parentGroupUUID);
        return this.formatList(query.list());
    }

    @Override
    public List<GroupImpl> getGroupChildren(String parentGroupUUID, int fromIndex, int numberOfGroups, GroupCriterion pagingCriterion) {
        org.hibernate.Query query = null;
        switch (pagingCriterion) {
            case NAME_ASC: {
                query = this.getSession().getNamedQuery("getGroupChildrenOrderByNameAsc");
                break;
            }
            case LABEL_ASC: {
                query = this.getSession().getNamedQuery("getGroupChildrenOrderByLabelAsc");
                break;
            }
            case NAME_DESC: {
                query = this.getSession().getNamedQuery("getGroupChildrenOrderByNameDesc");
                break;
            }
            case LABEL_DESC: {
                query = this.getSession().getNamedQuery("getGroupChildrenOrderByLabelDesc");
                break;
            }
            case DEFAULT: {
                query = this.getSession().getNamedQuery("getGroupChildren");
            }
        }
        query.setFirstResult(fromIndex);
        query.setMaxResults(numberOfGroups);
        query.setString("parentGroupUUID", parentGroupUUID);
        return this.formatList(query.list());
    }

    @Override
    public int getNumberOfGroupChildren(String parentGroupUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfGroupChildren");
        query.setString("parentGroupUUID", parentGroupUUID);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public List<GroupImpl> getGroups(Collection<String> groupUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getGroups");
        query.setParameterList("groupUUIDs", groupUUIDs);
        return this.formatList(query.list());
    }

    @Override
    public List<MembershipImpl> getMemberships(Collection<String> membershipUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getMemberships");
        query.setParameterList("membershipUUIDs", membershipUUIDs);
        return this.formatList(query.list());
    }

    @Override
    public List<RoleImpl> getRoles(Collection<String> roleUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getRoles");
        query.setParameterList("roleUUIDs", roleUUIDs);
        return this.formatList(query.list());
    }

    @Override
    public List<UserImpl> getUsers(Collection<String> userUUIDs) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getUsers");
        query.setParameterList("userUUIDs", userUUIDs);
        return this.formatList(query.list());
    }

    @Override
    public Set<ActivityDefinitionUUID> getProcessTaskUUIDs(ProcessDefinitionUUID definitionUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProcessTaskUUIDs");
        query.setString("uuid", definitionUUID.getValue());
        HashSet<ActivityDefinitionUUID> activityUUIDs = new HashSet<ActivityDefinitionUUID>();
        List uuids = query.list();
        if (uuids != null) {
            activityUUIDs.addAll(uuids);
        }
        return activityUUIDs;
    }

    @Override
    public boolean processExists(ProcessDefinitionUUID definitionUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("processExists");
        query.setString("uuid", definitionUUID.getValue());
        Long uuid = (Long)query.uniqueResult();
        boolean exists = true;
        if (uuid != 1L) {
            exists = false;
        }
        return exists;
    }

    @Override
    public List<Long> getProcessInstancesDuration(Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProcessInstancesDuration");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getProcessInstancesDuration(ProcessDefinitionUUID processUUID, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProcessInstancesDurationFromDefinitionUUID");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("processUUID", processUUID.getValue());
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getProcessInstancesDurationFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getProcessInstancesDurationFromDefinitionUUIDs");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : processUUIDs) {
            uuids.add(uuid.toString());
        }
        List<Long> durations = this.executeSplittedQueryList(Long.class, query, "processUUIDs", uuids);
        if (durations != null) {
            Collections.sort(durations);
            return durations;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> getActivityInstancesExecutionTime(Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstancesExecutionTime");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getActivityInstancesExecutionTime(ProcessDefinitionUUID processUUID, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstancesExecutionTimeFromProcessDefinitionUUID");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("processUUID", processUUID.getValue());
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getActivityInstancesExecutionTimeFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstancesExecutionTimeFromProcessDefinitionUUIDs");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : processUUIDs) {
            uuids.add(uuid.toString());
        }
        List<Long> executionTimes = this.executeSplittedQueryList(Long.class, query, "processUUIDs", uuids);
        if (executionTimes != null) {
            Collections.sort(executionTimes);
            return executionTimes;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> getActivityInstancesExecutionTime(ActivityDefinitionUUID activityUUID, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstancesExecutionTimeFromActivityDefinitionUUID");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("activityUUID", activityUUID.getValue());
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getActivityInstancesExecutionTimeFromActivityUUIDs(Set<ActivityDefinitionUUID> activityUUIDs, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstancesExecutionTimeFromActivityDefinitionUUIDs");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        HashSet<String> uuids = new HashSet<String>();
        for (ActivityDefinitionUUID uuid : activityUUIDs) {
            uuids.add(uuid.toString());
        }
        List<Long> executionTimes = this.executeSplittedQueryList(Long.class, query, "activityUUIDs", uuids);
        if (executionTimes != null) {
            Collections.sort(executionTimes);
            return executionTimes;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> getTaskInstancesWaitingTime(Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getTaskInstancesWaitingTime");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getTaskInstancesWaitingTime(ProcessDefinitionUUID processUUID, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getTaskInstancesWaitingTimeFromProcessDefinitionUUID");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("processUUID", processUUID.getValue());
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getTaskInstancesWaitingTimeFromProcessDefinitionUUIDs");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : processUUIDs) {
            uuids.add(uuid.toString());
        }
        List<Long> waitingTimes = this.executeSplittedQueryList(Long.class, query, "processUUIDs", uuids);
        if (waitingTimes != null) {
            Collections.sort(waitingTimes);
            return waitingTimes;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> getTaskInstancesWaitingTime(ActivityDefinitionUUID taskUUID, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getTaskInstancesWaitingTimeFromActivityDefinitionUUID");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("activityUUID", taskUUID.getValue());
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeFromTasksUUIDs(Set<ActivityDefinitionUUID> tasksUUIDs, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getTaskInstancesWaitingTimeFromActivityDefinitionUUIDs");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        HashSet<String> uuids = new HashSet<String>();
        for (ActivityDefinitionUUID uuid : tasksUUIDs) {
            uuids.add(uuid.toString());
        }
        List<Long> waitingTimes = this.executeSplittedQueryList(Long.class, query, "activityUUIDs", uuids);
        if (waitingTimes != null) {
            Collections.sort(waitingTimes);
            return waitingTimes;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUser(String username, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getTaskInstancesWaitingTimeOfUser");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("userId", username);
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUser(String username, ProcessDefinitionUUID processUUID, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getTaskInstancesWaitingTimeOfUserFromProcessDefinitionUUID");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("processUUID", processUUID.getValue());
        query.setString("userId", username);
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUserFromProcessUUIDs(String username, Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getTaskInstancesWaitingTimeOfUserFromProcessDefinitionUUIDs");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("userId", username);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : processUUIDs) {
            uuids.add(uuid.toString());
        }
        List<Long> waitingTimes = this.executeSplittedQueryList(Long.class, query, "processUUIDs", uuids);
        if (waitingTimes != null) {
            Collections.sort(waitingTimes);
            return waitingTimes;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUser(String username, ActivityDefinitionUUID taskUUID, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getTaskInstancesWaitingTimeOfUserFromActivityDefinitionUUID");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("activityUUID", taskUUID.getValue());
        query.setString("userId", username);
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUserFromTaskUUIDs(String username, Set<ActivityDefinitionUUID> taskUUIDs, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getTaskInstancesWaitingTimeOfUserFromActivityDefinitionUUIDs");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("userId", username);
        HashSet<String> uuids = new HashSet<String>();
        for (ActivityDefinitionUUID uuid : taskUUIDs) {
            uuids.add(uuid.toString());
        }
        List<Long> waitingTimes = this.executeSplittedQueryList(Long.class, query, "activityUUIDs", uuids);
        if (waitingTimes != null) {
            Collections.sort(waitingTimes);
            return waitingTimes;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> getActivityInstancesDuration(Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstancesDuration");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getActivityInstancesDuration(ProcessDefinitionUUID processUUID, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstancesDurationFromProcessDefinitionUUID");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("processUUID", processUUID.getValue());
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getActivityInstancesDurationFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstancesDurationFromProcessDefinitionUUIDs");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : processUUIDs) {
            uuids.add(uuid.toString());
        }
        List<Long> durations = this.executeSplittedQueryList(Long.class, query, "processUUIDs", uuids);
        if (durations != null) {
            Collections.sort(durations);
            return durations;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> getActivityInstancesDuration(ActivityDefinitionUUID activityUUID, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstancesDurationFromActivityDefinitionUUID");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("activityUUID", activityUUID.getValue());
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getActivityInstancesDurationFromActivityUUIDs(Set<ActivityDefinitionUUID> activityUUIDs, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstancesDurationFromActivityDefinitionUUIDs");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        HashSet<String> uuids = new HashSet<String>();
        for (ActivityDefinitionUUID uuid : activityUUIDs) {
            uuids.add(uuid.toString());
        }
        List<Long> durations = this.executeSplittedQueryList(Long.class, query, "activityUUIDs", uuids);
        if (durations != null) {
            Collections.sort(durations);
            return durations;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> getActivityInstancesDurationByActivityType(ActivityDefinition.Type activityType, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstancesDurationByActivityType");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("activityType", activityType.toString());
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getActivityInstancesDurationByActivityType(ActivityDefinition.Type activityType, ProcessDefinitionUUID processUUID, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstancesDurationByActivityTypeFromProcessDefinitionUUID");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("activityType", activityType.toString());
        query.setString("processUUID", processUUID.getValue());
        return this.formatList(query.list());
    }

    @Override
    public List<Long> getActivityInstancesDurationByActivityTypeFromProcessUUIDs(ActivityDefinition.Type activityType, Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getActivityInstancesDurationByActivityTypeFromProcessDefinitionUUIDs");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("activityType", activityType.toString());
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : processUUIDs) {
            uuids.add(uuid.toString());
        }
        List<Long> durations = this.executeSplittedQueryList(Long.class, query, "processUUIDs", uuids);
        if (durations != null) {
            Collections.sort(durations);
            return durations;
        }
        return Collections.emptyList();
    }

    @Override
    public long getNumberOfCreatedProcessInstances(Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfCreatedProcessInstances");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        return (Long)query.uniqueResult();
    }

    @Override
    public long getNumberOfCreatedProcessInstances(ProcessDefinitionUUID processUUID, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfCreatedProcessInstancesFromProcessUUID");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("processUUID", processUUID.getValue());
        return (Long)query.uniqueResult();
    }

    @Override
    public long getNumberOfCreatedActivityInstances(Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfCreatedActivityInstances");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        return (Long)query.uniqueResult();
    }

    @Override
    public long getNumberOfCreatedActivityInstances(ProcessDefinitionUUID processUUID, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfCreatedActivityInstancesFromProcessUUID");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("processUUID", processUUID.getValue());
        return (Long)query.uniqueResult();
    }

    @Override
    public long getNumberOfCreatedActivityInstancesFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfCreatedActivityInstancesFromProcessUUIDs");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : processUUIDs) {
            uuids.add(uuid.getValue());
        }
        query.setParameterList("processUUIDs", uuids);
        return (Long)query.uniqueResult();
    }

    @Override
    public long getNumberOfCreatedActivityInstances(ActivityDefinitionUUID activityUUID, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfCreatedActivityInstancesFromActivityDefUUID");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("activityUUID", activityUUID.getValue());
        return (Long)query.uniqueResult();
    }

    @Override
    public long getNumberOfCreatedActivityInstancesFromActivityUUIDs(Set<ActivityDefinitionUUID> activityUUIDs, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfCreatedActivityInstancesFromActivityDefUUIDs");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        HashSet<String> uuids = new HashSet<String>();
        for (ActivityDefinitionUUID uuid : activityUUIDs) {
            uuids.add(uuid.getValue());
        }
        query.setParameterList("activityUUIDs", uuids);
        return (Long)query.uniqueResult();
    }

    @Override
    public long getNumberOfCreatedActivityInstancesByActivityType(ActivityDefinition.Type activityType, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfCreatedActivityInstancesByActivityType");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("activityType", activityType.toString());
        return (Long)query.uniqueResult();
    }

    @Override
    public long getNumberOfCreatedActivityInstancesByActivityType(ActivityDefinition.Type activityType, ProcessDefinitionUUID processUUID, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfCreatedActivityInstancesByActivityTypeFromProcessUUID");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("activityType", activityType.toString());
        query.setString("processUUID", processUUID.getValue());
        return (Long)query.uniqueResult();
    }

    @Override
    public long getNumberOfCreatedActivityInstancesByActivityTypeFromProcessUUIDs(ActivityDefinition.Type activityType, Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfCreatedActivityInstancesByActivityTypeFromProcessUUIDs");
        query.setLong("since", since.getTime());
        query.setLong("until", until.getTime());
        query.setString("activityType", activityType.toString());
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : processUUIDs) {
            uuids.add(uuid.getValue());
        }
        query.setParameterList("processUUIDs", uuids);
        return (Long)query.uniqueResult();
    }

    @Override
    public boolean containsOtherActiveActivities(ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNumberOfOtherActiveActivities");
        query.setString("instanceUUID", instanceUUID.getValue());
        String actUUID = "null";
        if (activityUUID != null) {
            actUUID = activityUUID.getValue();
        }
        query.setString("activityUUID", actUUID);
        ArrayList<ActivityState> taskStates = new ArrayList<ActivityState>();
        taskStates.add(ActivityState.READY);
        taskStates.add(ActivityState.EXECUTING);
        taskStates.add(ActivityState.FAILED);
        taskStates.add(ActivityState.SUSPENDED);
        query.setParameterList("states", taskStates, ACTIVITY_STATE_USER_TYPE);
        Long count = (Long)query.uniqueResult();
        boolean contains = true;
        if (count == 0L) {
            contains = false;
        }
        return contains;
    }

    @Override
    public IncomingEventInstance getSignalStartIncomingEvent(List<String> processNames, String signalCode) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getSignalStartIncomingEvent");
        query.setParameterList("processNames", processNames);
        query.setString("signalCode", signalCode);
        return (IncomingEventInstance)query.uniqueResult();
    }

    @Override
    public List<IncomingEventInstance> getMessageStartIncomingEvents(Set<String> processNames) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getMessageStartIncomingEvents");
        query.setParameterList("processNames", processNames);
        return query.list();
    }

    @Override
    public DocumentVersion getDocumentVersion(long versionId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getDocumentVersion");
        query.setLong("versionId", versionId);
        return (DocumentVersionImpl)query.uniqueResult();
    }

    @Override
    public DocumentContent getDocumentContent(long contentStorageId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getDocumentContent");
        query.setLong("contentStorageId", contentStorageId);
        return (DocumentContentImpl)query.uniqueResult();
    }

    @Override
    public List<DocumentDescriptor> getDocumentDescriptors(int fromIndex, int maxResults) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getDocumentDescriptors");
        query.setFirstResult(fromIndex);
        query.setMaxResults(maxResults);
        return query.list();
    }

    @Override
    public DocumentDescriptor getDocumentDescriptor(long documentDescriptorId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getDocumentDescriptor");
        query.setLong("documentDescriptorId", documentDescriptorId);
        return (DocumentDescriptorImpl)query.uniqueResult();
    }

    @Override
    public List<DocumentVersion> getDocumentVersions(int fromIndex, int maxResults, long versionSeriesId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getDocumentVersions");
        query.setLong("versionSeriesId", versionSeriesId);
        query.setFirstResult(fromIndex);
        query.setMaxResults(maxResults);
        return query.list();
    }

    @Override
    public List<DocumentVersion> getDocumentVersions(long versionSeriesId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getDocumentVersions");
        query.setLong("versionSeriesId", versionSeriesId);
        return query.list();
    }

    @Override
    public List<Document> searchDocuments(DocumentSearchBuilder builder, int fromIndex, int maxResults) {
        org.hibernate.Query query = this.getCompleteSearchQuery(builder, this.getSession().getNamedQuery("searchDocuments"), true);
        query.setFirstResult(fromIndex);
        query.setMaxResults(maxResults);
        return query.list();
    }

    @Override
    public long getNumberOfDocuments(DocumentSearchBuilder builder) {
        org.hibernate.Query query = this.getCompleteSearchQuery(builder, this.getSession().getNamedQuery("getNumberOfDocuments"), false);
        return (Long)query.uniqueResult();
    }

    private org.hibernate.Query getCompleteSearchQuery(DocumentSearchBuilder builder, org.hibernate.Query query, boolean addOrderBy) {
        String queryString = query.getQueryString();
        StringBuilder newQuery = new StringBuilder();
        newQuery.append(queryString);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        List<Object> queryObjects = builder.getQuery();
        if (!queryObjects.isEmpty()) {
            newQuery.append(" AND ");
        }
        for (Object object : queryObjects) {
            if (object instanceof DocumentCriterion) {
                DocumentCriterion criterion = (DocumentCriterion)object;
                switch (criterion.getField()) {
                    case ID: {
                        this.createEqualsOrInClause(newQuery, criterion, "dv.id", "documentId", parameters);
                        break;
                    }
                    case PROCESS_DEFINITION_UUID: {
                        this.createEqualsOrInClause(newQuery, criterion, "dm.processDefinitionUUID.value", "processDef", parameters);
                        break;
                    }
                    case PROCESS_DEFINITION_UUID_WITHOUT_INSTANCES: {
                        newQuery.append(" (");
                        this.createEqualsOrInClause(newQuery, criterion, "dm.processDefinitionUUID.value", "processDef", parameters);
                        newQuery.append(" AND dm.processInstanceUUID.value IS NULL");
                        newQuery.append(" )");
                        break;
                    }
                    case PROCESS_INSTANCE_UUID: {
                        this.createEqualsOrInClause(newQuery, criterion, "dm.processInstanceUUID.value", "processInstance", parameters);
                        break;
                    }
                    case NAME: {
                        this.createEqualsOrInClause(newQuery, criterion, "dd.name", "name", parameters);
                        break;
                    }
                    case FILENAME: {
                        this.createEqualsOrInClause(newQuery, criterion, "dv.contentFileName", "fileName", parameters);
                        break;
                    }
                    case CREATION_DATE: {
                        this.createEqualsOrInClause(newQuery, criterion, "dv.creationDate", "creationDate", parameters);
                        break;
                    }
                    case AUTHOR: {
                        this.createEqualsOrInClause(newQuery, criterion, "dv.author", "author", parameters);
                        break;
                    }
                    case LAST_MODIFICATION_DATE: {
                        this.createEqualsOrInClause(newQuery, criterion, "dv.lastModificationDate", "lastModificationDate", parameters);
                        break;
                    }
                    case IS_EMPTY: {
                        if (((Boolean)criterion.getValue()).booleanValue()) {
                            newQuery.append(" dv.contentSize = 0");
                            break;
                        }
                        newQuery.append(" dv.contentSize > 0");
                    }
                }
                continue;
            }
            newQuery.append(" ").append(object).append(" ");
        }
        if (addOrderBy) {
            newQuery.append(" ORDER BY dd.name, dv.creationDate DESC, dv.id");
        }
        org.hibernate.Query searchQuery = this.session.createQuery(newQuery.toString());
        for (Map.Entry entry : parameters.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Collection) {
                searchQuery.setParameterList((String)entry.getKey(), (Collection)value);
                continue;
            }
            searchQuery.setParameter((String)entry.getKey(), value);
        }
        return searchQuery;
    }

    private void createEqualsOrInClause(StringBuilder whereClause, DocumentCriterion criterion, String field, String parameterName, Map<String, Object> parameters) {
        boolean isDate = DocumentIndex.CREATION_DATE.equals((Object)criterion.getField()) || DocumentIndex.LAST_MODIFICATION_DATE.equals((Object)criterion.getField());
        boolean fromStringToLong = DocumentIndex.ID.equals((Object)criterion.getField());
        switch (criterion.getCriterionType()) {
            case BETWEEN: {
                Object fromValue = criterion.getFrom();
                Object toValue = criterion.getTo();
                if (isDate) {
                    fromValue = ((Date)fromValue).getTime();
                    toValue = ((Date)toValue).getTime();
                } else if (fromStringToLong) {
                    fromValue = Long.valueOf((String)fromValue);
                    toValue = Long.valueOf((String)toValue);
                }
                String from = parameterName + "_from";
                String to = parameterName + "_to";
                whereClause.append(" (");
                whereClause.append(field);
                whereClause.append(" >= :");
                whereClause.append(from);
                whereClause.append(" AND ");
                whereClause.append(field);
                whereClause.append(" <= :");
                whereClause.append(to);
                whereClause.append(") ");
                parameters.put(from, fromValue);
                parameters.put(to, toValue);
                break;
            }
            case IN: {
                whereClause.append(" " + field + " IN (");
                Collection<?> values = criterion.getValues();
                Iterator<?> iterator = values.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    whereClause.append(':');
                    whereClause.append(parameterName);
                    whereClause.append('_');
                    whereClause.append(i);
                    if (iterator.hasNext()) {
                        whereClause.append(',');
                    }
                    if (fromStringToLong) {
                        value = Long.valueOf((String)value);
                    }
                    parameters.put(parameterName + "_" + i, value);
                    ++i;
                }
                whereClause.append(") ");
                break;
            }
            case EQUALS: {
                whereClause.append(field);
                whereClause.append(" = :");
                whereClause.append(parameterName);
                Object value = criterion.getValue();
                if (isDate) {
                    value = ((Date)value).getTime();
                } else if (fromStringToLong) {
                    value = Long.valueOf((String)value);
                }
                parameters.put(parameterName, value);
            }
        }
    }

    @Override
    public List<Document> getDocuments(ProcessInstanceUUID instanceUUID, int fromResult, int maxResults) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getDocumentsOfProcessInstance");
        query.setString("processInstanceUUID", instanceUUID.getValue());
        query.setFirstResult(fromResult);
        query.setMaxResults(maxResults);
        return query.list();
    }

    @Override
    public List<Document> getDocuments(ProcessInstanceUUID instanceUUID, String documentName, int fromResult, int maxResults) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getDocumentsOfProcessInstanceWithName");
        query.setString("processInstanceUUID", instanceUUID.getValue());
        query.setString("name", documentName);
        query.setFirstResult(fromResult);
        query.setMaxResults(maxResults);
        return query.list();
    }

    @Override
    public List<Document> getDocuments(ProcessDefinitionUUID processDefUUID, String documentName, int fromResult, int maxResults) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getDocumentsOfProcessDefinitionWithName");
        query.setString("processDefinitionUUID", processDefUUID.getValue());
        query.setString("name", documentName);
        query.setFirstResult(fromResult);
        query.setMaxResults(maxResults);
        return query.list();
    }

    @Override
    public List<Document> getDocumentsOfProcessDefinitionWithoutInstances(ProcessDefinitionUUID processDefUUID, int fromResult, int maxResults) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getDocumentsOfProcessDefinitionWithoutInstances");
        query.setString("processDefinitionUUID", processDefUUID.getValue());
        query.setFirstResult(fromResult);
        query.setMaxResults(maxResults);
        return query.list();
    }

    @Override
    public long getNbOfDocuments(ProcessInstanceUUID instanceUUID, String documentName) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNbOfDocumentsOfProcessInstanceWithName");
        query.setString("processInstanceUUID", instanceUUID.getValue());
        query.setString("name", documentName);
        return (Long)query.uniqueResult();
    }

    @Override
    public long hasDocuments(ProcessInstanceUUID instanceUUID, String documentName, boolean metaDocument) {
        org.hibernate.Query query = this.getSession().getNamedQuery("hasDocumentsOfProcessInstanceWithNameAndMetaType");
        query.setString("processInstanceUUID", instanceUUID.getValue());
        query.setString("name", documentName);
        query.setBoolean("meta", metaDocument);
        return (Long)query.uniqueResult();
    }

    @Override
    public long hasDocuments(ProcessDefinitionUUID processUUID, String documentName, boolean metaDocument) {
        org.hibernate.Query query = this.getSession().getNamedQuery("hasDocumentsOfProcessDefinitionWithNameAndMetaType");
        query.setString("processDefinitionUUID", processUUID.getValue());
        query.setString("name", documentName);
        query.setBoolean("meta", metaDocument);
        return (Long)query.uniqueResult();
    }

    @Override
    public List<DocumentDescriptorMapping> getDocumentDescriptorMappings(long documentDescriptorId, int fromIndex, int maxResults) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getDocumentDescriptorMappings");
        query.setLong("documentDescriptorId", documentDescriptorId);
        query.setFirstResult(fromIndex);
        query.setMaxResults(maxResults);
        return query.list();
    }

    @Override
    public List<Document> getMetaDocumentOfProcessDefinition(ProcessDefinitionUUID processDefUUID, int fromResult, int maxResults) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getMetaDocumentsDocumentsOfProcessDefinition");
        query.setString("processDefinitionUUID", processDefUUID.getValue());
        query.setFirstResult(fromResult);
        query.setMaxResults(maxResults);
        return query.list();
    }

    @Override
    public List<DocumentDescriptor> getDocumentDescriptors(ProcessDefinitionUUID processDefinitionUUID, int fromIndex, int maxResults) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getDocumentDescriptorsOfProcessDefinition");
        query.setString("processDefinitionUUID", processDefinitionUUID.getValue());
        query.setFirstResult(fromIndex);
        query.setMaxResults(maxResults);
        return query.list();
    }

    @Override
    public void deleteIncompatibleEvents(OutgoingEventInstance outgoing) {
        org.hibernate.Query query = this.getSession().getNamedQuery("deleteIncompatibleEvents");
        query.setLong("outgoingId", outgoing.getId());
        query.executeUpdate();
    }

    @Override
    public Job getJob(Long jobId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getJob");
        query.setLong("id", jobId.longValue());
        return (Job)query.uniqueResult();
    }

    @Override
    public List<Job> getJobs() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getJobs");
        return this.formatList(query.list());
    }

    @Override
    public Job getJob(ActivityDefinitionUUID activityUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getJobOfActivityUUID");
        query.setString("activityUUID", activityUUID.getValue());
        return (Job)query.uniqueResult();
    }

    @Override
    public List<Job> getExecutableJobs(String processUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getExecutableJobsOfProcess");
        query.setString("processUUID", processUUID);
        query.setLong("current", System.currentTimeMillis());
        return this.formatList(query.list());
    }

    @Override
    public List<String> getNonLockedProcessesHavingJobs(Set<String> lockedProcessUUIDs, int maxResult) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNonLockedProcessesHavingJobs");
        if (!lockedProcessUUIDs.isEmpty()) {
            query.setParameterList("lockedProcessUUIDs", lockedProcessUUIDs);
        } else {
            HashSet<String> dummyProcessUUIDsToExclude = new HashSet<String>();
            dummyProcessUUIDsToExclude.add("ddddduuuuuuummmmmmyyyyyy");
            query.setParameterList("lockedProcessUUIDs", dummyProcessUUIDsToExclude);
        }
        query.setLong("current", System.currentTimeMillis());
        query.setMaxResults(maxResult);
        return this.formatList(query.list());
    }

    protected <T> List<T> formatList(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public Long getNextJobDueDate(Set<String> processUUIDsToExclude) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNextJobDueDate");
        if (!processUUIDsToExclude.isEmpty()) {
            query.setParameterList("processUUIDsToExclude", processUUIDsToExclude);
        } else {
            HashSet<String> dummyProcessUUIDsToExclude = new HashSet<String>();
            dummyProcessUUIDsToExclude.add("ddddduuuuuuummmmmmyyyyyy");
            query.setParameterList("processUUIDsToExclude", dummyProcessUUIDsToExclude);
        }
        return (Long)query.uniqueResult();
    }

    @Override
    public List<Job> getJobsOfExecution(String executionEventUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getJobsOfExecution");
        query.setString("executionEventUUID", executionEventUUID);
        List jobs = query.list();
        return this.formatList(jobs);
    }

    @Override
    public List<Job> getJobsOfInstance(ProcessInstanceUUID instanceUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getJobsOfInstance");
        query.setString("instanceUUID", instanceUUID.getValue());
        List jobs = query.list();
        return this.formatList(jobs);
    }

    @Override
    public List<Job> getJobs(String eventType) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getJobsOfType");
        query.setString("eventType", eventType);
        return this.formatList(query.list());
    }

    @Override
    public List<Job> getJobs(String eventType, ProcessInstanceUUID instanceUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getJobsOfInstanceType");
        query.setString("eventType", eventType);
        query.setString("instanceUUID", instanceUUID.getValue());
        return this.formatList(query.list());
    }

    @Override
    public List<Job> getJobs(String eventType, String eventUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getJobsOfExecutionType");
        query.setString("eventType", eventType);
        query.setString("eventUUID", eventUUID);
        return this.formatList(query.list());
    }

    @Override
    public List<Job> getJobsWithoutProcessUUID(int fromIndex, int maxResults) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getJobsWithoutProcessUUID");
        query.setFirstResult(fromIndex);
        query.setMaxResults(maxResults);
        return this.formatList(query.list());
    }

    @Override
    public List<EventCouple> getCorrelationKeyMessageEventCouples(int maxCouples) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getCorrelationKeyMessageEventCouples");
        query.setMaxResults(maxCouples);
        query.setResultTransformer(Transformers.aliasToBean(EventCouple.class));
        return this.formatList(query.list());
    }

    @Override
    public List<String> getInstanceIdsFromMetadata(int index, int maxResult) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getInstanceIdsFromMetadata");
        query.setFirstResult(index);
        query.setMaxResults(maxResult);
        return this.formatList(query.list());
    }

    @Override
    public Long getNextEventDueDate() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNextMessageEventDueDate");
        return (Long)query.uniqueResult();
    }

    @Override
    public Long getNextExpressionEventDueDate() {
        org.hibernate.Query query = this.getSession().getNamedQuery("getNextExpressionEventDueDate");
        return (Long)query.uniqueResult();
    }

    @Override
    public JobLock getJobLock(String processUUID) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getJobLock");
        query.setString("processUUID", processUUID);
        return (JobLock)query.uniqueResult();
    }

    @Override
    public List<IncomingEventInstance> getMessageEventSubProcessIncomingEvents(ProcessInstanceUUID eventSubProcessRootInstanceUUID, long outgoingId) {
        org.hibernate.Query query = this.getSession().getNamedQuery("getMessageEventSubProcessIncomingEvents");
        query.setString("eventSubProcessRootInstanceUUID", eventSubProcessRootInstanceUUID.getValue());
        query.setLong("outgoingId", outgoingId);
        return this.formatList(query.list());
    }
}

