/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.services.CommandService;

public abstract class EventExecutorThread
extends Thread {
    static final Logger LOG = Logger.getLogger(EventExecutorThread.class.getName());
    protected volatile boolean isActive = true;
    private final EventExecutor executor;
    private boolean refresh;
    private int currentIdleInterval;
    private int minimumInterval;
    private final Object semaphore = new Object();

    EventExecutorThread(EventExecutor executor, String name) {
        super(name);
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Starting...");
        }
        this.currentIdleInterval = this.executor.getIdleMillis();
        this.minimumInterval = this.executor.getMinimumInterval();
        try {
            this.activate();
            while (this.isActive()) {
                try {
                    long waitPeriod;
                    this.refresh = false;
                    this.currentIdleInterval = this.executor.getIdleMillis();
                    this.execute();
                    if (!this.isActive() || (waitPeriod = this.getWaitPeriod()) <= 0L) continue;
                    Object object = this.semaphore;
                    synchronized (object) {
                        if (!this.refresh) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine(this.getName() + " will wait for max " + waitPeriod + "ms on " + this.executor);
                            }
                            this.semaphore.wait(waitPeriod);
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine(this.getName() + " woke up, refresh=" + this.refresh);
                            }
                        } else if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("skipped wait because new message arrived");
                        }
                    }
                }
                catch (InterruptedException e) {
                    LOG.info((this.isActive() ? "active" : "inactive") + this.getJobExecutorName() + " thread '" + this.getName() + "' got interrupted");
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "exception in " + this.getJobExecutorName() + " thread. waiting " + this.currentIdleInterval + " milliseconds: " + e.getMessage(), e);
                    }
                    try {
                        Object object = this.semaphore;
                        synchronized (object) {
                            this.semaphore.wait(this.currentIdleInterval);
                        }
                    }
                    catch (InterruptedException e2) {
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("delay after exception got interrupted: " + e2);
                    }
                }
            }
        }
        catch (Throwable t) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, t.getMessage(), t);
            }
        }
        finally {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info(this.getName() + " leaves cyberspace");
            }
        }
    }

    protected abstract void activate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Notifying " + this.getJobExecutorName() + " thread of new Event");
        }
        Object object = this.semaphore;
        synchronized (object) {
            this.refresh = true;
            this.semaphore.notify();
        }
    }

    public void deactivate(boolean join) {
        if (this.isActive()) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("deactivating " + this.getName());
            }
            this.setIsActive(false);
            this.interrupt();
            if (join) {
                try {
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info("joining " + this.getName());
                    }
                    this.join(60000L);
                }
                catch (InterruptedException e) {
                    LOG.severe("joining " + this.getName() + " got interrupted");
                }
            }
        } else if (LOG.isLoggable(Level.INFO)) {
            LOG.info("ignoring deactivate: " + this.getName() + " is not active");
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info(this.getJobExecutorName() + " thread: " + this.getName() + " deactivated");
        }
    }

    private synchronized void setIsActive(boolean value) {
        this.isActive = value;
    }

    public synchronized boolean isActive() {
        return this.isActive;
    }

    protected CommandService getCommandService() {
        return this.executor.getCommandService();
    }

    protected EventExecutor getEventExecutor() {
        return this.executor;
    }

    private long getWaitPeriod() {
        long interval = this.executor.getIdleMillis();
        Long nextDueDate = this.getNextDueDate();
        if (nextDueDate != null) {
            long currentTimeMillis = System.currentTimeMillis();
            if (nextDueDate < currentTimeMillis + (long)this.currentIdleInterval) {
                interval = nextDueDate - currentTimeMillis;
            }
        }
        if (interval <= (long)this.minimumInterval) {
            interval = this.minimumInterval;
        }
        return interval;
    }

    protected abstract void execute() throws InterruptedException;

    protected abstract String getJobExecutorName();

    protected abstract Long getNextDueDate();
}

