/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.runtime.event.EventCouple;
import org.ow2.bonita.runtime.event.EventCoupleId;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.GroovyUtil;

public class GetExpressionMessageEventCouples
implements Command<Set<EventCoupleId>> {
    private static final long serialVersionUID = 4329888516348355224L;
    static final Logger LOG = Logger.getLogger(GetExpressionMessageEventCouples.class.getName());

    @Override
    public Set<EventCoupleId> execute(Environment environment) throws Exception {
        OutgoingEventInstance outgoing;
        HashSet<Long> usedIncomings = new HashSet<Long>();
        HashSet<Long> usedOutgoings = new HashSet<Long>();
        HashSet<EventCouple> validCouples = new HashSet<EventCouple>();
        HashMap incompatibleEvents = new HashMap();
        EventService eventService = EnvTool.getEventService();
        List<EventCouple> potentialCouples = eventService.getMessageEventCouples();
        for (EventCouple eventCouple : potentialCouples) {
            if (usedIncomings.contains(eventCouple.getIncoming().getId()) || usedOutgoings.contains(eventCouple.getOutgoing().getId())) continue;
            boolean match = true;
            IncomingEventInstance incoming = eventCouple.getIncoming();
            outgoing = eventCouple.getOutgoing();
            String expression = incoming.getExpression();
            Map<String, Object> parameters = outgoing.getParameters();
            String signal = incoming.getSignal();
            if (expression != null && !"event.start.timer".equals(signal)) {
                String groovyExpression = "${" + expression + "}";
                ActivityInstanceUUID activityUUID = incoming.getActivityUUID();
                match = activityUUID != null ? ((Boolean)GroovyUtil.evaluate(groovyExpression, parameters, activityUUID, false, false)).booleanValue() : ((Boolean)GroovyUtil.evaluate(groovyExpression, parameters)).booleanValue();
            }
            if (match) {
                usedIncomings.add(incoming.getId());
                usedOutgoings.add(outgoing.getId());
                validCouples.add(eventCouple);
                if (!LOG.isLoggable(Level.INFO)) continue;
                LOG.info("Adding eventCouple:[incoming=" + incoming.getId() + " " + incoming.getSignal() + ", outgoing=" + outgoing.getId() + "] to the queue");
                continue;
            }
            if (!incompatibleEvents.containsKey(incoming)) {
                incompatibleEvents.put(incoming, new HashSet());
            }
            ((Set)incompatibleEvents.get(incoming)).add(outgoing.getId());
        }
        for (Map.Entry entry : incompatibleEvents.entrySet()) {
            if (usedIncomings.contains(entry.getKey())) continue;
            Iterator i$ = ((Set)entry.getValue()).iterator();
            while (i$.hasNext()) {
                long incompatibleOutgoingId = (Long)i$.next();
                if (usedOutgoings.contains(incompatibleOutgoingId)) continue;
                ((IncomingEventInstance)entry.getKey()).addIncompatibleEvent(incompatibleOutgoingId);
            }
        }
        if (validCouples.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<EventCoupleId> result = new HashSet<EventCoupleId>();
        for (EventCouple validCouple : validCouples) {
            IncomingEventInstance incoming = validCouple.getIncoming();
            outgoing = validCouple.getOutgoing();
            incoming.setLocked(true);
            outgoing.setLocked(true);
            result.add(new EventCoupleId(incoming.getId(), outgoing.getId()));
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Expression message event: New event couples to execute: " + ((Object)result).toString());
        }
        return result;
    }
}

