/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.services.UUIDService;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ProcessUtil;

public class DbUUIDService
implements UUIDService {
    static final Logger LOG = Logger.getLogger(ProcessUtil.class.getName());
    private Map<ProcessDefinitionUUID, Long> uuids = new HashMap<ProcessDefinitionUUID, Long>();
    private Map<ProcessDefinitionUUID, Object> mutexs = new HashMap<ProcessDefinitionUUID, Object>();

    private synchronized Object getMutex(ProcessDefinitionUUID processUUID) {
        if (!this.mutexs.containsKey(processUUID)) {
            this.mutexs.put(processUUID, new Object());
        }
        return this.mutexs.get(processUUID);
    }

    private synchronized void removeUUID(ProcessDefinitionUUID processUUID) {
        this.uuids.remove(processUUID);
    }

    private synchronized Long getUUIDValue(ProcessDefinitionUUID processUUID) {
        return this.uuids.get(processUUID);
    }

    private synchronized void setUUIDValue(ProcessDefinitionUUID processUUID, Long value) {
        this.uuids.put(processUUID, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNewProcessInstanceNb(ProcessDefinitionUUID processUUID) {
        long newProcessInstanceNb;
        Object object = this.getMutex(processUUID);
        synchronized (object) {
            newProcessInstanceNb = EnvTool.getCommandService().execute(new StoreMetaDataCommand(processUUID));
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating a new ProcessInstance with nb: " + newProcessInstanceNb);
        }
        return newProcessInstanceNb;
    }

    private String getMetadataName(ProcessDefinitionUUID processUUID) {
        return "*****" + processUUID + "*****instance-nb*****";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void archiveOrDeleteProcess(ProcessDefinitionUUID processUUID) {
        Object object = this.getMutex(processUUID);
        synchronized (object) {
            StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
            ManagementAPI managementAPI = accessor.getManagementAPI();
            String metadataName = this.getMetadataName(processUUID);
            managementAPI.deleteMetaData(metadataName);
            this.removeUUID(processUUID);
        }
    }

    private class StoreMetaDataCommand
    implements Command<Long> {
        private static final long serialVersionUID = 1L;
        private ProcessDefinitionUUID processUUID;

        public StoreMetaDataCommand(ProcessDefinitionUUID processUUID) {
            this.processUUID = processUUID;
        }

        @Override
        public Long execute(Environment environment) throws Exception {
            String metaName = DbUUIDService.this.getMetadataName(this.processUUID);
            StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
            ManagementAPI managementAPI = accessor.getManagementAPI();
            long lastInMemory = 0L;
            Long uuidValue = DbUUIDService.this.getUUIDValue(this.processUUID);
            if (uuidValue != null) {
                lastInMemory = uuidValue;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Last process instance number found in memory: " + lastInMemory);
            }
            long lastInDb = 0L;
            String metadataValue = managementAPI.getMetaData(metaName);
            if (metadataValue != null) {
                lastInDb = Long.valueOf(metadataValue);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Last process instance number found in database: " + lastInDb);
            }
            long newProcessInstanceNb = Math.max(lastInDb, lastInMemory) + 1L;
            DbUUIDService.this.setUUIDValue(this.processUUID, newProcessInstanceNb);
            managementAPI.addMetaData(metaName, Long.toString(newProcessInstanceNb));
            return newProcessInstanceNb;
        }
    }
}

