/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;
import org.ow2.util.asm.AnnotationVisitor;
import org.ow2.util.asm.Attribute;
import org.ow2.util.asm.ClassReader;
import org.ow2.util.asm.ClassVisitor;
import org.ow2.util.asm.FieldVisitor;
import org.ow2.util.asm.MethodVisitor;

public final class ClassDataTool {
    private ClassDataTool() {
    }

    public static MyVisitor visitClass(byte[] data) {
        MyVisitor mv = new MyVisitor();
        ClassReader cr = new ClassReader(data);
        cr.accept((ClassVisitor)mv, 1);
        return mv;
    }

    public static Set<byte[]> getClasses(Class<?> ... classes) throws IOException {
        HashSet<byte[]> classesSet = new HashSet<byte[]>();
        if (classes != null) {
            for (Class<?> clazz : classes) {
                if (clazz == null) {
                    String message = ExceptionManager.getInstance().getFullMessage("buc_CDT_1", new Object[0]);
                    throw new IOException(message);
                }
                classesSet.add(ClassDataTool.getClassData(clazz));
            }
        }
        return classesSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getClassData(Class<?> clazz) throws IOException {
        if (clazz == null) {
            String message = ExceptionManager.getInstance().getFullMessage("buc_CDT_2", new Object[0]);
            throw new IOException(message);
        }
        String resource = clazz.getName().replace('.', '/') + ".class";
        InputStream inputStream = clazz.getClassLoader().getResourceAsStream(resource);
        byte[] data = null;
        try {
            if (inputStream == null) {
                throw new IOException("Impossible to get stream from class: " + clazz.getName() + ", className= " + resource);
            }
            data = Misc.getAllContentFrom(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return data;
    }

    public static class MyVisitor
    implements ClassVisitor {
        private String className = null;
        private String superClassName = null;
        private String[] interfaces = null;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            this.interfaces = interfaces;
            this.superClassName = superName;
        }

        public void visitSource(String source, String debug) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return null;
        }

        public void visitEnd() {
        }

        public String getClassName() {
            return this.className.replace("/", ".");
        }

        public String getSuperClassName() {
            return this.superClassName;
        }

        public String[] getInterfaces() {
            return this.interfaces;
        }
    }
}

