/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.engine.SessionFactoryImplementor;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.env.EnvironmentFactory;
import org.ow2.bonita.env.GlobalEnvironmentFactory;
import org.ow2.bonita.identity.auth.DomainOwner;
import org.ow2.bonita.services.CommandService;
import org.ow2.bonita.util.BonitaConstants;
import org.ow2.bonita.util.DbTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.IoUtil;
import org.ow2.bonita.util.UpdateJobLocksCommand;
import org.ow2.bonita.util.UpdateJobsCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbMigration {
    private static final Logger LOG = LoggerFactory.getLogger(DbMigration.class);

    private DbMigration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 3) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_DBM_1", new Object[0]);
            throw new IllegalArgumentException(message);
        }
        BonitaConstants.getBonitaHomeFolder();
        String domain = args[0];
        String db = args[1].toLowerCase();
        int stage = Integer.valueOf(args[2]);
        String useSearch = "bonita.search.use";
        System.setProperty("bonita.search.use", "false");
        LOG.info("Starting Migration on tenant: " + domain);
        try {
            if (stage < 2) {
                LOG.info("Stage 1: Updating history database schema...");
                DbMigration.updateDatabase(domain, "hibernate-configuration:history", db);
                LOG.info("Stage 1: DONE");
            }
            if (stage < 3) {
                LOG.info("Stage 2: Updating journal database schema...");
                DbMigration.updateDatabase(domain, "hibernate-configuration:core", db);
                DbMigration.cleanIOEvents(domain);
                DbMigration.updateJobsAndJobLocks(domain);
                LOG.info("Stage 2: DONE");
            }
            LOG.info("Migration on tenant " + domain + ": DONE");
        }
        finally {
            System.clearProperty("bonita.search.use");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateJobsAndJobLocks(String domain) throws Exception {
        EnvironmentFactory envFactory = GlobalEnvironmentFactory.getEnvironmentFactory(domain);
        Environment environment = envFactory.openEnvironment();
        try {
            DomainOwner.setDomain(domain);
            CommandService commandService = envFactory.get(CommandService.class);
            UpdateJobLocksCommand creteJobLockscommand = new UpdateJobLocksCommand();
            commandService.execute(creteJobLockscommand);
            UpdateJobsCommand updateJobsCommand = new UpdateJobsCommand();
            commandService.execute(updateJobsCommand);
        }
        finally {
            DomainOwner.setDomain(null);
            environment.close();
        }
    }

    private static void updateDatabase(String domain, String configurationName, String db) throws Exception {
        String path = DbMigration.getSQLScriptPath(db);
        DbMigration.migrateDb(domain, configurationName, db, path);
    }

    private static String getSQLScriptPath(String db) {
        StringBuilder migrationScript = new StringBuilder("/migration/");
        migrationScript.append(db).append("-5.9-5.10.sql");
        return migrationScript.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrateDb(String domain, String configurationName, String database, String resourcePath) throws Exception {
        SessionFactoryImplementor sessionFactory = DbTool.getSessionFactory(domain, configurationName.replaceAll("-configuration", "-session-factory"));
        try {
            InputStream inputStream = null;
            try {
                inputStream = DbMigration.getScriptStream(resourcePath);
                DbMigration.executeScript((SessionFactory)sessionFactory, inputStream, database);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        finally {
            sessionFactory.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanIOEvents(String domain) throws Exception {
        SessionFactoryImplementor sessionFactory = DbTool.getSessionFactory(domain, "hibernate-configuration:core".replaceAll("-configuration", "-session-factory"));
        try {
            LOG.info("Clean Incoming Events... ");
            String incomingQuery = "UPDATE org.ow2.bonita.runtime.event.IncomingEventInstance SET locked = FALSE WHERE locked = TRUE";
            int updated = DbMigration.executeQuery((SessionFactory)sessionFactory, "UPDATE org.ow2.bonita.runtime.event.IncomingEventInstance SET locked = FALSE WHERE locked = TRUE");
            LOG.info("update " + updated + " Incoming Events.");
            LOG.info("Clean Outgoing Events: ");
            String outgoingQuery = "UPDATE org.ow2.bonita.runtime.event.OutgoingEventInstance SET locked = FALSE, incomingId = NULL WHERE locked = TRUE";
            updated = DbMigration.executeQuery((SessionFactory)sessionFactory, "UPDATE org.ow2.bonita.runtime.event.OutgoingEventInstance SET locked = FALSE, incomingId = NULL WHERE locked = TRUE");
            LOG.info("update " + updated + " Outgoing Events.");
        }
        finally {
            sessionFactory.close();
        }
    }

    private static InputStream getScriptStream(String resourcePath) {
        InputStream inputStream = DbMigration.class.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_DBM_2", new Object[0]);
            throw new IllegalArgumentException(message);
        }
        return inputStream;
    }

    public static int executeQuery(SessionFactory sessionFactory, String query) {
        Session session = sessionFactory.openSession();
        session.getTransaction().begin();
        int i = 0;
        try {
            i = session.createQuery(query).executeUpdate();
        }
        catch (Exception e) {
            LOG.error("Error while executing command: " + query, (Throwable)e);
        }
        session.getTransaction().commit();
        session.close();
        return i;
    }

    public static void executeScript(SessionFactory sessionFactory, InputStream inputStream, String db) {
        byte[] bytes = IoUtil.readBytes(inputStream);
        String scriptContent = new String(bytes);
        List<String> commands = DbMigration.getCommands(scriptContent, db);
        Session session = sessionFactory.openSession();
        session.getTransaction().begin();
        LOG.info("DB Commands Execution: " + commands.size());
        for (String command : commands) {
            LOG.info("Executing command : " + command);
            try {
                session.createSQLQuery(command).executeUpdate();
            }
            catch (Exception e) {
                LOG.error("Error while executing command: " + command, (Throwable)e);
            }
        }
        session.getTransaction().commit();
        session.close();
    }

    public static List<String> getCommands(String scriptContent, String db) {
        String lastCommand;
        int index;
        String[] tmp;
        String delimiter = ";";
        if ("sqlserver".equals(db) || "sybase".equals(db)) {
            delimiter = "go";
        }
        String regex = delimiter.concat("\r?\n");
        ArrayList<String> commands = new ArrayList<String>();
        for (String command : tmp = scriptContent.split(regex)) {
            if (command.trim().length() <= 0) continue;
            commands.add(command.trim());
        }
        int lastIndex = commands.size() - 1;
        if (lastIndex >= 0 && (index = (lastCommand = (String)commands.get(lastIndex)).lastIndexOf(delimiter)) > 0) {
            lastCommand = lastCommand.substring(0, index);
            commands.remove(lastIndex);
            commands.add(lastCommand);
        }
        return commands;
    }
}

