/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.Cache;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.ow2.bonita.env.EnvironmentFactory;
import org.ow2.bonita.env.GlobalEnvironmentFactory;
import org.ow2.bonita.facade.def.element.impl.MetaDataImpl;
import org.ow2.bonita.facade.identity.Group;
import org.ow2.bonita.facade.identity.Membership;
import org.ow2.bonita.facade.identity.impl.GroupImpl;
import org.ow2.bonita.facade.identity.impl.MembershipImpl;
import org.ow2.bonita.facade.identity.impl.RoleImpl;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.runtime.event.Master;
import org.ow2.bonita.search.SearchUtil;
import org.ow2.bonita.util.BonitaConstants;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

public final class DbTool {
    static final Logger LOG = Logger.getLogger(DbTool.class.getName());

    private DbTool() {
    }

    protected static Configuration getConfiguration(String domain, String configurationName) throws Exception {
        EnvironmentFactory envFactory = GlobalEnvironmentFactory.getEnvironmentFactory(domain);
        if (envFactory == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_DBT_1", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        Configuration config = (Configuration)envFactory.get(configurationName);
        if (config == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_DBT_2", configurationName);
            throw new BonitaRuntimeException(message);
        }
        return config;
    }

    protected static SchemaExport getSchemaExport(Configuration config) {
        return new SchemaExport(config, config.buildSettings());
    }

    public static void recreateDb(String domain, String configurationName) throws Exception {
        SessionFactoryImplementor sessionFactory;
        BonitaConstants.getBonitaHomeFolder();
        Configuration config = DbTool.getConfiguration(domain, configurationName);
        if (LOG.isLoggable(Level.FINE) && (sessionFactory = DbTool.getSessionFactory(domain, configurationName.replaceAll("-configuration", "-session-factory"))) != null) {
            String[] script;
            Dialect dialect = sessionFactory.getDialect();
            for (String s : script = config.generateSchemaCreationScript(dialect)) {
                LOG.fine(s);
            }
        }
        SchemaExport schemaExport = DbTool.getSchemaExport(config);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating schema...");
        }
        String dbVendor = DbTool.getDatabaseVendor(config);
        StringBuilder fileNamebuilder = new StringBuilder("/script/post-initdb-").append(dbVendor).append(".sql");
        schemaExport.setImportFile(fileNamebuilder.toString());
        schemaExport.create(true, true);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Schema created.");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Initializing master...");
        }
        if ("hibernate-configuration:core".equals(configurationName)) {
            DbTool.initializeMaster(domain, configurationName);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Master initialized.");
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Adding default users...");
        }
        if ("hibernate-configuration:core".equals(configurationName)) {
            DbTool.addDefaultUsers(domain, configurationName);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Default users added.");
            }
        }
    }

    protected static SessionFactoryImplementor getSessionFactory(String domain, String sessionFactoryName) throws Exception {
        SessionFactory sessionFactory = (SessionFactory)GlobalEnvironmentFactory.getEnvironmentFactory(domain).get(sessionFactoryName);
        if (sessionFactory instanceof SessionFactoryImplementor) {
            return (SessionFactoryImplementor)sessionFactory;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDefaultUsers(String domain, String configurationName) throws Exception {
        SessionFactoryImplementor sessionFactory = DbTool.getSessionFactory(domain, configurationName.replaceAll("-configuration", "-session-factory"));
        if (sessionFactory != null) {
            Session session = null;
            try {
                session = sessionFactory.openSession();
                Transaction tx = session.beginTransaction();
                RoleImpl memberRole = DbTool.createDefaultRole((org.hibernate.Session)session, "user", "User", "The user role");
                RoleImpl adminRole = DbTool.createDefaultRole((org.hibernate.Session)session, "admin", "Admin", "The admin role");
                GroupImpl defaultGroup = DbTool.createDefaultGroup((org.hibernate.Session)session, "platform", "Platform", "The default group", null);
                MembershipImpl memberMembership = DbTool.createDefaultMembership((org.hibernate.Session)session, defaultGroup, memberRole);
                HashSet<Membership> memberMemberships = new HashSet<Membership>();
                memberMemberships.add(memberMembership);
                MembershipImpl adminMembership = DbTool.createDefaultMembership((org.hibernate.Session)session, defaultGroup, adminRole);
                HashSet<Membership> adminMemberships = new HashSet<Membership>();
                adminMemberships.add(adminMembership);
                DbTool.addDefaultUser((org.hibernate.Session)session, "admin", null, null, "bpm", null, null, adminMemberships);
                UserImpl user1 = DbTool.addDefaultUser((org.hibernate.Session)session, "john", "John", "Doe", "bpm", null, null, memberMemberships);
                UserImpl user2 = DbTool.addDefaultUser((org.hibernate.Session)session, "jack", "Jack", "Doe", "bpm", user1.getUUID(), user1.getUUID(), memberMemberships);
                DbTool.addDefaultUser((org.hibernate.Session)session, "james", "James", "Doe", "bpm", user1.getUUID(), user2.getUUID(), memberMemberships);
                MetaDataImpl defaultUsersAddedMetadata = new MetaDataImpl("DEFAULT_USERS_CREATED", "true");
                session.save((Object)defaultUsersAddedMetadata);
                tx.commit();
            }
            catch (HibernateException e) {
                LOG.log(Level.WARNING, "Unable to add the default users in the DB", e);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeMaster(String domain, String configurationName) throws Exception {
        SessionFactoryImplementor sessionFactory = DbTool.getSessionFactory(domain, configurationName.replaceAll("-configuration", "-session-factory"));
        if (sessionFactory != null) {
            Session session = null;
            try {
                session = sessionFactory.openSession();
                Transaction tx = session.beginTransaction();
                Master master = new Master(0L, "unknown");
                session.save((Object)master);
                tx.commit();
            }
            catch (HibernateException e) {
                LOG.log(Level.WARNING, "Unable to add the default users in the DB", e);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    public static MembershipImpl createDefaultMembership(org.hibernate.Session session, GroupImpl group, RoleImpl role) throws HibernateException {
        MembershipImpl membership = new MembershipImpl();
        membership.setGroup(group);
        membership.setRole(role);
        session.save((Object)membership);
        return membership;
    }

    public static GroupImpl createDefaultGroup(org.hibernate.Session session, String name, String label, String description, Group parentGroup) throws HibernateException {
        GroupImpl group = new GroupImpl(name);
        group.setLabel(label);
        group.setDescription(description);
        group.setParentGroup(parentGroup);
        session.save((Object)group);
        return group;
    }

    public static RoleImpl createDefaultRole(org.hibernate.Session session, String name, String label, String description) throws HibernateException {
        RoleImpl role = new RoleImpl(name);
        role.setLabel(label);
        role.setDescription(description);
        session.save((Object)role);
        return role;
    }

    public static UserImpl addDefaultUser(org.hibernate.Session session, String username, String firstName, String lastName, String password, String manager, String delegee, Set<Membership> memberships) throws HibernateException {
        UserImpl user = new UserImpl(username, Misc.hash(password));
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setMemberships(memberships);
        user.setManagerUUID(manager);
        user.setDelegeeUUID(delegee);
        session.save((Object)user);
        return user;
    }

    public static void dropDb(String domain, String configurationName) throws Exception {
        EventExecutor eventExecutor = GlobalEnvironmentFactory.getEnvironmentFactory("default").get(EventExecutor.class);
        eventExecutor.stop();
        Configuration configuration = DbTool.getConfiguration(domain, configurationName);
        SchemaExport schemaExport = DbTool.getSchemaExport(configuration);
        schemaExport.drop(false, true);
        String indexesDirecoryPath = SearchUtil.getIndexesDirectoryPath(configuration);
        if (indexesDirecoryPath != null) {
            Misc.deleteDir(new File(indexesDirecoryPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 2) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_DBT_3", "hibernate-configuration:core", "hibernate-configuration:history");
            throw new IllegalArgumentException(message);
        }
        String domain = args[0];
        String disableSearch = "bonita.search.use";
        System.setProperty("bonita.search.use", "false");
        try {
            for (int i = 1; i < args.length; ++i) {
                DbTool.recreateDb(domain, args[i]);
            }
        }
        finally {
            StringBuilder builder = new StringBuilder();
            builder.append("*******************************************************************************************************************\n");
            builder.append("* We recommend that you read the documentation (in case of possible modifications in your database configuration) *\n");
            builder.append("*******************************************************************************************************************\n");
            LOG.info(builder.toString());
            System.clearProperty("bonita.search.use");
        }
    }

    public static boolean isOnDb(String dbName, Configuration config) {
        String lowerDbName = dbName.toLowerCase();
        return DbTool.isOnDatabaseAccordingToDialect(lowerDbName, config) || DbTool.isOnDatabaseAccordingToURL(lowerDbName, config);
    }

    private static boolean isOnDatabaseAccordingToDialect(String dbName, Configuration config) {
        String dialect = DbTool.getDbDialect(config);
        if (dialect == null) {
            throw new BonitaRuntimeException("The 'hibernate.dialect' property must be set");
        }
        String lowerDialectName = dialect.toLowerCase();
        return lowerDialectName.contains(dbName);
    }

    private static String getDatabaseVendor(Configuration config) {
        if (DbTool.isOnDb("oracle", config)) {
            return "oracle";
        }
        if (DbTool.isOnDb("mysql", config)) {
            return "mysql";
        }
        if (DbTool.isOnDb("h2", config)) {
            return "h2";
        }
        if (DbTool.isOnDb("postgres", config)) {
            return "postgres";
        }
        if (DbTool.isOnDb("sqlserver", config)) {
            return "sqlserver";
        }
        throw new BonitaRuntimeException("Database unknown.");
    }

    private static boolean isOnDatabaseAccordingToURL(String lowerDbName, Configuration config) {
        String url = DbTool.getDbUrl(config);
        if (url != null) {
            int index = url.indexOf(":/");
            url = index == -1 ? url.split(":")[1] : url.substring(0, index);
            url = url.toLowerCase();
        }
        return url != null && url.contains(lowerDbName);
    }

    public static String getDbDialect(Configuration config) {
        return config.getProperty("hibernate.dialect");
    }

    public static String getDbUrl(Configuration config) {
        return config.getProperty("hibernate.connection.url");
    }

    public static String getDbUseQueryCache(Configuration config) {
        return config.getProperty("hibernate.cache.use_query_cache");
    }

    public static String getDbUseSecondLeveleCache(Configuration config) {
        return config.getProperty("hibernate.cache.use_second_level_cache");
    }

    public static String getDbDriverClass(Configuration config) {
        return config.getProperty("hibernate.connection.driver_class");
    }

    public static void cleanCache(String domain, String sessionFactoryName) throws Exception {
        Cache cache;
        SessionFactoryImplementor sessionFactory = DbTool.getSessionFactory(domain, sessionFactoryName);
        if (sessionFactory != null && (cache = sessionFactory.getCache()) != null) {
            cache.evictDefaultQueryRegion();
            cache.evictQueryRegions();
            cache.evictCollectionRegions();
            cache.evictEntityRegions();
        }
    }
}

