/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.deployment.DeploymentRuntimeException;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.AttachmentDefinition;
import org.ow2.bonita.facade.def.element.EventDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.element.IncomingEventDefinition;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.EventProcessDefinition;
import org.ow2.bonita.facade.exception.DocumentAlreadyExistsException;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.exception.DocumentationCreationException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.runtime.ProcessInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventInstance;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.event.JobBuilder;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.Document;
import org.ow2.bonita.services.DocumentationManager;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.type.Variable;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.DateUtil;
import org.ow2.bonita.util.DocumentService;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.GroovyUtil;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.VariableUtil;

public class ProcessUtil {
    static final Logger LOG = Logger.getLogger(ProcessUtil.class.getName());

    public static void removeAllInstanceEvents(ProcessInstance instance) {
        EventService eventService = EnvTool.getEventService();
        eventService.removeSubscriptions(instance.getUUID());
        eventService.removeFiredEvents(instance.getUUID());
        eventService.removeJobs(instance.getUUID());
        eventService.removeLock(instance.getRootInstanceUUID());
    }

    public static void removeInternalInstanceEvents(ProcessInstanceUUID instanceUUID) {
        EventService eventService = EnvTool.getEventService();
        eventService.removeSubscriptions(instanceUUID);
        eventService.removeJobs(instanceUUID);
        eventService.removeLock(instanceUUID);
    }

    public static Date getTimerDate(String condition, ProcessDefinitionUUID definitionUUID, long lastTime) throws GroovyException {
        return ProcessUtil.getTimerDate(condition, definitionUUID, null, lastTime);
    }

    public static Date getTimerDate(String condition, ActivityInstanceUUID activityUUID) throws GroovyException {
        return ProcessUtil.getTimerDate(condition, null, activityUUID, 0L);
    }

    private static Date getTimerDate(String condition, ProcessDefinitionUUID definitionUUID, ActivityInstanceUUID activityUUID, long lastTime) throws GroovyException {
        Misc.checkArgsNotNull(condition);
        Date dueDate = null;
        String evaluatedCondition = condition;
        if (Misc.isJustAGroovyExpression(condition)) {
            Object value = null;
            if (activityUUID != null) {
                value = GroovyUtil.evaluate(condition, null, activityUUID, false, false);
            } else {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("timerLastExecution", lastTime);
                value = GroovyUtil.evaluate(condition, context, definitionUUID, false);
            }
            if (value instanceof Date) {
                dueDate = (Date)value;
            } else if (value instanceof String) {
                evaluatedCondition = (String)value;
            } else if (value instanceof Long) {
                evaluatedCondition = ((Long)value).toString();
            } else if (value instanceof Integer) {
                evaluatedCondition = ((Integer)value).toString();
            }
        }
        if (dueDate == null) {
            try {
                Long date = Long.parseLong(evaluatedCondition);
                dueDate = activityUUID != null ? new Date(System.currentTimeMillis() + date) : (lastTime < 0L ? new Date(System.currentTimeMillis() + date) : new Date(date));
            }
            catch (NumberFormatException e1) {
                try {
                    dueDate = DateUtil.parseDate(evaluatedCondition);
                }
                catch (IllegalArgumentException e2) {
                    throw new BonitaRuntimeException("Timer condition '" + evaluatedCondition + "' is neither a Long nor a formatted date", e2);
                }
            }
        }
        return dueDate;
    }

    public static Execution createProcessInstance(ProcessDefinitionUUID processUUID, Map<String, Object> variables, Collection<InitialAttachment> attachments, ProcessInstanceUUID parentInstanceUUID, ProcessInstanceUUID rootInstanceUUID, ActivityDefinitionUUID activityUUID, ActivityInstanceUUID parentActivityUUID) throws ProcessNotFoundException {
        InternalProcessDefinition process = FacadeUtil.getProcessDefinition(processUUID);
        Execution rootExecution = ProcessUtil.createProcessInstance(process, rootInstanceUUID);
        InternalProcessInstance instance = rootExecution.getInstance();
        Recorder recorder = EnvTool.getRecorder();
        Map<String, Variable> givenVariables = VariableUtil.createVariableMap(processUUID, variables);
        Map<String, Variable> processVariables = VariableUtil.createVariables(process.getDataFields(), null, variables);
        HashMap<String, Variable> initialVariables = new HashMap<String, Variable>();
        if (processVariables != null) {
            initialVariables.putAll(processVariables);
        }
        if (givenVariables != null) {
            initialVariables.putAll(givenVariables);
        }
        instance.setParentUUIDs(parentInstanceUUID, parentActivityUUID);
        instance.setInitialVaribales(initialVariables);
        String initiator = EnvTool.getUserId();
        if (parentInstanceUUID != null) {
            InternalProcessInstance parentInstance = EnvTool.getJournalQueriers().getProcessInstance(parentInstanceUUID);
            initiator = parentInstance.getStartedBy();
        }
        DocumentationManager manager = EnvTool.getDocumentationManager();
        HashSet<String> runtimeAttachmentNames = new HashSet<String>();
        if (attachments != null) {
            for (InitialAttachment attachment : attachments) {
                block23: {
                    try {
                        InternalProcessInstance rootProcessInstance;
                        Document createDocument;
                        byte[] content = attachment.getContent();
                        if (content != null) {
                            String mimeType = attachment.getMetaData().get("content-type");
                            if (mimeType == null) {
                                mimeType = "application/octet-stream";
                            }
                            createDocument = manager.createDocument(attachment.getName(), processUUID, instance.getUUID(), attachment.getFileName(), mimeType, content);
                        } else {
                            createDocument = manager.createDocument(attachment.getName(), processUUID, instance.getUUID());
                        }
                        if (rootInstanceUUID == null || rootInstanceUUID.equals(instance.getUUID()) || (rootProcessInstance = FacadeUtil.getInstance(rootInstanceUUID, null)) == null || rootProcessInstance.getProcessDefinitionUUID() == null) break block23;
                        try {
                            long nbOfDocuments = manager.getNbOfDocuments(rootProcessInstance.getProcessInstanceUUID(), createDocument.getName());
                            if (nbOfDocuments == 0L) {
                                manager.attachDocumentTo(rootProcessInstance.getProcessDefinitionUUID(), rootInstanceUUID, createDocument.getId());
                            }
                        }
                        catch (DocumentNotFoundException e) {
                            throw new BonitaRuntimeException(e);
                        }
                    }
                    catch (DocumentAlreadyExistsException e) {
                        throw new BonitaRuntimeException(e);
                    }
                    catch (DocumentationCreationException e) {
                        throw new BonitaRuntimeException(e);
                    }
                }
                runtimeAttachmentNames.add(attachment.getName());
            }
            instance.setNbOfAttachments(attachments.size());
        } else {
            instance.setNbOfAttachments(0);
        }
        Collection<AttachmentDefinition> values = process.getAttachments().values();
        if (values != null && !values.isEmpty()) {
            List<Document> documents = DocumentService.getDocuments(manager, processUUID);
            Document document = null;
            for (AttachmentDefinition attachmentDefinition : values) {
                Iterator<Document> iterator = documents.iterator();
                document = null;
                String attachmentName = attachmentDefinition.getName();
                if (runtimeAttachmentNames.contains(attachmentName)) continue;
                try {
                    while (iterator.hasNext() && document == null) {
                        Document next = iterator.next();
                        if (!attachmentName.equals(next.getName())) continue;
                        document = next;
                        iterator.remove();
                        break;
                    }
                    if (document == null) {
                        throw new BonitaRuntimeException("Cannot retrieve document");
                    }
                    byte[] content = manager.getContent(document);
                    manager.createDocument(attachmentDefinition.getName(), processUUID, instance.getUUID(), attachmentDefinition.getFileName(), "application/octet-stream", content);
                    int previousNbOfAttachments = instance.getNbOfAttachments();
                    if (previousNbOfAttachments <= 0) {
                        instance.setNbOfAttachments(1);
                        continue;
                    }
                    instance.setNbOfAttachments(previousNbOfAttachments + 1);
                }
                catch (Exception e) {
                    throw new BonitaRuntimeException(e);
                }
            }
        }
        recorder.recordInstanceStarted(instance, initiator);
        if (instance.getUUID().equals(instance.getRootInstanceUUID())) {
            EventService eventService = EnvTool.getEventService();
            eventService.lockRootInstance(instance.getUUID());
        }
        ConnectorExecutor.executeConnectors(rootExecution, HookDefinition.Event.instanceOnStart);
        return rootExecution;
    }

    public static void startEventSubProcesses(ProcessInstance instance) throws ProcessNotFoundException {
        ProcessInstanceUUID instanceUUID = instance.getUUID();
        InternalProcessDefinition process = FacadeUtil.getProcessDefinition(instance.getProcessDefinitionUUID());
        EventService eventService = EnvTool.getEventService();
        for (EventProcessDefinition eventSubProcess : process.getEventSubProcesses()) {
            IncomingEventDefinition event;
            String eventName;
            InternalProcessDefinition eventProcess = EnvTool.getJournalQueriers().getProcess(eventSubProcess.getName(), eventSubProcess.getVersion());
            if (eventProcess == null) {
                throw new ProcessNotFoundException("bs_PU_1", eventSubProcess.getName(), eventSubProcess.getVersion());
            }
            ActivityDefinition startEvent = ProcessUtil.getStartEvent(eventProcess);
            if (startEvent.isTimer()) {
                eventName = "**bonita_timer**-" + startEvent.getUUID();
                String condition = startEvent.getTimerCondition();
                try {
                    Date date = ProcessUtil.getTimerDate(condition, process.getUUID(), -1L);
                    long enableTime = date.getTime();
                    Job timer = JobBuilder.startTimerJob(eventName, startEvent.getUUID(), condition, enableTime);
                    timer.setEventSubProcessRootInstanceUUID(instanceUUID);
                    eventService.storeJob(timer);
                    continue;
                }
                catch (GroovyException e) {
                    throw new DeploymentRuntimeException(e.getMessage(), e.getCause());
                }
            }
            if (startEvent.isCatchingSignalEvent()) {
                eventName = startEvent.getTimerCondition();
                IncomingEventInstance signalEventInstance = new IncomingEventInstance(eventName, null, null, startEvent.getUUID(), null, eventProcess.getName(), startEvent.getName(), null, "event.start.signal", -1L, false);
                signalEventInstance.setPermanent(true);
                signalEventInstance.setEventSubProcessRootInstanceUUID(instanceUUID);
                eventService.subscribe(signalEventInstance);
                continue;
            }
            if (!startEvent.isReceiveEvent() || (event = startEvent.getIncomingEvent()) == null) continue;
            IncomingEventInstance eventInstance = new IncomingEventInstance(event.getName(), event.getExpression(), null, startEvent.getUUID(), null, eventProcess.getName(), startEvent.getName(), null, "event.start.message", System.currentTimeMillis(), false);
            eventInstance.setPermanent(true);
            eventInstance.setEventSubProcessRootInstanceUUID(instanceUUID);
            ProcessUtil.addCorrelationKeys((EventDefinition)event, (EventInstance)eventInstance, instance.getUUID());
            eventService.subscribe(eventInstance);
        }
    }

    private static ActivityDefinition getStartEvent(InternalProcessDefinition eventProcess) {
        for (ActivityDefinition activity : eventProcess.getActivities()) {
            if (!activity.getIncomingTransitions().isEmpty()) continue;
            return activity;
        }
        return null;
    }

    private static Execution createProcessInstance(InternalProcessDefinition process, ProcessInstanceUUID rootInstanceUUID) {
        ProcessDefinitionUUID processUUID = process.getUUID();
        long instanceNb = EnvTool.getUUIDService().getNewProcessInstanceNb(processUUID);
        ProcessInstanceUUID instanceUUID = new ProcessInstanceUUID(processUUID, instanceNb);
        ProcessInstanceUUID theRootInstanceUUID = null;
        theRootInstanceUUID = rootInstanceUUID == null ? instanceUUID : rootInstanceUUID;
        InternalProcessInstance instance = new InternalProcessInstance(instanceUUID, process, theRootInstanceUUID, instanceNb);
        Execution processInstance = instance.getRootExecution();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("creating new execution for process '" + process.getName() + "'");
        }
        return processInstance;
    }

    public static String getEvaluatedCorrelationKey(ProcessInstanceUUID processInstanceUUID, String correlationKeyName, String correlationKeyExpression) {
        if (correlationKeyExpression != null) {
            try {
                String expression = GroovyUtil.evaluate(correlationKeyExpression, null, processInstanceUUID, false, false).toString();
                return correlationKeyName.concat("||||").concat(expression);
            }
            catch (GroovyException e) {
                throw new BonitaRuntimeException(e);
            }
        }
        return null;
    }

    public static String getEvaluatedCorrelationKey(ProcessDefinitionUUID definitionUUID, String correlationKeyName, String correlationKeyExpression) {
        if (correlationKeyExpression != null) {
            try {
                String expression = GroovyUtil.evaluate(correlationKeyExpression, null, definitionUUID, false).toString();
                return correlationKeyName.concat("||||").concat(expression);
            }
            catch (GroovyException e) {
                throw new BonitaRuntimeException(e);
            }
        }
        return null;
    }

    public static void addCorrelationKeys(EventDefinition eventDefinition, EventInstance eventInstance, ProcessDefinitionUUID definitionUUID) {
        String correlationKey;
        String correlationKeyName = eventDefinition.getCorrelationKeyName1();
        if (correlationKeyName != null) {
            correlationKey = ProcessUtil.getEvaluatedCorrelationKey(definitionUUID, correlationKeyName, eventDefinition.getCorrelationKeyExpression1());
            eventInstance.setCorrelationKey1(correlationKey);
        }
        if ((correlationKeyName = eventDefinition.getCorrelationKeyName2()) != null) {
            correlationKey = ProcessUtil.getEvaluatedCorrelationKey(definitionUUID, correlationKeyName, eventDefinition.getCorrelationKeyExpression2());
            eventInstance.setCorrelationKey2(correlationKey);
        }
        if ((correlationKeyName = eventDefinition.getCorrelationKeyName3()) != null) {
            correlationKey = ProcessUtil.getEvaluatedCorrelationKey(definitionUUID, correlationKeyName, eventDefinition.getCorrelationKeyExpression3());
            eventInstance.setCorrelationKey3(correlationKey);
        }
        if ((correlationKeyName = eventDefinition.getCorrelationKeyName4()) != null) {
            correlationKey = ProcessUtil.getEvaluatedCorrelationKey(definitionUUID, correlationKeyName, eventDefinition.getCorrelationKeyExpression4());
            eventInstance.setCorrelationKey4(correlationKey);
        }
        if ((correlationKeyName = eventDefinition.getCorrelationKeyName5()) != null) {
            correlationKey = ProcessUtil.getEvaluatedCorrelationKey(definitionUUID, correlationKeyName, eventDefinition.getCorrelationKeyExpression5());
            eventInstance.setCorrelationKey5(correlationKey);
        }
    }

    public static void addCorrelationKeys(EventDefinition eventDefinition, EventInstance eventInstance, ProcessInstanceUUID instanceUUID) {
        String correlationKey;
        String correlationKeyName = eventDefinition.getCorrelationKeyName1();
        if (correlationKeyName != null) {
            correlationKey = ProcessUtil.getEvaluatedCorrelationKey(instanceUUID, correlationKeyName, eventDefinition.getCorrelationKeyExpression1());
            eventInstance.setCorrelationKey1(correlationKey);
        }
        if ((correlationKeyName = eventDefinition.getCorrelationKeyName2()) != null) {
            correlationKey = ProcessUtil.getEvaluatedCorrelationKey(instanceUUID, correlationKeyName, eventDefinition.getCorrelationKeyExpression2());
            eventInstance.setCorrelationKey2(correlationKey);
        }
        if ((correlationKeyName = eventDefinition.getCorrelationKeyName3()) != null) {
            correlationKey = ProcessUtil.getEvaluatedCorrelationKey(instanceUUID, correlationKeyName, eventDefinition.getCorrelationKeyExpression3());
            eventInstance.setCorrelationKey3(correlationKey);
        }
        if ((correlationKeyName = eventDefinition.getCorrelationKeyName4()) != null) {
            correlationKey = ProcessUtil.getEvaluatedCorrelationKey(instanceUUID, correlationKeyName, eventDefinition.getCorrelationKeyExpression4());
            eventInstance.setCorrelationKey4(correlationKey);
        }
        if ((correlationKeyName = eventDefinition.getCorrelationKeyName5()) != null) {
            correlationKey = ProcessUtil.getEvaluatedCorrelationKey(instanceUUID, correlationKeyName, eventDefinition.getCorrelationKeyExpression5());
            eventInstance.setCorrelationKey5(correlationKey);
        }
    }
}

