/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.ow2.bonita.util.ExceptionManager;

public class StandardCallbackHandler
implements CallbackHandler {
    private static final Logger LOG = Logger.getLogger(StandardCallbackHandler.class.getName());

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (LOG.isLoggable(Level.CONFIG)) {
            LOG.config("Using: " + this.getClass().getName() + " to request login informations.");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callback;
                switch (toc.getMessageType()) {
                    case 0: {
                        System.out.println(toc.getMessage());
                        break;
                    }
                    case 2: {
                        System.err.println("ERROR: " + toc.getMessage());
                        break;
                    }
                    case 1: {
                        System.err.println("WARNING: " + toc.getMessage());
                        break;
                    }
                    default: {
                        String message = ExceptionManager.getInstance().getFullMessage("buc_SCH_1", toc.getMessageType());
                        throw new IOException(message);
                    }
                }
                continue;
            }
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                System.out.println(nc.getPrompt());
                System.out.flush();
                nc.setName(this.getLineContent());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callback;
                System.out.println(pc.getPrompt());
                System.out.flush();
                String content = this.getLineContent();
                char[] charArray = content == null ? null : content.toCharArray();
                pc.setPassword(charArray);
                continue;
            }
            if (callback instanceof TextInputCallback) {
                TextInputCallback tic = (TextInputCallback)callback;
                System.out.println(tic.getPrompt());
                System.out.flush();
                tic.setText(this.getLineContent());
                continue;
            }
            String message = ExceptionManager.getInstance().getFullMessage("buc_SCH_2", new Object[0]);
            throw new UnsupportedCallbackException(callback, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLineContent() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        try {
            String string = reader.readLine();
            return string;
        }
        finally {
            reader.close();
        }
    }
}

