/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.connector.core;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.connector.core.AttachmentConverter;
import org.ow2.bonita.connector.core.Connector;
import org.ow2.bonita.connector.core.DocumentConverter;
import org.ow2.bonita.connector.core.desc.Array;
import org.ow2.bonita.connector.core.desc.Category;
import org.ow2.bonita.connector.core.desc.Checkbox;
import org.ow2.bonita.connector.core.desc.CompositeWidget;
import org.ow2.bonita.connector.core.desc.ConnectorDescriptor;
import org.ow2.bonita.connector.core.desc.Enumeration;
import org.ow2.bonita.connector.core.desc.Getter;
import org.ow2.bonita.connector.core.desc.Group;
import org.ow2.bonita.connector.core.desc.Page;
import org.ow2.bonita.connector.core.desc.Password;
import org.ow2.bonita.connector.core.desc.Radio;
import org.ow2.bonita.connector.core.desc.Select;
import org.ow2.bonita.connector.core.desc.Setter;
import org.ow2.bonita.connector.core.desc.SimpleList;
import org.ow2.bonita.connector.core.desc.Text;
import org.ow2.bonita.connector.core.desc.Textarea;
import org.ow2.bonita.definition.PerformerAssign;
import org.ow2.bonita.facade.runtime.AttachmentInstance;
import org.ow2.bonita.parsing.connector.ConnectorDescriptorParser;
import org.ow2.bonita.util.xml.Parse;
import org.w3c.dom.Document;

public final class ConnectorDescriptorAPI {
    private static final String CURRENT_VERSION = "5.0";
    private static final Logger LOG = Logger.getLogger(ConnectorDescriptorAPI.class.getName());
    private static XStream xstream;

    private ConnectorDescriptorAPI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ConnectorDescriptor load(Class<? extends Connector> c) {
        ConnectorDescriptorAPI.load();
        String descriptorPath = c.getSimpleName() + ".xml";
        InputStream input = null;
        try {
            ConnectorDescriptorParser parser = new ConnectorDescriptorParser();
            Parse parse = parser.createParse();
            input = c.getResourceAsStream(descriptorPath);
            parse.setInputStream(input);
            parse.setClassLoader(c.getClassLoader());
            ConnectorDescriptor connectorDescriptor = (ConnectorDescriptor)parse.execute().getDocumentObject();
            return connectorDescriptor;
        }
        catch (Throwable e) {
            ConnectorDescriptor connectorDescriptor = null;
            return connectorDescriptor;
        }
        finally {
            block12: {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {
                    if (!LOG.isLoggable(Level.SEVERE)) break block12;
                    LOG.severe(e.getMessage());
                }
            }
        }
    }

    private static synchronized void load() {
        if (xstream == null) {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            xstream.alias("connector", ConnectorDescriptor.class);
            xstream.alias("setter", Setter.class);
            xstream.alias("getter", Getter.class);
            xstream.alias("page", Page.class);
            xstream.alias("text", Text.class);
            xstream.alias("textarea", Textarea.class);
            xstream.alias("checkbox", Checkbox.class);
            xstream.alias("radio", Radio.class);
            xstream.alias("select", Select.class);
            xstream.alias("enumeration", Enumeration.class);
            xstream.alias("group", Group.class);
            xstream.alias("compositeWidget", CompositeWidget.class);
            xstream.alias("password", Password.class);
            xstream.alias("array", Array.class);
            xstream.alias("list", SimpleList.class);
            xstream.alias("perfomerAssign", PerformerAssign.class);
            xstream.alias("category", Category.class);
            xstream.aliasType("xml", Document.class);
            xstream.registerConverter((Converter)new DocumentConverter());
            xstream.aliasType("attachment", AttachmentInstance.class);
            xstream.registerConverter((Converter)new AttachmentConverter());
            xstream.omitField(Category.class, "classLoader");
            xstream.omitField(ConnectorDescriptor.class, "classLoader");
            xstream.setMode(1004);
        }
    }

    public static void save(ConnectorDescriptor descriptor, OutputStream output) {
        ConnectorDescriptorAPI.load();
        String version = descriptor.getVersion();
        if (!CURRENT_VERSION.equals(version)) {
            descriptor.setVersion(CURRENT_VERSION);
        }
        xstream.toXML((Object)descriptor, output);
    }
}

