/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.definition.activity.ActivityUtil;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ProcessUtil;

public class ThrowingErrorEvent
extends AbstractActivity {
    private static final long serialVersionUID = -7250991226062578318L;

    protected ThrowingErrorEvent() {
    }

    public ThrowingErrorEvent(String eventName) {
        super(eventName);
    }

    @Override
    protected boolean bodyStartAutomatically() {
        return true;
    }

    @Override
    protected boolean executeBusinessLogic(Execution execution) {
        InternalProcessInstance instance = execution.getInstance();
        InternalActivityDefinition activity = execution.getNode();
        Job errorJob = ActivityUtil.getErrorEventSubProcessJob(execution, activity.getTimerCondition());
        if (errorJob == null) {
            errorJob = ActivityUtil.getTargetErrorJob(execution);
        }
        execution.abort();
        Recorder recorder = EnvTool.getRecorder();
        recorder.recordInstanceAborted(instance.getUUID(), EnvTool.getUserId());
        if (errorJob != null) {
            EventService eventService = EnvTool.getEventService();
            eventService.storeJob(errorJob);
        } else {
            ProcessUtil.removeInternalInstanceEvents(instance.getUUID());
            instance.finish();
        }
        return false;
    }
}

