/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.exception.DeploymentException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.exception.RuleAlreadyExistsException;
import org.ow2.bonita.facade.exception.RuleNotFoundException;
import org.ow2.bonita.facade.exception.UndeletableInstanceException;
import org.ow2.bonita.facade.exception.UndeletableProcessException;
import org.ow2.bonita.facade.exception.UserNotFoundException;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.AbstractUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;

public interface ManagementAPI {
    public ProcessDefinition deploy(BusinessArchive var1) throws DeploymentException;

    public void deployJar(String var1, byte[] var2) throws DeploymentException;

    public void removeJar(String var1) throws DeploymentException;

    public void deleteProcess(ProcessDefinitionUUID var1) throws ProcessNotFoundException, UndeletableProcessException, UndeletableInstanceException;

    public void deleteAllProcesses() throws UndeletableInstanceException, UndeletableProcessException;

    public String getLoggedUser();

    public void addMetaData(String var1, String var2);

    public String getMetaData(String var1);

    public void deleteMetaData(String var1);

    public void disable(ProcessDefinitionUUID var1) throws DeploymentException;

    public void enable(ProcessDefinitionUUID var1) throws DeploymentException;

    public void archive(ProcessDefinitionUUID var1) throws DeploymentException;

    public void disable(Collection<ProcessDefinitionUUID> var1) throws DeploymentException;

    public void enable(Collection<ProcessDefinitionUUID> var1) throws DeploymentException;

    public void archive(Collection<ProcessDefinitionUUID> var1) throws DeploymentException;

    public void delete(Collection<ProcessDefinitionUUID> var1) throws ProcessNotFoundException, UndeletableProcessException, UndeletableInstanceException;

    public boolean isUserAdmin(String var1) throws UserNotFoundException;

    public boolean checkUserCredentials(String var1, String var2);

    public boolean checkUserCredentialsWithPasswordHash(String var1, String var2);

    public Set<String> getAvailableJars();

    public Rule createRule(String var1, String var2, String var3, Rule.RuleType var4) throws RuleAlreadyExistsException;

    public void deleteRuleByUUID(String var1) throws RuleNotFoundException;

    public <E extends AbstractUUID> void addExceptionsToRuleByUUID(String var1, Set<E> var2) throws RuleNotFoundException;

    public <E extends AbstractUUID> void removeExceptionsFromRuleByUUID(String var1, Set<E> var2) throws RuleNotFoundException;

    public Rule updateRuleByUUID(String var1, String var2, String var3, String var4) throws RuleNotFoundException, RuleAlreadyExistsException;

    public Rule getRuleByUUID(String var1) throws RuleNotFoundException;

    public void applyRuleToEntities(String var1, Collection<String> var2, Collection<String> var3, Collection<String> var4, Collection<String> var5, Collection<String> var6) throws RuleNotFoundException;

    public void removeRuleFromEntities(String var1, Collection<String> var2, Collection<String> var3, Collection<String> var4, Collection<String> var5, Collection<String> var6) throws RuleNotFoundException;

    public List<Rule> getAllRules();

    public List<Rule> getRules(Rule.RuleType var1, int var2, int var3);

    public long getNumberOfRules(Rule.RuleType var1);

    public List<Rule> getRulesByUUIDs(Collection<String> var1) throws RuleNotFoundException;

    public List<Rule> getApplicableRules(Rule.RuleType var1, String var2, Collection<String> var3, Collection<String> var4, Collection<String> var5, String var6);

    public List<Rule> getAllApplicableRules(String var1, Collection<String> var2, Collection<String> var3, Collection<String> var4, String var5);

    public PrivilegePolicy getRuleTypePolicy(Rule.RuleType var1);

    public void setRuleTypePolicy(Rule.RuleType var1, PrivilegePolicy var2);

    public void updateMigrationDate(ProcessDefinitionUUID var1, Date var2) throws ProcessNotFoundException;

    public void setResource(ProcessDefinitionUUID var1, String var2, byte[] var3) throws ProcessNotFoundException;
}

