/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.identity.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.ow2.bonita.facade.identity.ContactInfo;
import org.ow2.bonita.facade.identity.Membership;
import org.ow2.bonita.facade.identity.ProfileMetadata;
import org.ow2.bonita.facade.identity.User;
import org.ow2.bonita.facade.identity.impl.ContactInfoImpl;
import org.ow2.bonita.facade.identity.impl.MembershipImpl;
import org.ow2.bonita.facade.identity.impl.ProfileMetadataImpl;
import org.ow2.bonita.util.Misc;

public class UserImpl
implements User {
    private static final long serialVersionUID = 5357217264648978573L;
    protected long dbid;
    protected String uuid;
    protected String firstName;
    protected String lastName;
    protected String password;
    protected String username;
    protected String manager;
    protected String delegee;
    protected String title;
    protected String jobTitle;
    protected ContactInfo professionalContactInfo;
    protected ContactInfo personalContactInfo;
    protected Map<ProfileMetadata, String> metadata;
    protected Set<Membership> memberships;

    protected UserImpl() {
    }

    public UserImpl(String username, String password) {
        Misc.checkArgsNotNull(username, password);
        this.uuid = UUID.randomUUID().toString();
        this.username = username;
        this.password = password;
    }

    public UserImpl(String uuid, String username, String password) {
        Misc.checkArgsNotNull(uuid, username, password);
        this.uuid = uuid;
        this.username = username;
        this.password = password;
    }

    public UserImpl(UserImpl src) {
        Misc.checkArgsNotNull(src);
        this.uuid = src.getUUID();
        this.firstName = src.getFirstName();
        this.lastName = src.getLastName();
        this.password = src.getPassword();
        this.username = src.getUsername();
        this.title = src.getTitle();
        this.jobTitle = src.getJobTitle();
        this.manager = src.getManagerUUID();
        this.delegee = src.getDelegeeUUID();
        if (src.getPersonalContactInfo() != null) {
            this.personalContactInfo = new ContactInfoImpl((ContactInfoImpl)src.getPersonalContactInfo());
        }
        if (src.getProfessionalContactInfo() != null) {
            this.professionalContactInfo = new ContactInfoImpl((ContactInfoImpl)src.getProfessionalContactInfo());
        }
        this.memberships = new HashSet<Membership>();
        Set<Membership> memberships = src.getMemberships();
        for (Membership membership : memberships) {
            this.memberships.add(new MembershipImpl((MembershipImpl)membership));
        }
        this.metadata = new HashMap<ProfileMetadata, String>();
        Map<ProfileMetadata, String> metadata = src.getMetadata();
        for (Map.Entry<ProfileMetadata, String> entry : metadata.entrySet()) {
            this.metadata.put(new ProfileMetadataImpl((ProfileMetadataImpl)entry.getKey()), entry.getValue());
        }
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getJobTitle() {
        return this.jobTitle;
    }

    @Override
    public String getManagerUUID() {
        return this.manager;
    }

    @Override
    public String getDelegeeUUID() {
        return this.delegee;
    }

    @Override
    @Deprecated
    public String getEmail() {
        if (this.professionalContactInfo != null) {
            return this.professionalContactInfo.getEmail();
        }
        return null;
    }

    @Override
    public ContactInfo getPersonalContactInfo() {
        return this.personalContactInfo;
    }

    @Override
    public ContactInfo getProfessionalContactInfo() {
        return this.professionalContactInfo;
    }

    @Override
    public Map<ProfileMetadata, String> getMetadata() {
        if (this.metadata == null) {
            this.metadata = new HashMap<ProfileMetadata, String>();
        }
        return this.metadata;
    }

    @Override
    public Set<Membership> getMemberships() {
        if (this.memberships == null) {
            this.memberships = new HashSet<Membership>();
        }
        return this.memberships;
    }

    public void setEmail(String email) {
        if (this.professionalContactInfo == null) {
            this.professionalContactInfo = new ContactInfoImpl();
        }
        ((ContactInfoImpl)this.professionalContactInfo).setEmail(email);
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPersonalContactInfo(ContactInfo personalContactInfo) {
        this.personalContactInfo = personalContactInfo;
    }

    public void setProfessionalContactInfo(ContactInfo professionalContactInfo) {
        this.professionalContactInfo = professionalContactInfo;
    }

    public void setMetadata(Map<ProfileMetadata, String> metadata) {
        this.metadata = metadata;
    }

    public void setMemberships(Set<Membership> memberships) {
        this.memberships = memberships;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public void setManagerUUID(String manager) {
        this.manager = manager;
    }

    public void setDelegeeUUID(String delegee) {
        this.delegee = delegee;
    }
}

