/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.IdentityAPI;
import org.ow2.bonita.facade.exception.GroupAlreadyExistsException;
import org.ow2.bonita.facade.exception.GroupNotFoundException;
import org.ow2.bonita.facade.exception.MembershipNotFoundException;
import org.ow2.bonita.facade.exception.MetadataAlreadyExistsException;
import org.ow2.bonita.facade.exception.MetadataNotFoundException;
import org.ow2.bonita.facade.exception.RoleAlreadyExistsException;
import org.ow2.bonita.facade.exception.RoleNotFoundException;
import org.ow2.bonita.facade.exception.UserAlreadyExistsException;
import org.ow2.bonita.facade.exception.UserNotFoundException;
import org.ow2.bonita.facade.identity.Group;
import org.ow2.bonita.facade.identity.Membership;
import org.ow2.bonita.facade.identity.ProfileMetadata;
import org.ow2.bonita.facade.identity.Role;
import org.ow2.bonita.facade.identity.User;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.internal.AbstractRemoteIdentityAPI;
import org.ow2.bonita.facade.paging.GroupCriterion;
import org.ow2.bonita.facade.paging.RoleCriterion;
import org.ow2.bonita.facade.paging.UserCriterion;
import org.ow2.bonita.identity.auth.DomainOwner;
import org.ow2.bonita.identity.auth.PasswordOwner;
import org.ow2.bonita.identity.auth.RESTUserOwner;
import org.ow2.bonita.identity.auth.UserOwner;

public class AbstractRemoteIdentityAPIImpl
implements AbstractRemoteIdentityAPI {
    protected Map<String, IdentityAPI> apis = new HashMap<String, IdentityAPI>();

    protected IdentityAPI getAPI(Map<String, String> options) {
        if (options == null) {
            throw new IllegalArgumentException("The options are null or not well set.");
        }
        String queryList = options.get("queryList");
        String user = options.get("user");
        String domain = options.get("domain");
        UserOwner.setUser(user);
        DomainOwner.setDomain(domain);
        String restUser = options.get("restUser");
        if (restUser != null) {
            RESTUserOwner.setUser(restUser);
            String restPswd = options.get("passwordHash");
            PasswordOwner.setPassword(restPswd);
        }
        if (!this.apis.containsKey(queryList)) {
            this.apis.put(queryList, new StandardAPIAccessorImpl().getIdentityAPI(queryList));
        }
        return this.apis.get(queryList);
    }

    @Override
    public Role addRole(String name, Map<String, String> options) throws RemoteException, RoleAlreadyExistsException {
        return this.getAPI(options).addRole(name);
    }

    @Override
    public Role addRole(String name, String label, String description, Map<String, String> options) throws RemoteException, RoleAlreadyExistsException {
        return this.getAPI(options).addRole(name, label, description);
    }

    @Override
    @Deprecated
    public void addRoleToUser(String roleName, String username, Map<String, String> options) throws RemoteException, UserNotFoundException, RoleNotFoundException {
        this.getAPI(options).addRoleToUser(roleName, username);
    }

    @Override
    @Deprecated
    public void setUserRoles(String username, Set<String> roleNames, Map<String, String> options) throws RemoteException, UserNotFoundException, RoleNotFoundException {
        this.getAPI(options).setUserRoles(username, roleNames);
    }

    @Override
    public User addUser(String username, String password, Map<String, String> options) throws RemoteException, UserAlreadyExistsException {
        return this.getAPI(options).addUser(username, password);
    }

    @Override
    @Deprecated
    public User addUser(String username, String password, String firstName, String lastName, String email, Map<String, String> options) throws RemoteException, UserAlreadyExistsException {
        return this.getAPI(options).addUser(username, password, firstName, lastName, email);
    }

    @Override
    @Deprecated
    public Role getRole(String name, Map<String, String> options) throws RemoteException, RoleNotFoundException {
        return this.getAPI(options).getRole(name);
    }

    @Override
    @Deprecated
    public Set<Role> getRoles(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getRoles();
    }

    @Override
    @Deprecated
    public User getUser(String username, Map<String, String> options) throws RemoteException, UserNotFoundException {
        return this.getAPI(options).getUser(username);
    }

    @Override
    @Deprecated
    public Set<Role> getUserRoles(String username, Map<String, String> options) throws RemoteException, UserNotFoundException {
        return this.getAPI(options).getUserRoles(username);
    }

    @Override
    @Deprecated
    public Set<User> getUsers(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getUsers();
    }

    @Override
    @Deprecated
    public Set<User> getUsersInRole(String name, Map<String, String> options) throws RemoteException, RoleNotFoundException {
        return this.getAPI(options).getUsersInRole(name);
    }

    @Override
    @Deprecated
    public void removeRole(String name, Map<String, String> options) throws RemoteException, RoleNotFoundException {
        this.getAPI(options).removeRole(name);
    }

    @Override
    @Deprecated
    public void removeRoleFromUser(String roleName, String username, Map<String, String> options) throws RemoteException, UserNotFoundException, RoleNotFoundException {
        this.getAPI(options).removeRoleFromUser(roleName, username);
    }

    @Override
    @Deprecated
    public void removeUser(String username, Map<String, String> options) throws RemoteException, UserNotFoundException {
        this.getAPI(options).removeUser(username);
    }

    @Override
    @Deprecated
    public Role updateRole(String oldName, String name, String label, String description, Map<String, String> options) throws RemoteException, RoleNotFoundException, RoleAlreadyExistsException {
        return this.getAPI(options).updateRole(oldName, name, label, description);
    }

    @Override
    @Deprecated
    public User updateUser(String oldUsername, String username, String password, String firstName, String lastName, String email, Map<String, String> options) throws RemoteException, UserNotFoundException, UserAlreadyExistsException {
        return this.getAPI(options).updateUser(oldUsername, username, password, firstName, lastName, email);
    }

    @Override
    public User updateUserPassword(String userUUID, String password, Map<String, String> options) throws RemoteException, UserNotFoundException {
        return this.getAPI(options).updateUserPassword(userUUID, password);
    }

    @Override
    public Group addGroup(String name, String parentGroupUUID, Map<String, String> options) throws RemoteException, GroupAlreadyExistsException, GroupNotFoundException {
        return this.getAPI(options).addGroup(name, parentGroupUUID);
    }

    @Override
    public Group addGroup(String name, String label, String description, String parentGroupUUID, Map<String, String> options) throws RemoteException, GroupAlreadyExistsException, GroupNotFoundException {
        return this.getAPI(options).addGroup(name, label, description, parentGroupUUID);
    }

    @Override
    public void addMembershipToUser(String userUUID, String membershipUUID, Map<String, String> options) throws RemoteException, UserNotFoundException, MembershipNotFoundException {
        this.getAPI(options).addMembershipToUser(userUUID, membershipUUID);
    }

    @Override
    public ProfileMetadata addProfileMetadata(String name, Map<String, String> options) throws RemoteException, MetadataAlreadyExistsException {
        return this.getAPI(options).addProfileMetadata(name);
    }

    @Override
    public ProfileMetadata addProfileMetadata(String name, String label, Map<String, String> options) throws RemoteException, MetadataAlreadyExistsException {
        return this.getAPI(options).addProfileMetadata(name, label);
    }

    @Override
    public User addUser(String username, String password, String firstName, String lastName, String title, String jobTitle, String managerUserUUID, Map<String, String> profileMetadata, Map<String, String> options) throws RemoteException, UserAlreadyExistsException, UserNotFoundException, MetadataNotFoundException {
        return this.getAPI(options).addUser(username, password, firstName, lastName, title, jobTitle, managerUserUUID, profileMetadata);
    }

    @Override
    public ProfileMetadata findProfileMetadataByName(String metadataName, Map<String, String> options) throws RemoteException, MetadataNotFoundException {
        return this.getAPI(options).findProfileMetadataByName(metadataName);
    }

    @Override
    public Role findRoleByName(String name, Map<String, String> options) throws RemoteException, RoleNotFoundException {
        return this.getAPI(options).findRoleByName(name);
    }

    @Override
    public User findUserByUserName(String username, Map<String, String> options) throws RemoteException, UserNotFoundException {
        return this.getAPI(options).findUserByUserName(username);
    }

    @Override
    public List<Group> getAllGroups(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getAllGroups();
    }

    @Override
    public List<ProfileMetadata> getAllProfileMetadata(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getAllProfileMetadata();
    }

    @Override
    public List<Role> getAllRoles(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getAllRoles();
    }

    @Override
    public List<User> getAllUsers(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getAllUsers();
    }

    @Override
    public List<User> getAllUsersInGroup(String groupUUID, Map<String, String> options) throws RemoteException, GroupNotFoundException {
        return this.getAPI(options).getAllUsersInGroup(groupUUID);
    }

    @Override
    public List<User> getAllUsersInMembership(String membershipUUID, Map<String, String> options) throws RemoteException, MembershipNotFoundException {
        return this.getAPI(options).getAllUsersInMembership(membershipUUID);
    }

    @Override
    public List<User> getAllUsersInRole(String roleUUID, Map<String, String> options) throws RemoteException, RoleNotFoundException {
        return this.getAPI(options).getAllUsersInRole(roleUUID);
    }

    @Override
    public List<User> getAllUsersInRoleAndGroup(String roleUUID, String groupUUID, Map<String, String> options) throws RemoteException, RoleNotFoundException, GroupNotFoundException {
        return this.getAPI(options).getAllUsersInRoleAndGroup(roleUUID, groupUUID);
    }

    @Override
    public List<Group> getChildrenGroupsByUUID(String groupUUID, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getChildrenGroupsByUUID(groupUUID);
    }

    @Override
    public List<Group> getChildrenGroups(String groupUUID, int fromIndex, int numberOfGroups, Map<String, String> options) throws RemoteException, GroupNotFoundException {
        return this.getAPI(options).getChildrenGroups(groupUUID, fromIndex, numberOfGroups);
    }

    @Override
    public List<Group> getChildrenGroups(String groupUUID, int fromIndex, int numberOfGroups, GroupCriterion pagingCriterion, Map<String, String> options) throws GroupNotFoundException, RemoteException {
        return this.getAPI(options).getChildrenGroups(groupUUID, fromIndex, numberOfGroups, pagingCriterion);
    }

    @Override
    public int getNumberOfChildrenGroups(String groupUUID, Map<String, String> options) throws RemoteException, GroupNotFoundException {
        return this.getAPI(options).getNumberOfChildrenGroups(groupUUID);
    }

    @Override
    public Group getGroupByUUID(String groupUUID, Map<String, String> options) throws RemoteException, GroupNotFoundException {
        return this.getAPI(options).getGroupByUUID(groupUUID);
    }

    @Override
    public List<Group> getGroups(int fromIndex, int numberOfGroups, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getGroups(fromIndex, numberOfGroups);
    }

    @Override
    public List<Group> getGroups(int fromIndex, int numberOfGroups, GroupCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getGroups(fromIndex, numberOfGroups, pagingCriterion);
    }

    @Override
    public Membership getMembershipByUUID(String membershipUUID, Map<String, String> options) throws RemoteException, MembershipNotFoundException {
        return this.getAPI(options).getMembershipByUUID(membershipUUID);
    }

    @Override
    public Membership getMembershipForRoleAndGroup(String roleUUID, String groupUUID, Map<String, String> options) throws RemoteException, RoleNotFoundException, GroupNotFoundException {
        return this.getAPI(options).getMembershipForRoleAndGroup(roleUUID, groupUUID);
    }

    @Override
    public int getNumberOfGroups(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfGroups();
    }

    @Override
    public int getNumberOfRoles(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfRoles();
    }

    @Override
    public int getNumberOfUsers(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfUsers();
    }

    @Override
    public int getNumberOfUsersInGroup(String groupUUID, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfUsersInGroup(groupUUID);
    }

    @Override
    public int getNumberOfUsersInRole(String roleUUID, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfUsersInRole(roleUUID);
    }

    @Override
    public ProfileMetadata getProfileMetadataByUUID(String metadataUUID, Map<String, String> options) throws RemoteException, MetadataNotFoundException {
        return this.getAPI(options).getProfileMetadataByUUID(metadataUUID);
    }

    @Override
    public List<ProfileMetadata> getProfileMetadata(int fromIndex, int numberOfMetadata, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getProfileMetadata(fromIndex, numberOfMetadata);
    }

    @Override
    public int getNumberOfProfileMetadata(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfProfileMetadata();
    }

    @Override
    public Role getRoleByUUID(String roleUUID, Map<String, String> options) throws RemoteException, RoleNotFoundException {
        return this.getAPI(options).getRoleByUUID(roleUUID);
    }

    @Override
    public List<Role> getRoles(int fromIndex, int numberOfRoles, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getRoles(fromIndex, numberOfRoles);
    }

    @Override
    public List<Role> getRoles(int fromIndex, int numberOfRoles, RoleCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getRoles(fromIndex, numberOfRoles, pagingCriterion);
    }

    @Override
    public User getUserByUUID(String userUUID, Map<String, String> options) throws RemoteException, UserNotFoundException {
        return this.getAPI(options).getUserByUUID(userUUID);
    }

    @Override
    public List<User> getUsers(int fromIndex, int numberOfUsers, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getUsers(fromIndex, numberOfUsers);
    }

    @Override
    public List<User> getUsers(int fromIndex, int numberOfUsers, UserCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getUsers(fromIndex, numberOfUsers, pagingCriterion);
    }

    @Override
    public List<User> getUsersInGroup(String groupUUID, int fromIndex, int numberOfUsers, Map<String, String> options) throws RemoteException, GroupNotFoundException {
        return this.getAPI(options).getUsersInGroup(groupUUID, fromIndex, numberOfUsers);
    }

    @Override
    public List<User> getUsersInGroup(String groupUUID, int fromIndex, int numberOfUsers, UserCriterion pagingCriterion, Map<String, String> options) throws GroupNotFoundException, RemoteException {
        return this.getAPI(options).getUsersInGroup(groupUUID, fromIndex, numberOfUsers, pagingCriterion);
    }

    @Override
    public List<User> getUsersInRole(String roleUUID, int fromIndex, int numberOfUsers, Map<String, String> options) throws RemoteException, RoleNotFoundException {
        return this.getAPI(options).getUsersInRole(roleUUID, fromIndex, numberOfUsers);
    }

    @Override
    public List<User> getUsersInRole(String roleUUID, int fromIndex, int numberOfUsers, UserCriterion pagingCriterion, Map<String, String> options) throws RoleNotFoundException, RemoteException {
        return this.getAPI(options).getUsersInRole(roleUUID, fromIndex, numberOfUsers, pagingCriterion);
    }

    @Override
    public void removeGroupByUUID(String groupUUID, Map<String, String> options) throws RemoteException, GroupNotFoundException {
        this.getAPI(options).removeGroupByUUID(groupUUID);
    }

    @Override
    public void removeMembershipFromUser(String userUUID, String membershipUUID, Map<String, String> options) throws RemoteException, UserNotFoundException, MembershipNotFoundException {
        this.getAPI(options).removeMembershipFromUser(userUUID, membershipUUID);
    }

    @Override
    public void removeProfileMetadataByUUID(String profileMetadataUUID, Map<String, String> options) throws RemoteException, MetadataNotFoundException {
        this.getAPI(options).removeProfileMetadataByUUID(profileMetadataUUID);
    }

    @Override
    public void removeRoleByUUID(String roleUUID, Map<String, String> options) throws RemoteException, RoleNotFoundException {
        this.getAPI(options).removeRoleByUUID(roleUUID);
    }

    @Override
    public void removeUserByUUID(String userUUID, Map<String, String> options) throws RemoteException, UserNotFoundException {
        this.getAPI(options).removeUserByUUID(userUUID);
    }

    @Override
    public Group updateGroupByUUID(String groupUUID, String name, String label, String description, String parentGroupUUID, Map<String, String> options) throws RemoteException, GroupNotFoundException, GroupAlreadyExistsException {
        return this.getAPI(options).updateGroupByUUID(groupUUID, name, label, description, parentGroupUUID);
    }

    @Override
    public ProfileMetadata updateProfileMetadataByUUID(String profileMetadataUUID, String name, String label, Map<String, String> options) throws RemoteException, MetadataNotFoundException, MetadataAlreadyExistsException {
        return this.getAPI(options).updateProfileMetadataByUUID(profileMetadataUUID, name, label);
    }

    @Override
    public Role updateRoleByUUID(String roleUUID, String name, String label, String description, Map<String, String> options) throws RemoteException, RoleNotFoundException, RoleAlreadyExistsException {
        return this.getAPI(options).updateRoleByUUID(roleUUID, name, label, description);
    }

    @Override
    public User updateUserByUUID(String userUUID, String username, String firstName, String lastName, String title, String jobTitle, String managerUserUUID, Map<String, String> profileMetadata, Map<String, String> options) throws RemoteException, UserNotFoundException, UserAlreadyExistsException, MetadataNotFoundException {
        return this.getAPI(options).updateUserByUUID(userUUID, username, firstName, lastName, title, jobTitle, managerUserUUID, profileMetadata);
    }

    @Override
    public void updateUserDelegee(String userUUID, String delegeeUserUUID, Map<String, String> options) throws RemoteException, UserNotFoundException {
        this.getAPI(options).updateUserDelegee(userUUID, delegeeUserUUID);
    }

    @Override
    public void updateUserPersonalContactInfo(String userUUID, String email, String phoneNumber, String mobileNumber, String faxNumber, String building, String room, String address, String zipCode, String city, String state, String country, String website, Map<String, String> options) throws RemoteException, UserNotFoundException {
        this.getAPI(options).updateUserPersonalContactInfo(userUUID, email, phoneNumber, mobileNumber, faxNumber, building, room, address, zipCode, city, state, country, website);
    }

    @Override
    public void updateUserProfessionalContactInfo(String userUUID, String email, String phoneNumber, String mobileNumber, String faxNumber, String building, String room, String address, String zipCode, String city, String state, String country, String website, Map<String, String> options) throws RemoteException, UserNotFoundException {
        this.getAPI(options).updateUserProfessionalContactInfo(userUUID, email, phoneNumber, mobileNumber, faxNumber, building, room, address, zipCode, city, state, country, website);
    }

    @Override
    public List<User> getUsersByManagerUUID(String managerUUID, Map<String, String> options) throws RemoteException, UserNotFoundException {
        return this.getAPI(options).getUsersByManagerUUID(managerUUID);
    }

    @Override
    public User importUser(String userUUID, String username, String passwordHash, String firstName, String lastName, String title, String jobTitle, String managerUserUUID, Map<String, String> profileMetadata, Map<String, String> options) throws RemoteException, UserAlreadyExistsException, MetadataNotFoundException {
        return this.getAPI(options).importUser(userUUID, username, passwordHash, firstName, lastName, title, jobTitle, managerUserUUID, profileMetadata);
    }

    @Override
    public Group importGroup(String uuid, String name, String label, String description, String parentGroupUUID, Map<String, String> options) throws RemoteException, GroupAlreadyExistsException, GroupNotFoundException {
        return this.getAPI(options).importGroup(uuid, name, label, description, parentGroupUUID);
    }

    @Override
    public Role importRole(String uuid, String name, String label, String description, Map<String, String> options) throws RemoteException, RoleAlreadyExistsException {
        return this.getAPI(options).importRole(uuid, name, label, description);
    }

    @Override
    public Boolean groupExists(String groupUUID, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).groupExists(groupUUID);
    }

    @Override
    public Group getGroupUsingPath(List<String> path, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getGroupUsingPath(path);
    }
}

