/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.Document;
import org.ow2.bonita.facade.uuid.DocumentUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.search.DocumentResult;
import org.ow2.bonita.search.DocumentSearchBuilder;
import org.ow2.bonita.search.index.DocumentIndex;
import org.ow2.bonita.util.Command;

public class WebDeleteDocumentsOfProcessInstancesCommand
implements Command<Void> {
    private static final long serialVersionUID = 1L;
    private final Set<ProcessInstanceUUID> instancesUUIDs;

    public WebDeleteDocumentsOfProcessInstancesCommand(Set<ProcessInstanceUUID> instancesUUIDs) {
        this.instancesUUIDs = instancesUUIDs;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        if (this.instancesUUIDs != null && !this.instancesUUIDs.isEmpty()) {
            HashSet<ProcessInstanceUUID> uuids = new HashSet<ProcessInstanceUUID>();
            HashSet<String> instanceUuidsAsString = new HashSet<String>();
            for (ProcessInstanceUUID uuid : this.instancesUUIDs) {
                uuids.add(uuid);
                instanceUuidsAsString.add(uuid.getValue());
                if (uuids.size() != 100) continue;
                this.deleteDocumentsOfCases(instanceUuidsAsString);
                uuids.clear();
                instanceUuidsAsString.clear();
            }
            this.deleteDocumentsOfCases(instanceUuidsAsString);
        }
        return null;
    }

    private void deleteDocumentsOfCases(Set<String> uuids) throws DocumentNotFoundException {
        DocumentResult searchResult;
        DocumentSearchBuilder documentSearchBuilder = new DocumentSearchBuilder();
        documentSearchBuilder.criterion(DocumentIndex.PROCESS_INSTANCE_UUID).in(uuids);
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        QueryRuntimeAPI queryRuntimeAPI = accessor.getQueryRuntimeAPI();
        RuntimeAPI runtimeAPI = accessor.getRuntimeAPI();
        do {
            searchResult = queryRuntimeAPI.searchDocuments(documentSearchBuilder, 0, 100);
            List<Document> documentsFound = searchResult.getDocuments();
            DocumentUUID[] documentsToDelete = new DocumentUUID[documentsFound.size()];
            int i = 0;
            for (Document document : documentsFound) {
                documentsToDelete[i] = document.getUUID();
                ++i;
            }
            runtimeAPI.deleteDocuments(true, documentsToDelete);
        } while (searchResult.getCount() > 0);
    }
}

