/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.identity.auth;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ow2.bonita.identity.auth.BadLoginOptionException;
import org.ow2.bonita.identity.auth.BonitaPrincipal;
import org.ow2.bonita.identity.auth.BonitaPrincipalRole;
import org.ow2.bonita.identity.auth.MissingOptionException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

public class BonitaRESTServerLoginModule
implements LoginModule {
    private static final String NAME_PROMPT = "Name: ";
    private static final String PASSWORD_PROMPT = "Password: ";
    private static final String JAVAX_SECURITY_AUTH_LOGIN_PASSWORD = "javax.security.auth.login.password";
    private static final String JAVAX_SECURITY_AUTH_LOGIN_NAME = "javax.security.auth.login.name";
    public static final String DEBUG_OPTION_NAME = "debug";
    private static final String LOGINS_OPTION_NAME = "logins";
    private static final String PASSWORDS_OPTION_NAME = "passwords";
    private static final String ROLES_OPTION_NAME = "roles";
    private Subject subject = null;
    private CallbackHandler callbackHandler = null;
    protected Map<String, Object> sharedState;
    private Map<String, Object> options = null;
    private boolean debug = false;
    private String id;
    private String role;
    private List<String> logins;
    private List<String> passwords;
    private List<String> roles;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        Misc.checkArgsNotNull(subject, callbackHandler, sharedState, options);
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        String debugFlag = (String)options.get(DEBUG_OPTION_NAME);
        if (debugFlag != null) {
            this.debug = Boolean.valueOf(debugFlag);
        }
        this.options = options;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.debug) {
            System.err.println("[" + BonitaRESTServerLoginModule.class.getName() + "] login() - preparing - step 1");
        }
        this.processUsersPasswordsAndRoles();
        try {
            int i;
            String name = (String)this.sharedState.get(JAVAX_SECURITY_AUTH_LOGIN_NAME);
            String password = (String)this.sharedState.get(JAVAX_SECURITY_AUTH_LOGIN_PASSWORD);
            ArrayList<Callback> callbacks = new ArrayList<Callback>();
            NameCallback nameCallback = new NameCallback(NAME_PROMPT);
            PasswordCallback passwordCallback = new PasswordCallback(PASSWORD_PROMPT, false);
            if (name == null) {
                callbacks.add(nameCallback);
            }
            if (password == null) {
                callbacks.add(passwordCallback);
            }
            if (!callbacks.isEmpty()) {
                if (this.debug) {
                    System.err.println("[" + BonitaRESTServerLoginModule.class.getName() + "] login() - callback - step 2");
                }
                this.callbackHandler.handle(callbacks.toArray(new Callback[0]));
                if (name == null) {
                    name = nameCallback.getName();
                }
                if (password == null) {
                    password = new String(passwordCallback.getPassword());
                    passwordCallback.clearPassword();
                }
            }
            if (this.debug) {
                System.err.println("[" + BonitaRESTServerLoginModule.class.getName() + "] login() - authenticating - step 3");
            }
            if ((i = this.logins.indexOf(name)) != -1 && (this.passwords.get(i).equals(password) || this.passwords.get(i).equals(Misc.hash(password)))) {
                this.id = name;
                this.role = this.roles.get(i);
            }
            if (this.debug) {
                System.err.println("[" + BonitaRESTServerLoginModule.class.getName() + "] login() - storing data - step 4");
            }
            this.sharedState.put(JAVAX_SECURITY_AUTH_LOGIN_NAME, name);
            this.sharedState.put(JAVAX_SECURITY_AUTH_LOGIN_PASSWORD, password);
            if (this.debug) {
                System.err.println("[" + BonitaRESTServerLoginModule.class.getName() + "] login() - returning - step 5");
            }
            if (this.id == null) {
                String message = ExceptionManager.getInstance().getFullMessage("bi_LSLM_1", new Object[0]);
                throw new FailedLoginException(message);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
    }

    private void processUsersPasswordsAndRoles() throws BadLoginOptionException, MissingOptionException {
        if (this.logins == null) {
            String loginList = (String)this.options.get(LOGINS_OPTION_NAME);
            String passwordList = (String)this.options.get(PASSWORDS_OPTION_NAME);
            String rolesList = (String)this.options.get(ROLES_OPTION_NAME);
            if (loginList == null) {
                String message = ExceptionManager.getInstance().getFullMessage("bi_PLM_1", LOGINS_OPTION_NAME);
                throw new MissingOptionException("bi_PLM_1", message);
            }
            if (passwordList == null) {
                String message = ExceptionManager.getInstance().getFullMessage("bi_PLM_2", PASSWORDS_OPTION_NAME);
                throw new MissingOptionException("bi_PLM_2", message);
            }
            if (rolesList == null) {
                String message = ExceptionManager.getInstance().getFullMessage("bi_PLM_7", ROLES_OPTION_NAME);
                throw new MissingOptionException("bi_PLM_7", message);
            }
            StringTokenizer loginTokenizer = new StringTokenizer(loginList, ",");
            StringTokenizer passwordTokenizer = new StringTokenizer(passwordList, ",");
            StringTokenizer roleTokenizer = new StringTokenizer(rolesList, ",");
            if (loginTokenizer.countTokens() != passwordTokenizer.countTokens()) {
                String message = ExceptionManager.getInstance().getFullMessage("bi_PLM_8", new Object[0]);
                throw new BadLoginOptionException(message);
            }
            if (loginTokenizer.countTokens() != roleTokenizer.countTokens()) {
                String message = ExceptionManager.getInstance().getFullMessage("bi_PLM_8", new Object[0]);
                throw new BadLoginOptionException(message);
            }
            this.logins = new ArrayList<String>();
            this.passwords = new ArrayList<String>();
            this.roles = new ArrayList<String>();
            while (loginTokenizer.hasMoreTokens()) {
                String name = loginTokenizer.nextToken().trim();
                if (this.logins.contains(name)) {
                    String message = ExceptionManager.getInstance().getFullMessage("bi_PLM_4", name);
                    throw new BadLoginOptionException(message);
                }
                String password = passwordTokenizer.nextToken().trim();
                String role = roleTokenizer.nextToken().trim();
                this.logins.add(name);
                this.passwords.add(Misc.hash(password));
                this.roles.add(role);
            }
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.id == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bi_PLM_6", new Object[0]);
            throw new FailedLoginException(message);
        }
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(new BonitaPrincipal(this.id));
        principals.add(new BonitaPrincipalRole(this.role));
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.err.println("[" + BonitaRESTServerLoginModule.class.getName() + "] abort()");
        }
        if (this.id == null) {
            return false;
        }
        this.subject = null;
        this.id = null;
        this.role = null;
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.id != null) {
            if (this.debug) {
                System.err.println("[" + BonitaRESTServerLoginModule.class.getName() + "] logout() - removing principals");
            }
            HashSet<Principal> principals = new HashSet<Principal>(this.subject.getPrincipals());
            for (Principal p : principals) {
                if (p instanceof BonitaPrincipal) {
                    if (this.debug) {
                        System.err.println("[" + BonitaRESTServerLoginModule.class.getName() + "] logout() - removing principal: " + p);
                    }
                    this.subject.getPrincipals().remove(p);
                }
                if (!(p instanceof BonitaPrincipalRole)) continue;
                if (this.debug) {
                    System.err.println("[" + BonitaRESTServerLoginModule.class.getName() + "] logout() - removing role: " + p);
                }
                this.subject.getPrincipals().remove(p);
            }
            if (this.debug) {
                System.err.println("[" + BonitaRESTServerLoginModule.class.getName() + "] logout() - destroying/removing credentials");
            }
            HashSet<Object> credentials = new HashSet<Object>(this.subject.getPublicCredentials());
            for (Object e : credentials) {
                if (e instanceof Destroyable && this.debug) {
                    System.err.println("[" + BonitaRESTServerLoginModule.class.getName() + "] logout() - destroying credential: " + e);
                }
                if (this.subject.isReadOnly()) continue;
                if (this.debug) {
                    System.err.println("[" + BonitaRESTServerLoginModule.class.getName() + "] logout() - removing credential: " + e);
                }
                this.subject.getPublicCredentials().remove(e);
            }
        }
        return true;
    }
}

