/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.light.impl;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.NamedElementImpl;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.util.Misc;

public class LightProcessDefinitionImpl
extends NamedElementImpl
implements LightProcessDefinition {
    private static final long serialVersionUID = -572795239631090498L;
    protected ProcessDefinitionUUID uuid;
    protected String version;
    protected ProcessDefinition.ProcessState state;
    protected LightProcessDefinition.ProcessType type;
    protected long deployedDate;
    protected long undeployedDate;
    protected String deployedBy;
    protected String undeployedBy;
    protected Set<String> categories;
    protected long migrationDate;

    protected LightProcessDefinitionImpl() {
    }

    public LightProcessDefinitionImpl(ProcessDefinition src) {
        super(src);
        this.uuid = new ProcessDefinitionUUID(src.getUUID());
        this.state = src.getState();
        this.type = src.getType();
        this.version = src.getVersion();
        this.deployedDate = Misc.getTime(src.getDeployedDate());
        this.undeployedDate = Misc.getTime(src.getUndeployedDate());
        this.deployedBy = src.getDeployedBy();
        this.undeployedBy = src.getUndeployedBy();
        this.categories = null;
        if (src.getCategoryNames() != null) {
            this.categories = new HashSet<String>(src.getCategoryNames());
        }
        this.migrationDate = Misc.getTime(src.getMigrationDate());
    }

    protected LightProcessDefinitionImpl(String name, String version) {
        super(name);
        Misc.checkArgsNotNull(name, version);
        this.version = version;
        if (this.version == null) {
            this.version = "1.0";
        }
        this.uuid = new ProcessDefinitionUUID(name, version);
        this.type = LightProcessDefinition.ProcessType.PROCESS;
    }

    public String toString() {
        String st = this.getClass().getName() + "[uuid: " + this.getUUID() + ", name:" + this.getName() + ", description:" + this.getDescription() + ", version:" + this.getVersion();
        st = st + "]";
        return st;
    }

    @Override
    public ProcessDefinition.ProcessState getState() {
        return this.state;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public ProcessDefinitionUUID getUUID() {
        return this.uuid;
    }

    @Override
    public Date getDeployedDate() {
        return Misc.getDate(this.deployedDate);
    }

    @Override
    public String getDeployedBy() {
        return this.deployedBy;
    }

    @Override
    public Date getUndeployedDate() {
        return Misc.getDate(this.undeployedDate);
    }

    @Override
    public String getUndeployedBy() {
        return this.undeployedBy;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        LightProcessDefinitionImpl other = (LightProcessDefinitionImpl)obj;
        return other.getUUID().equals(this.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    @Override
    public Set<String> getCategoryNames() {
        if (this.categories == null) {
            return Collections.emptySet();
        }
        return this.categories;
    }

    @Override
    public LightProcessDefinition.ProcessType getType() {
        return this.type;
    }

    @Override
    public Date getMigrationDate() {
        return Misc.getDate(this.migrationDate);
    }

    public void setMigrationDate(Date migrationDate) {
        this.migrationDate = Misc.getTime(migrationDate);
    }
}

