/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.def.binding;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.parsing.def.binding.ElementBinding;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class DataFieldBinding
extends ElementBinding {
    private static final Logger LOGGER = Logger.getLogger(DataFieldBinding.class.getName());

    public DataFieldBinding() {
        super("data-field");
    }

    @Override
    public Object parse(Element datafieldElement, Parse parse, Parser parser) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("parsing element = " + datafieldElement);
        }
        String name = null;
        try {
            boolean isTransientValue;
            ProcessBuilder processBuilder = parse.findObject(ProcessBuilder.class);
            name = XmlUtil.attribute(datafieldElement, "name");
            String label = this.getChildTextContent(datafieldElement, "label");
            String description = this.getChildTextContent(datafieldElement, "description");
            String dataTypeClassName = this.getChildTextContent(datafieldElement, "datatype-classname");
            String initialValue = this.getChildTextContent(datafieldElement, "value");
            String scriptingValue = this.getChildTextContent(datafieldElement, "scripting-value");
            String isTransient = this.getChildTextContent(datafieldElement, "is-transient");
            Element enumerationValuesElement = XmlUtil.element(datafieldElement, "enumeration-values");
            List<Element> enumerationValueElements = XmlUtil.elements(enumerationValuesElement, "enumeration-value");
            HashSet<String> enumerationValues = new HashSet<String>();
            if (enumerationValueElements != null) {
                for (Element enumerationValueElement : enumerationValueElements) {
                    enumerationValues.add(enumerationValueElement.getTextContent());
                }
            }
            if (scriptingValue != null && scriptingValue.length() > 0) {
                if (enumerationValues.isEmpty()) {
                    processBuilder.addObjectData(name, dataTypeClassName, scriptingValue);
                } else {
                    processBuilder.addEnumData(name, scriptingValue, enumerationValues);
                }
            } else {
                try {
                    Object value = Misc.deserialize(Misc.base64DecodeAndGather(initialValue), parse.getContextProperties());
                    if (enumerationValues.isEmpty()) {
                        processBuilder.addObjectData(name, dataTypeClassName, value);
                    } else {
                        processBuilder.addEnumData(name, enumerationValues, (String)value);
                    }
                }
                catch (Exception e) {
                    throw new BonitaRuntimeException("Error while deserializing", e);
                }
            }
            if (isTransient != null && (isTransientValue = Boolean.parseBoolean(isTransient))) {
                processBuilder.setTransient();
            }
            processBuilder.addDescription(description);
            processBuilder.addLabel(label);
        }
        catch (Exception e) {
            parse.addProblem("Error parsing DataField " + name, e);
        }
        return null;
    }
}

