/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.def.binding;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.parsing.def.binding.ElementBinding;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class ProcessBinding
extends ElementBinding {
    private static final Logger LOGGER = Logger.getLogger(ProcessBinding.class.getName());

    public ProcessBinding() {
        super("process");
    }

    @Override
    public Object parse(Element processElement, Parse parse, Parser parser) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("parsing element = " + processElement);
        }
        String name = null;
        try {
            name = XmlUtil.attribute(processElement, "name");
            String version = XmlUtil.attribute(processElement, "version");
            String description = this.getChildTextContent(processElement, "description");
            String label = this.getChildTextContent(processElement, "label");
            LightProcessDefinition.ProcessType type = this.getEnumValue(LightProcessDefinition.ProcessType.class, this.getChildTextContent(processElement, "type"), LightProcessDefinition.ProcessType.PROCESS);
            ProcessBuilder processBuilder = ProcessBuilder.createProcess(name, version);
            processBuilder.addDescription(description);
            processBuilder.addLabel(label);
            if (LightProcessDefinition.ProcessType.EVENT_SUB_PROCESS.equals((Object)type)) {
                processBuilder.setEventSubProcess();
            }
            parse.pushObject(processBuilder);
            this.parseElementList(processElement, "participants", "participant", parse, parser);
            this.parseElementList(processElement, "data-fields", "data-field", parse, parser);
            this.parseElementList(processElement, "attachments", "attachment", parse, parser);
            this.parseElementList(processElement, "connectors", "connector", parse, parser);
            this.parseElementList(processElement, "activities", "activity", parse, parser);
            this.parseElementList(processElement, "transitions", "transition", parse, parser);
            this.parseElementList(processElement, "categories", "category", parse, parser);
            this.parseElementList(processElement, "event-sub-processes", "event-sub-process", parse, parser);
            parse.popObject();
            return processBuilder.done();
        }
        catch (Exception e) {
            parse.addProblem("Error parsing Process " + name, e);
            return null;
        }
    }

    @Override
    protected <T extends Enum<T>> T getEnumValue(Class<T> enumType, String valueAsString, T defaultValue) {
        if (valueAsString == null) {
            return defaultValue;
        }
        try {
            return Misc.stringToEnum(enumType, valueAsString);
        }
        catch (IllegalArgumentException e) {
            String message = ExceptionManager.getInstance().getMessage("bpx_EB_1", valueAsString, enumType.getName());
            throw new BonitaRuntimeException(message, e);
        }
    }
}

