/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.List;
import java.util.logging.Logger;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.runtime.event.ExecuteJob;
import org.ow2.bonita.util.Misc;

public class JobExecutorThread
implements Runnable {
    private static final Logger LOG = Logger.getLogger(JobExecutorThread.class.getName());
    private final EventExecutor eventExecutor;
    private final List<Long> jobIds;
    private final ProcessInstanceUUID rootInstanceUUID;

    public JobExecutorThread(EventExecutor jobExecutor, ProcessInstanceUUID rootInstanceUUID, List<Long> jobIds) {
        this.eventExecutor = jobExecutor;
        this.jobIds = jobIds;
        this.rootInstanceUUID = rootInstanceUUID;
    }

    @Override
    public void run() {
        LOG.info("executing jobs" + this.jobIds);
        for (Long jobId : this.jobIds) {
            try {
                this.eventExecutor.getCommandService().execute(new ExecuteJob(jobId, this.eventExecutor));
            }
            catch (Throwable e) {
                LOG.severe("Exception in event block: " + Misc.getStackTraceFrom(e));
            }
        }
        this.eventExecutor.notifyJobThreadFinished(this.rootInstanceUUID);
    }
}

