/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.runtime.event.GetExecutableJobIds;
import org.ow2.bonita.runtime.event.GetNextJobDueDate;
import org.ow2.bonita.runtime.event.JobExecutor;
import org.ow2.bonita.runtime.event.JobExecutorThread;

public class MemoryLockJobExecutor
extends JobExecutor {
    private final Object waitForAThreadToBeAvailableSemaphore = new Object();
    private final Vector<ProcessInstanceUUID> locks = new Vector();

    MemoryLockJobExecutor(EventExecutor executor, String name) {
        super(executor, name);
    }

    @Override
    protected Long getNextDueDate() {
        return this.getCommandService().execute(new GetNextJobDueDate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyThreadFinished(ProcessInstanceUUID rootInstanceUUID) {
        Object object = this.waitForAThreadToBeAvailableSemaphore;
        synchronized (object) {
            this.waitForAThreadToBeAvailableSemaphore.notify();
        }
        this.locks.remove(rootInstanceUUID);
    }

    @Override
    public void cleanLocks() {
        this.locks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() throws InterruptedException {
        Map<ProcessInstanceUUID, List<Long>> jobsOfRootInstances = this.getCommandService().execute(new GetExecutableJobIds((Vector)this.locks.clone(), this.getMaxParallelJobs()));
        for (Map.Entry<ProcessInstanceUUID, List<Long>> jobsOfRootInstance : jobsOfRootInstances.entrySet()) {
            this.locks.add(jobsOfRootInstance.getKey());
            JobExecutorThread thread = new JobExecutorThread(this.getEventExecutor(), jobsOfRootInstance.getKey(), jobsOfRootInstance.getValue());
            this.getEventExecutor().getThreadPool().submit(thread);
        }
        while (this.getEventExecutor().getThreadPool().getActiveCount() >= this.getEventExecutor().getNbrOfThreads()) {
            Object object = this.waitForAThreadToBeAvailableSemaphore;
            synchronized (object) {
                this.waitForAThreadToBeAvailableSemaphore.wait(this.getEventExecutor().getLockMillis());
            }
        }
    }

    @Override
    protected String getEventMatcherName() {
        return "Job executor";
    }
}

