/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.search;

import com.thoughtworks.xstream.XStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ow2.bonita.search.DocumentCriterion;
import org.ow2.bonita.search.index.DocumentIndex;
import org.ow2.bonita.util.xml.XStreamUtil;

public class DocumentSearchBuilder
implements Serializable {
    private static final long serialVersionUID = 6226365334784520445L;
    private List<Object> query = new ArrayList<Object>();
    private boolean searchAllVersions = false;

    public DocumentCriterion criterion(DocumentIndex index) {
        DocumentCriterion criterion = new DocumentCriterion(index, this);
        this.query.add(criterion);
        return criterion;
    }

    public DocumentSearchBuilder leftParenthesis() {
        this.query.add("(");
        return this;
    }

    public DocumentSearchBuilder rightParenthesis() {
        this.query.add(")");
        return this;
    }

    public DocumentSearchBuilder or() {
        this.query.add("OR");
        return this;
    }

    public DocumentSearchBuilder and() {
        this.query.add("AND");
        return this;
    }

    public List<Object> getQuery() {
        return this.query;
    }

    public DocumentSearchBuilder allVersion() {
        this.searchAllVersions = true;
        return this;
    }

    public DocumentSearchBuilder latestVersion() {
        this.searchAllVersions = false;
        return this;
    }

    public boolean isSearchAllVersions() {
        return this.searchAllVersions;
    }

    public static DocumentSearchBuilder valueOf(String xmlDocumentSearchBuilder) {
        XStream xstream = XStreamUtil.getDefaultXstream();
        return (DocumentSearchBuilder)xstream.fromXML(xmlDocumentSearchBuilder);
    }

    public String toString() {
        XStream xstream = XStreamUtil.getDefaultXstream();
        return xstream.toXML((Object)this);
    }
}

