/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.privilege.RuleTypePolicy;
import org.ow2.bonita.facade.privilege.impl.RuleImpl;
import org.ow2.bonita.facade.privilege.impl.RuleTypePolicyImpl;
import org.ow2.bonita.persistence.PrivilegeDbSession;
import org.ow2.bonita.persistence.db.HibernateDbSession;
import org.ow2.bonita.services.PrivilegeService;
import org.ow2.bonita.util.EnvTool;

public class DbPrivilegeService
extends HibernateDbSession
implements PrivilegeService {
    private String persistenceServiceName;

    public DbPrivilegeService(String persistenceServiceName) {
        this.persistenceServiceName = persistenceServiceName;
    }

    protected PrivilegeDbSession getDbSession() {
        return EnvTool.getPrivilegeDbSession(this.persistenceServiceName);
    }

    @Override
    public Rule getRule(String ruleUUID) {
        return this.getDbSession().getRule(ruleUUID);
    }

    @Override
    public Rule findRuleByName(String name) {
        return this.getDbSession().findRuleByName(name);
    }

    @Override
    @Deprecated
    public Set<Rule> getRules() {
        List<Rule> results = this.getDbSession().getRules();
        if (results != null) {
            return new HashSet<Rule>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public List<Rule> getAllRules() {
        return this.getDbSession().getRules();
    }

    @Override
    public void addRule(Rule rule) {
        this.getDbSession().save((RuleImpl)rule);
    }

    @Override
    public void deleteRule(Rule rule) {
        this.getDbSession().delete(rule);
    }

    @Override
    public void updateRule(Rule rule) {
    }

    @Override
    @Deprecated
    public Set<Rule> getRulesByNames(Set<String> rulesName) {
        return this.getDbSession().findRulesByNames(rulesName);
    }

    @Override
    public List<Rule> getRules(Collection<String> ruleUUIDs) {
        return this.getDbSession().getRules(ruleUUIDs);
    }

    @Override
    public Set<Rule> getRulesByType(Rule.RuleType ... ruleTypes) {
        HashSet<String> ruleTypesStr = new HashSet<String>();
        for (Rule.RuleType ruleType : ruleTypes) {
            ruleTypesStr.add(ruleType.name());
        }
        return this.getDbSession().getRulesByType(ruleTypesStr);
    }

    @Override
    @Deprecated
    public Set<Rule> getAllApplicableRules(String entityID) {
        return this.getDbSession().getAllApplicableRules(entityID);
    }

    @Override
    @Deprecated
    public Set<Rule> getApplicableRules(String entityID, Rule.RuleType ruleType) {
        return this.getDbSession().getAllApplicableRules(entityID, ruleType);
    }

    @Override
    public RuleTypePolicy getRuleTypePolicy(Rule.RuleType ruleType) {
        RuleTypePolicy ruleTypePolicy = this.getDbSession().getRuleTypePolicy(ruleType);
        if (ruleTypePolicy == null) {
            PrivilegePolicy policy = null;
            switch (ruleType) {
                case CATEGORY_READ: 
                case PROCESS_START: 
                case PROCESS_READ: 
                case ACTIVITY_READ: 
                case ACTIVITY_DETAILS_READ: 
                case CUSTOM: 
                case ASSIGN_TO_ME_STEP: 
                case ASSIGN_TO_STEP: 
                case UNASSIGN_STEP: 
                case CHANGE_PRIORITY_STEP: 
                case PROCESS_INSTANTIATION_DETAILS_VIEW: 
                case PROCESS_ADD_COMMENT: 
                case PROCESS_PDF_EXPORT: 
                case RESUME_STEP: 
                case SUSPEND_STEP: 
                case SKIP_STEP: 
                case REPORT_VIEW: 
                case LOGOUT: 
                case DELEGEE_UPDATE: 
                case PASSWORD_UPDATE: {
                    policy = PrivilegePolicy.ALLOW_BY_DEFAULT;
                    break;
                }
                case PROCESS_MANAGE: 
                case PROCESS_INSTALL: 
                case REPORT_INSTALL: 
                case REPORT_MANAGE: {
                    policy = PrivilegePolicy.DENY_BY_DEFAULT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown default policy for rule type " + ruleType.name());
                }
            }
            ruleTypePolicy = new RuleTypePolicyImpl(ruleType, policy);
            this.getDbSession().save(ruleTypePolicy);
        }
        return ruleTypePolicy;
    }

    @Override
    public void addRuleTypePolicy(RuleTypePolicy ruleTypePolicy) {
        this.getDbSession().save((RuleTypePolicyImpl)ruleTypePolicy);
    }

    @Override
    public void updateRuleTypePolicy(RuleTypePolicy ruleTypePolicy) {
    }

    @Override
    public List<Rule> getRules(Rule.RuleType ruleType, int fromIndex, int pageSige) {
        return this.getDbSession().getRules(ruleType, fromIndex, pageSige);
    }

    @Override
    public long getNumberOfRules(Rule.RuleType ruleType) {
        return this.getDbSession().getNumberOfRules(ruleType);
    }

    @Override
    public Set<String> getExceptions(String entityID, Rule.RuleType ruleType) {
        return this.getDbSession().getAllExceptions(entityID, ruleType);
    }

    @Override
    public List<Rule> getAllApplicableRules(String userUUID, Collection<String> roleUUIDs, Collection<String> groupUUIDs, Collection<String> membershipUUIDs, String entityID) {
        return this.getDbSession().getAllApplicableRules(userUUID, roleUUIDs, groupUUIDs, membershipUUIDs, entityID);
    }

    @Override
    public List<Rule> getApplicableRules(Rule.RuleType ruleType, String userUUID, Collection<String> roleUUIDs, Collection<String> groupUUIDs, Collection<String> membershipUUIDs, String entityID) {
        return this.getDbSession().getApplicableRules(ruleType, userUUID, roleUUIDs, groupUUIDs, membershipUUIDs, entityID);
    }
}

