/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.ow2.bonita.facade.APIAccessor;
import org.ow2.bonita.facade.BAMAPI;
import org.ow2.bonita.facade.CommandAPI;
import org.ow2.bonita.facade.Context;
import org.ow2.bonita.facade.IdentityAPI;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.QueryAPIAccessor;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.RepairAPI;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.WebAPI;
import org.ow2.bonita.facade.ejb.ejb2.EJB2APIAccessorImpl;
import org.ow2.bonita.facade.ejb.ejb2.EJB2QueryAPIAccessorImpl;
import org.ow2.bonita.facade.ejb.ejb3.EJB3APIAccessorImpl;
import org.ow2.bonita.facade.ejb.ejb3.EJB3QueryAPIAccessorImpl;
import org.ow2.bonita.facade.impl.LocalAPIAccessorFactory;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.impl.StandardQueryAPIAccessorImpl;
import org.ow2.bonita.facade.internal.RemoteRuntimeAPI;
import org.ow2.bonita.facade.rest.RESTAPIAccessorImpl;
import org.ow2.bonita.facade.rest.RESTQueryAPIAccessorImpl;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Misc;

public final class AccessorUtil {
    public static final String API_TYPE_PROPERTY = "org.ow2.bonita.api-type";
    public static final String RUNTIMEAPI_JNDINAME = "runtimeAPI";
    public static final String MANAGEMENT_JNDINAME = "managementAPI";
    public static final String DEFINITIONAPI_JNDINAME = "definitionAPI";
    public static final String QUERYRUNTIME_JNDINAME = "queryRuntimeAPI";
    public static final String QUERYDEFINITION_JNDINAME = "queryDefinitionAPI";
    public static final String COMMANDAPI_JNDINAME = "commandAPI";
    public static final String WEBAPI_JNDINAME = "webAPI";
    public static final String IDENTITYAPI_JNDINAME = "identityAPI";
    public static final String BAMAPI_JNDINAME = "bamAPI";
    public static final String REPAIRAPI_JNDINAME = "repairAPI";
    public static final String QUERYLIST_DEFAULT_KEY = "queryList";
    public static final String QUERYLIST_JOURNAL_KEY = "journalQueryList";
    public static final String QUERYLIST_HISTORY_KEY = "historyQueryList";
    private static final Logger LOG = Logger.getLogger(AccessorUtil.class.getName());
    protected static final ThreadLocal<Context> CONTEXT = new ThreadLocal<Context>(){

        @Override
        protected Context initialValue() {
            return AccessorUtil.resetContext();
        }
    };

    public static Context resetContext() {
        String apiType = System.getProperty(API_TYPE_PROPERTY);
        if (System.getProperty(API_TYPE_PROPERTY) != null) {
            Context context = Misc.stringToEnum(Context.class, apiType);
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("API-Type: " + (Object)((Object)context) + " has been specified through property: " + API_TYPE_PROPERTY);
            }
            CONTEXT.set(context);
            return context;
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Property: org.ow2.bonita.api-type has not been specified for api-type. Trying to autodetect it.");
        }
        try {
            LocalAPIAccessorFactory.getStandardServerAPIAccessor();
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info(AccessorUtil.class.getName() + " called from server side. Using " + (Object)((Object)Context.Standard) + " context.");
            }
            return Context.Standard;
        }
        catch (BonitaRuntimeException e) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info(AccessorUtil.class.getName() + " called from client side. Trying to autodetect apiType.");
            }
            try {
                RemoteRuntimeAPI.class.cast(Misc.lookup(RUNTIMEAPI_JNDINAME, null));
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info((Object)((Object)Context.EJB3) + " context found: EJB3 api-type will be used.");
                }
                return Context.EJB3;
            }
            catch (NamingException ne) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("No context found: assuming J2SE. Standard api-type will be used. Note that this may not be what you want. In this case, either specify the api-type in the environment or via the property: org.ow2.bonita.api-type");
                }
                return Context.Standard;
            }
            catch (ClassCastException cceEJB3) {
                return Context.EJB2;
            }
        }
    }

    private AccessorUtil() {
    }

    public static QueryAPIAccessor getQueryAPIAccessor(Hashtable<String, String> jndiEnvironment) {
        switch (CONTEXT.get()) {
            case EJB2: {
                return new EJB2QueryAPIAccessorImpl(jndiEnvironment);
            }
            case EJB3: {
                return new EJB3QueryAPIAccessorImpl(jndiEnvironment);
            }
            case REST: {
                return new RESTQueryAPIAccessorImpl();
            }
        }
        return new StandardQueryAPIAccessorImpl();
    }

    public static APIAccessor getAPIAccessor(Hashtable<String, String> jndiEnvironment) {
        switch (CONTEXT.get()) {
            case EJB2: {
                return new EJB2APIAccessorImpl(jndiEnvironment);
            }
            case EJB3: {
                return new EJB3APIAccessorImpl(jndiEnvironment);
            }
            case REST: {
                return new RESTAPIAccessorImpl();
            }
        }
        return new StandardAPIAccessorImpl();
    }

    public static APIAccessor getAPIAccessor() {
        return AccessorUtil.getAPIAccessor(null);
    }

    public static QueryAPIAccessor getQueryAPIAccessor() {
        return AccessorUtil.getQueryAPIAccessor(null);
    }

    public static RuntimeAPI getRuntimeAPI() {
        return AccessorUtil.getAPIAccessor().getRuntimeAPI();
    }

    public static ManagementAPI getManagementAPI() {
        return AccessorUtil.getAPIAccessor().getManagementAPI();
    }

    public static CommandAPI getCommandAPI() {
        return AccessorUtil.getAPIAccessor().getCommandAPI();
    }

    public static QueryRuntimeAPI getQueryRuntimeAPI() {
        return AccessorUtil.getAPIAccessor().getQueryRuntimeAPI();
    }

    public static QueryRuntimeAPI getQueryRuntimeAPI(String queryList) {
        return AccessorUtil.getAPIAccessor().getQueryRuntimeAPI(queryList);
    }

    public static QueryDefinitionAPI getQueryDefinitionAPI() {
        return AccessorUtil.getAPIAccessor().getQueryDefinitionAPI();
    }

    public static WebAPI getWebAPI() {
        return AccessorUtil.getAPIAccessor().getWebAPI();
    }

    public static BAMAPI getBAMAPI() {
        return AccessorUtil.getAPIAccessor().getBAMAPI();
    }

    public static BAMAPI getBAMAPI(String queryList) {
        return AccessorUtil.getAPIAccessor().getBAMAPI(queryList);
    }

    public static QueryDefinitionAPI getQueryDefinitionAPI(String queryList) {
        return AccessorUtil.getAPIAccessor().getQueryDefinitionAPI(queryList);
    }

    public static IdentityAPI getIdentityAPI() {
        return AccessorUtil.getAPIAccessor().getIdentityAPI();
    }

    public static RepairAPI getRepairAPI() {
        return AccessorUtil.getAPIAccessor().getRepairAPI();
    }
}

