/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.type.Converter;
import org.ow2.bonita.type.Type;
import org.ow2.bonita.type.Variable;
import org.ow2.bonita.type.VariableTypeResolver;
import org.ow2.bonita.type.variable.NullVariable;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.GroovyUtil;
import org.ow2.bonita.util.Misc;
import org.w3c.dom.Document;

public abstract class VariableUtil {
    public static final String DEPLOYMENT_IDPREFIX = "deployment$";

    protected VariableUtil() {
    }

    public static Map<String, Variable> createVariableMap(ProcessDefinitionUUID processUUID, Map<String, Object> variables) {
        if (variables == null || variables.isEmpty()) {
            return null;
        }
        HashMap<String, Variable> variableMap = new HashMap<String, Variable>();
        for (Map.Entry<String, Object> e : variables.entrySet()) {
            Object value = e.getValue();
            variableMap.put(e.getKey(), VariableUtil.createVariable(processUUID, e.getKey(), value));
        }
        return variableMap;
    }

    public static Variable createVariable(ProcessDefinitionUUID processUUID, String key, Object value) {
        Type type = null;
        VariableTypeResolver variableTypeResolver = EnvTool.getVariableTypeResolver();
        if (variableTypeResolver != null) {
            type = variableTypeResolver.findTypeByMatch(key, value);
        }
        Variable variable = null;
        if (type != null) {
            Class<?> variableClass = type.getVariableClass();
            try {
                variable = (Variable)variableClass.newInstance();
                variable.setProcessUUID(processUUID);
            }
            catch (Exception e) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_EI_14", variableClass.getName());
                throw new BonitaRuntimeException(message);
            }
            Converter converter = type.getConverter();
            variable.setConverter(converter);
        } else if (value == null) {
            variable = new NullVariable();
        } else {
            throw new BonitaRuntimeException("The value of variable '" + key + "' of process " + processUUID + " is not Serializable");
        }
        variable.setKey(key);
        variable.setValue(value);
        return variable;
    }

    public static Map<String, Variable> copyVariableMap(ProcessDefinitionUUID processUUID, Map<String, Variable> variables) {
        if (variables == null || variables.isEmpty()) {
            return null;
        }
        HashMap<String, Variable> variableMap = new HashMap<String, Variable>();
        for (Map.Entry<String, Variable> e : variables.entrySet()) {
            Variable var = VariableUtil.copyVariable(e.getValue());
            variableMap.put(var.getKey(), var);
        }
        return variableMap;
    }

    public static Variable copyVariable(Variable var) {
        Object value = var.getValue();
        String key = var.getKey();
        return VariableUtil.createVariable(var.getProcessUUID(), key, value);
    }

    public static Map<String, Variable> createVariables(Collection<DataFieldDefinition> datafields, ProcessInstanceUUID instanceUUID, Map<String, Object> context) {
        if (datafields == null || datafields.isEmpty()) {
            return null;
        }
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        for (DataFieldDefinition df : datafields) {
            if (df.isTransient()) continue;
            Object value = df.getInitialValue();
            value = VariableUtil.evaluateInitialValue(instanceUUID, df, value, context);
            variables.put(df.getName(), VariableUtil.createVariable(df.getProcessDefinitionUUID(), df.getName(), value));
        }
        return variables;
    }

    private static Object evaluateInitialValue(ProcessInstanceUUID instanceUUID, DataFieldDefinition df, Object value, Map<String, Object> context) {
        String script;
        if (value == null && (script = df.getScriptingValue()) != null) {
            try {
                value = instanceUUID != null ? GroovyUtil.evaluate(script, context, instanceUUID, false, false) : GroovyUtil.evaluate(script, context, df.getProcessDefinitionUUID(), false);
                if (df.getDataTypeClassName().equals(Document.class.getName()) && value instanceof String) {
                    value = Misc.generateDocument((String)value);
                }
            }
            catch (Exception e) {
                try {
                    value = GroovyUtil.evaluate(script, context);
                }
                catch (GroovyException e1) {
                    StringBuilder stb = new StringBuilder("Error while initializing variable: '");
                    stb.append(df.getName());
                    stb.append("'. ");
                    throw new BonitaRuntimeException(stb.toString(), e);
                }
            }
        }
        return value;
    }

    public static Map<String, Object> createTransientVariables(Collection<DataFieldDefinition> datafields, ProcessInstanceUUID instanceUUID) {
        if (datafields == null || datafields.isEmpty()) {
            return null;
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (DataFieldDefinition df : datafields) {
            if (!df.isTransient()) continue;
            Object value = df.getInitialValue();
            value = VariableUtil.evaluateInitialValue(instanceUUID, df, value, null);
            variables.put(df.getName(), value);
        }
        return variables;
    }

    public static Map<String, Object> getVariableValues(Map<String, Variable> variableMap) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (variableMap != null) {
            for (Variable var : variableMap.values()) {
                res.put(var.getKey(), var.getValue());
            }
        }
        return res;
    }
}

