/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionSynchronizationRegistry;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionImpl;

public class TransactionSynchronizationRegistryImpl
implements Referenceable,
TransactionSynchronizationRegistry {
    private static TransactionSynchronizationRegistryImpl instanceTSR = new TransactionSynchronizationRegistryImpl();

    public static TransactionSynchronizationRegistryImpl getInstance() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"getInstance", new Object[0]);
        }
        return instanceTSR;
    }

    public Object getTransactionKey() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"getTransactionKey", new Object[0]);
        }
        try {
            return Current.getTransactionManager().getTransaction();
        }
        catch (SystemException ex) {
            return null;
        }
    }

    public void putResource(Object key, Object value) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"putResource", new Object[0]);
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        try {
            TransactionImpl tran = (TransactionImpl)Current.getTransactionManager().getTransaction();
            if (tran == null) {
                throw new IllegalStateException("Cannot find Transaction for putResource");
            }
            tran.putUserResource(key, value);
        }
        catch (SystemException ex) {
            throw new IllegalStateException("Cannot getTransaction");
        }
    }

    public Object getResource(Object key) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"getResource", new Object[0]);
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        try {
            TransactionImpl tran = (TransactionImpl)Current.getTransactionManager().getTransaction();
            if (tran == null) {
                throw new IllegalStateException("Cannot find Transaction for getResource");
            }
            return tran.getUserResource(key);
        }
        catch (SystemException ex) {
            throw new IllegalStateException("Cannot getTransaction");
        }
    }

    public void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"registerInterposedSynchronization", new Object[0]);
        }
        try {
            TransactionImpl tx = (TransactionImpl)Current.getTransactionManager().getTransaction();
            if (tx == null) {
                throw new IllegalStateException("Cannot find Transaction for registerInterposedSynchronization");
            }
            tx.registerInterposedSynchronization(sync);
        }
        catch (SystemException ex) {
            throw new IllegalStateException("Cannot getTransaction");
        }
    }

    public int getTransactionStatus() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"getTransactionStatus", new Object[0]);
        }
        try {
            int mystatus = Current.getTransactionManager().getStatus();
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("mystatus=" + mystatus), new Object[0]);
            }
            return mystatus;
        }
        catch (SystemException ex) {
            return 6;
        }
    }

    public void setRollbackOnly() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"setRollbackOnly", new Object[0]);
        }
        try {
            Current.getTransactionManager().setRollbackOnly();
        }
        catch (SystemException ex) {
            throw new IllegalStateException("Cannot setRollbackOnly");
        }
    }

    public boolean getRollbackOnly() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"getRollbackOnly", new Object[0]);
        }
        int status = this.getTransactionStatus();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("status=" + status), new Object[0]);
        }
        if (status == 6) {
            throw new IllegalStateException("Cannot getTransactionStatus");
        }
        return status == 1 || status == 9;
    }

    public Reference getReference() throws NamingException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TSRImpl.getReference()", new Object[0]);
        }
        return new Reference(this.getClass().getName(), "org.objectweb.jotm.TransactionSynchronizationRegistryFactory", null);
    }
}

