/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: HeuristicRollbackException.java 1506 2007-06-30 15:34:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.transaction;
 
/**
 * This exception is thrown by the commit operation to report
 * that a heuristic decision was made and that all relevant
 * updates have been rolled back.
 * @author Guillaume Sauthier
 */
public class HeuristicRollbackException extends Exception {

    /**
     * Serial Version UID.
     * TODO Check for interop
     */
    private static final long serialVersionUID = -3483618944556408897L;

    /**
     * Creates a new HeuristicRollbackException.
     */
    public HeuristicRollbackException() {
    }

    /**
     * Creates a new HeuristicRollbackException.
     * @param msg Exception message
     */
    public HeuristicRollbackException(String msg) {
        super(msg);
    }

}
